/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.prefix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.prefix.InternalIpPrefix;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public final class IpPrefixAggregator
extends BucketsAggregator {
    final ValuesSourceConfig config;
    final long minDocCount;
    final boolean keyed;
    final BytesKeyedBucketOrds bucketOrds;
    final IpPrefix ipPrefix;

    public IpPrefixAggregator(String name, AggregatorFactories factories, ValuesSourceConfig config, boolean keyed, long minDocCount, IpPrefix ipPrefix, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
        this.config = config;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.bucketOrds = BytesKeyedBucketOrds.build(this.bigArrays(), cardinality);
        this.ipPrefix = ipPrefix;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        SortedBinaryDocValues values = this.config.getValuesSource().bytesValues(aggCtx.getLeafReaderContext());
        BinaryDocValues singleton = FieldData.unwrapSingleton(values);
        return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub);
    }

    private LeafBucketCollector getLeafCollector(final SortedBinaryDocValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    BytesRef previousSubnet = null;
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        BytesRef subnet = new BytesRef(new byte[IpPrefixAggregator.this.ipPrefix.netmask.length]);
                        IpPrefixAggregator.maskIpAddress(values.nextValue(), IpPrefixAggregator.this.ipPrefix.netmask, subnet);
                        if (previousSubnet != null && subnet.bytesEquals(previousSubnet)) continue;
                        IpPrefixAggregator.this.addBucketOrd(IpPrefixAggregator.this.bucketOrds.add(owningBucketOrd, subnet), doc, sub);
                        previousSubnet = subnet;
                    }
                }
            }
        };
    }

    private LeafBucketCollector getLeafCollector(final BinaryDocValues values, final LeafBucketCollector sub) {
        final BytesRef subnet = new BytesRef(new byte[this.ipPrefix.netmask.length]);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    IpPrefixAggregator.maskIpAddress(values.binaryValue(), IpPrefixAggregator.this.ipPrefix.netmask, subnet);
                    IpPrefixAggregator.this.addBucketOrd(IpPrefixAggregator.this.bucketOrds.add(owningBucketOrd, subnet), doc, sub);
                }
            }
        };
    }

    private void addBucketOrd(long bucketOrd, int doc, LeafBucketCollector sub) throws IOException {
        if (bucketOrd < 0L) {
            bucketOrd = -1L - bucketOrd;
            this.collectExistingBucket(sub, doc, bucketOrd);
        } else {
            this.collectBucket(sub, doc, bucketOrd);
        }
    }

    private static void maskIpAddress(BytesRef ipAddress, BytesRef subnetMask, BytesRef subnet) {
        assert (ipAddress.length == 16) : "Invalid length for ip address [" + ipAddress.length + "] expected 16 bytes";
        int offset = subnetMask.length == 4 ? 12 : 0;
        for (int i = 0; i < subnetMask.length; ++i) {
            subnet.bytes[i] = (byte)(ipAddress.bytes[i + offset] & subnetMask.bytes[i]);
        }
    }

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        long totalOrdsToCollect = 0L;
        try (IntArray bucketsInOrd = this.bigArrays().newIntArray(owningBucketOrds.size());){
            InternalAggregation[] internalAggregationArray;
            block15: {
                for (long ordIdx2 = 0L; ordIdx2 < owningBucketOrds.size(); ++ordIdx2) {
                    long bucketCount = this.bucketOrds.bucketsInOrd(owningBucketOrds.get(ordIdx2));
                    bucketsInOrd.set(ordIdx2, (int)bucketCount);
                    totalOrdsToCollect += bucketCount;
                }
                LongArray bucketOrdsToCollect = this.bigArrays().newLongArray(totalOrdsToCollect);
                try {
                    int[] b = new int[]{0};
                    for (long i = 0L; i < owningBucketOrds.size(); ++i) {
                        BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds.get(i));
                        while (ordsEnum.next()) {
                            int n = b[0];
                            b[0] = n + 1;
                            bucketOrdsToCollect.set(n, ordsEnum.ord());
                        }
                    }
                    IntFunction<InternalAggregations> subAggregationResults = this.buildSubAggsForBuckets(bucketOrdsToCollect);
                    b[0] = 0;
                    internalAggregationArray = this.buildAggregations(Math.toIntExact(owningBucketOrds.size()), ordIdx -> {
                        ArrayList<InternalIpPrefix.Bucket> buckets = new ArrayList<InternalIpPrefix.Bucket>(bucketsInOrd.get(ordIdx));
                        BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds.get(ordIdx));
                        while (ordsEnum.next()) {
                            long ordinal = ordsEnum.ord();
                            if (bucketOrdsToCollect.get(b[0]) != ordinal) {
                                throw AggregationErrors.iterationOrderChangedWithoutMutating(this.bucketOrds.toString(), ordinal, bucketOrdsToCollect.get(b[0]));
                            }
                            BytesRef ipAddress = new BytesRef();
                            ordsEnum.readValue(ipAddress);
                            long docCount = this.bucketDocCount(ordinal);
                            this.checkRealMemoryCBForInternalBucket();
                            int n = b[0];
                            b[0] = n + 1;
                            buckets.add(new InternalIpPrefix.Bucket(BytesRef.deepCopyOf((BytesRef)ipAddress), this.ipPrefix.isIpv6, this.ipPrefix.prefixLength, this.ipPrefix.appendPrefixLength, docCount, (InternalAggregations)subAggregationResults.apply(n)));
                            CollectionUtil.introSort(buckets, BucketOrder.key(true).comparator());
                        }
                        return new InternalIpPrefix(this.name, this.config.format(), this.keyed, this.minDocCount, buckets, this.metadata());
                    });
                    if (bucketOrdsToCollect == null) break block15;
                }
                catch (Throwable throwable) {
                    if (bucketOrdsToCollect != null) {
                        try {
                            bucketOrdsToCollect.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                bucketOrdsToCollect.close();
            }
            return internalAggregationArray;
        }
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalIpPrefix(this.name, this.config.format(), this.keyed, this.minDocCount, Collections.emptyList(), this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    public static class IpPrefix {
        final boolean isIpv6;
        final int prefixLength;
        final boolean appendPrefixLength;
        final BytesRef netmask;

        public IpPrefix(boolean isIpv6, int prefixLength, boolean appendPrefixLength, BytesRef netmask) {
            this.isIpv6 = isIpv6;
            this.prefixLength = prefixLength;
            this.appendPrefixLength = appendPrefixLength;
            this.netmask = netmask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IpPrefix ipPrefix = (IpPrefix)o;
            return this.isIpv6 == ipPrefix.isIpv6 && this.prefixLength == ipPrefix.prefixLength && this.appendPrefixLength == ipPrefix.appendPrefixLength && Objects.equals(this.netmask, ipPrefix.netmask);
        }

        public int hashCode() {
            return Objects.hash(this.isIpv6, this.prefixLength, this.appendPrefixLength, this.netmask);
        }
    }

    public static class Unmapped
    extends NonCollectingAggregator {
        private final ValuesSourceConfig config;
        private final boolean keyed;
        private final long minDocCount;

        protected Unmapped(String name, AggregatorFactories factories, ValuesSourceConfig config, boolean keyed, long minDocCount, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, factories, metadata);
            this.config = config;
            this.keyed = keyed;
            this.minDocCount = minDocCount;
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            return new InternalIpPrefix(this.name, this.config.format(), this.keyed, this.minDocCount, Collections.emptyList(), this.metadata());
        }
    }
}

