/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.LongBitSet;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.MapStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.NumericTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.StringTermsAggregatorFromFilters;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregatorSupplier;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.xcontent.ParseField;

public class TermsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    static Boolean REMAP_GLOBAL_ORDS;
    static Boolean COLLECT_SEGMENT_ORDS;
    private static final Logger logger;
    static final long MAX_ORDS_TO_TRY_FILTERS = 1000L;
    private final TermsAggregatorSupplier aggregatorSupplier;
    private final BucketOrder order;
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private final Aggregator.SubAggCollectionMode collectMode;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final boolean showTermDocCountError;
    private final boolean excludeDeletedDocs;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(TermsAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.KEYWORD, CoreValuesSourceType.IP), TermsAggregatorFactory.bytesSupplier(), true);
        builder.register(TermsAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.NUMERIC), TermsAggregatorFactory.numericSupplier(), true);
    }

    private static TermsAggregatorSupplier bytesSupplier() {
        return (name, factories, valuesSourceConfig, order, bucketCountThresholds, includeExclude, executionHint, context, parent, subAggCollectMode, showTermDocCountError, cardinality, metadata, excludeDeletedDocs) -> {
            long maxOrd;
            ValuesSource valuesSource = valuesSourceConfig.getValuesSource();
            ExecutionMode execution = null;
            if (executionHint != null) {
                execution = ExecutionMode.fromString(executionHint);
            } else if (SignificantTermsAggregatorFactory.matchNoDocs(context, parent) && bucketCountThresholds.getMinDocCount() > 0L) {
                execution = ExecutionMode.MAP;
            }
            if (!valuesSource.hasOrdinals()) {
                execution = ExecutionMode.MAP;
            }
            if (execution == null) {
                execution = ExecutionMode.GLOBAL_ORDINALS;
            }
            long l = maxOrd = execution == ExecutionMode.GLOBAL_ORDINALS ? TermsAggregatorFactory.getMaxOrd(valuesSource, context.searcher()) : -1L;
            if (subAggCollectMode == null) {
                subAggCollectMode = TermsAggregatorFactory.pickSubAggColectMode(factories, bucketCountThresholds.getShardSize(), maxOrd);
            }
            if (includeExclude != null && includeExclude.isRegexBased() && valuesSourceConfig.format() != DocValueFormat.RAW) {
                throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
            }
            logger.debug("Creating bytes terms aggregator with execution mode [{}]", (Object)execution);
            return execution.create(name, factories, valuesSourceConfig, order, bucketCountThresholds, includeExclude, context, parent, subAggCollectMode, showTermDocCountError, cardinality, metadata, excludeDeletedDocs);
        };
    }

    private static TermsAggregatorSupplier numericSupplier() {
        return (name, factories, valuesSourceConfig, order, bucketCountThresholds, includeExclude, executionHint, context, parent, subAggCollectMode, showTermDocCountError, cardinality, metadata, excludeDeletedDocs) -> {
            Function<NumericTermsAggregator, NumericTermsAggregator.ResultStrategy<?, ?>> resultStrategy;
            if (includeExclude != null && includeExclude.isRegexBased()) {
                throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
            }
            if (subAggCollectMode == null) {
                subAggCollectMode = TermsAggregatorFactory.pickSubAggColectMode(factories, bucketCountThresholds.getShardSize(), -1L);
            }
            ValuesSource.Numeric numericValuesSource = (ValuesSource.Numeric)valuesSourceConfig.getValuesSource();
            IncludeExclude.LongFilter longFilter = null;
            if (numericValuesSource.isFloatingPoint()) {
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToDoubleFilter();
                }
                resultStrategy = agg -> {
                    NumericTermsAggregator numericTermsAggregator = agg;
                    Objects.requireNonNull(numericTermsAggregator);
                    return numericTermsAggregator.new NumericTermsAggregator.DoubleTermsResults(showTermDocCountError, (Aggregator)agg);
                };
            } else {
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToLongFilter(valuesSourceConfig.format());
                }
                resultStrategy = agg -> {
                    NumericTermsAggregator numericTermsAggregator = agg;
                    Objects.requireNonNull(numericTermsAggregator);
                    return numericTermsAggregator.new NumericTermsAggregator.LongTermsResults(showTermDocCountError, (Aggregator)agg);
                };
            }
            return new NumericTermsAggregator(name, factories, resultStrategy, numericValuesSource, valuesSourceConfig.format(), order, bucketCountThresholds, context, parent, subAggCollectMode, longFilter, cardinality, metadata, excludeDeletedDocs);
        };
    }

    TermsAggregatorFactory(String name, ValuesSourceConfig config, BucketOrder order, IncludeExclude includeExclude, String executionHint, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, boolean showTermDocCountError, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, TermsAggregatorSupplier aggregatorSupplier, boolean excludeDeletedDocs) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.aggregatorSupplier = aggregatorSupplier;
        this.order = order;
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.collectMode = collectMode;
        this.bucketCountThresholds = bucketCountThresholds;
        this.showTermDocCountError = showTermDocCountError;
        this.excludeDeletedDocs = excludeDeletedDocs;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedTerms aggregation = new UnmappedTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), metadata);
        NonCollectingAggregator agg = new NonCollectingAggregator(this, this.name, this.context, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
        this.order.validate(agg);
        return agg;
    }

    private static boolean isAggregationSort(BucketOrder order) {
        if (order instanceof InternalOrder.Aggregation) {
            return true;
        }
        if (order instanceof InternalOrder.CompoundOrder) {
            InternalOrder.CompoundOrder compoundOrder = (InternalOrder.CompoundOrder)order;
            return compoundOrder.orderElements().stream().anyMatch(TermsAggregatorFactory::isAggregationSort);
        }
        return false;
    }

    public static TermsAggregator.BucketCountThresholds adjustBucketCountThresholds(TermsAggregator.BucketCountThresholds bucketCountThresholds, BucketOrder order) {
        TermsAggregator.BucketCountThresholds newBucketCountThresholds = new TermsAggregator.BucketCountThresholds(bucketCountThresholds);
        if (!InternalOrder.isKeyOrder(order) && newBucketCountThresholds.getShardSize() == TermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.shardSize()) {
            newBucketCountThresholds.setShardSize(BucketUtils.suggestShardSideQueueSize(newBucketCountThresholds.getRequiredSize()));
        }
        newBucketCountThresholds.ensureValidity();
        return newBucketCountThresholds;
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        TermsAggregator.BucketCountThresholds adjusted = TermsAggregatorFactory.adjustBucketCountThresholds(this.bucketCountThresholds, this.order);
        if (this.getSamplingContext().map(SamplingContext::isSampled).orElse(false).booleanValue() && (adjusted.getMinDocCount() > 1L || adjusted.getShardMinDocCount() > 1L)) {
            throw new ElasticsearchStatusException("aggregation [{}] is within a sampling context; min_doc_count, provided [{}], and min_shard_doc_count, provided [{}], cannot be greater than 1", RestStatus.BAD_REQUEST, this.name(), adjusted.getMinDocCount(), adjusted.getShardMinDocCount());
        }
        return this.aggregatorSupplier.build(this.name, this.factories, this.config, this.order, adjusted, this.includeExclude, this.executionHint, this.context, parent, this.collectMode, this.showTermDocCountError, cardinality, metadata, this.excludeDeletedDocs);
    }

    static Aggregator.SubAggCollectionMode pickSubAggColectMode(AggregatorFactories factories, int expectedSize, long maxOrd) {
        if (factories.countAggregators() == 0) {
            return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
        }
        if (expectedSize == Integer.MAX_VALUE) {
            return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
        }
        if (maxOrd == -1L || maxOrd > (long)expectedSize) {
            return Aggregator.SubAggCollectionMode.BREADTH_FIRST;
        }
        return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
    }

    private static long getMaxOrd(ValuesSource source, IndexSearcher searcher) throws IOException {
        if (source instanceof ValuesSource.Bytes.WithOrdinals) {
            ValuesSource.Bytes.WithOrdinals valueSourceWithOrdinals = (ValuesSource.Bytes.WithOrdinals)source;
            return valueSourceWithOrdinals.globalMaxOrd(searcher.getIndexReader());
        }
        return -1L;
    }

    public static SortedSetDocValues globalOrdsValues(AggregationContext context, ValuesSource.Bytes.WithOrdinals valuesSource) throws IOException {
        IndexReader reader = context.searcher().getIndexReader();
        if (reader.leaves().isEmpty()) {
            return DocValues.emptySortedSet();
        }
        return valuesSource.globalOrdinalsValues((LeafReaderContext)reader.leaves().get(0));
    }

    public static LongPredicate gloabalOrdsFilter(IncludeExclude includeExclude, DocValueFormat format, SortedSetDocValues values) throws IOException {
        if (includeExclude == null) {
            return GlobalOrdinalsStringTermsAggregator.ALWAYS_TRUE;
        }
        return arg_0 -> ((LongBitSet)includeExclude.convertToOrdinalsFilter(format).acceptedGlobalOrdinals(values)).get(arg_0);
    }

    static {
        logger = LogManager.getLogger(TermsAggregatorFactory.class);
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSourceConfig valuesSourceConfig, BucketOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata, boolean excludeDeletedDocs) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(valuesSourceConfig.format());
                return new MapStringTermsAggregator(name, factories, new MapStringTermsAggregator.ValuesSourceCollectorSource(valuesSourceConfig), a -> {
                    MapStringTermsAggregator mapStringTermsAggregator = a;
                    Objects.requireNonNull(mapStringTermsAggregator);
                    return mapStringTermsAggregator.new MapStringTermsAggregator.StandardTermsResults(valuesSourceConfig.getValuesSource(), (Aggregator)a);
                }, order, valuesSourceConfig.format(), bucketCountThresholds, filter, context, parent, subAggCollectMode, showTermDocCountError, cardinality, metadata, excludeDeletedDocs);
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSourceConfig valuesSourceConfig, BucketOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata, boolean excludeDeletedDocs) throws IOException {
                boolean remapGlobalOrds;
                StringTermsAggregatorFromFilters adapted;
                assert (valuesSourceConfig.getValuesSource() instanceof ValuesSource.Bytes.WithOrdinals);
                ValuesSource.Bytes.WithOrdinals ordinalsValuesSource = (ValuesSource.Bytes.WithOrdinals)valuesSourceConfig.getValuesSource();
                SortedSetDocValues values = TermsAggregatorFactory.globalOrdsValues(context, ordinalsValuesSource);
                long maxOrd = values.getValueCount();
                if (maxOrd > 0L && maxOrd <= 1000L && context.enableRewriteToFilterByFilter() && !context.isInSortOrderExecutionRequired() && !excludeDeletedDocs && (adapted = StringTermsAggregatorFromFilters.adaptIntoFiltersOrNull(name, factories, context, parent, showTermDocCountError, cardinality, metadata, valuesSourceConfig, order, bucketCountThresholds, TermsAggregatorFactory.gloabalOrdsFilter(includeExclude, valuesSourceConfig.format(), values), () -> TermsAggregatorFactory.globalOrdsValues(context, ordinalsValuesSource))) != null) {
                    logger.debug("Using adapted fiter-by-filter implementation");
                    return adapted;
                }
                double ratio = (double)maxOrd / (double)context.searcher().getIndexReader().numDocs();
                if (factories == AggregatorFactories.EMPTY && includeExclude == null && cardinality == CardinalityUpperBound.ONE && ordinalsValuesSource.supportsGlobalOrdinalsMapping() && (COLLECT_SEGMENT_ORDS != null ? COLLECT_SEGMENT_ORDS != false : ratio <= 0.5 && maxOrd <= 2048L)) {
                    logger.debug("Using low cardinality global ordinals implementation");
                    return new GlobalOrdinalsStringTermsAggregator.LowCardinality(name, factories, a -> (GlobalOrdinalsStringTermsAggregator)a.new GlobalOrdinalsStringTermsAggregator.StandardTermsResults(), ordinalsValuesSource, () -> TermsAggregatorFactory.globalOrdsValues(context, ordinalsValuesSource), order, valuesSourceConfig.format(), bucketCountThresholds, context, parent, false, subAggCollectMode, showTermDocCountError, metadata, excludeDeletedDocs);
                }
                if (cardinality == CardinalityUpperBound.ONE && REMAP_GLOBAL_ORDS != null) {
                    remapGlobalOrds = REMAP_GLOBAL_ORDS;
                } else {
                    remapGlobalOrds = true;
                    if (includeExclude == null && cardinality == CardinalityUpperBound.ONE && (factories == AggregatorFactories.EMPTY || !TermsAggregatorFactory.isAggregationSort(order) && subAggCollectMode == Aggregator.SubAggCollectionMode.BREADTH_FIRST)) {
                        remapGlobalOrds = false;
                    }
                }
                logger.debug("Using standard global ordinals implementation.  remap is [{}]", (Object)remapGlobalOrds);
                return new GlobalOrdinalsStringTermsAggregator(name, factories, a -> (GlobalOrdinalsStringTermsAggregator)a.new GlobalOrdinalsStringTermsAggregator.StandardTermsResults(), ordinalsValuesSource, () -> TermsAggregatorFactory.globalOrdsValues(context, ordinalsValuesSource), order, valuesSourceConfig.format(), bucketCountThresholds, TermsAggregatorFactory.gloabalOrdsFilter(includeExclude, valuesSourceConfig.format(), values), context, parent, remapGlobalOrds, subAggCollectMode, showTermDocCountError, cardinality, metadata, excludeDeletedDocs);
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value) {
            return switch (value) {
                case "global_ordinals" -> GLOBAL_ORDINALS;
                case "map" -> MAP;
                default -> throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map, global_ordinals]");
            };
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSourceConfig var3, BucketOrder var4, TermsAggregator.BucketCountThresholds var5, IncludeExclude var6, AggregationContext var7, Aggregator var8, Aggregator.SubAggCollectionMode var9, boolean var10, CardinalityUpperBound var11, Map<String, Object> var12, boolean var13) throws IOException;

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

