/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.profile.SearchProfileShardResult;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class SearchProfileResults
implements Writeable,
ToXContentFragment {
    private static final Logger logger = LogManager.getLogger(SearchProfileResults.class);
    public static final String ID_FIELD = "id";
    private static final String NODE_ID_FIELD = "node_id";
    private static final String CLUSTER_FIELD = "cluster";
    private static final String INDEX_NAME_FIELD = "index";
    private static final String SHARD_ID_FIELD = "shard_id";
    public static final String SHARDS_FIELD = "shards";
    public static final String PROFILE_FIELD = "profile";
    private final Map<String, SearchProfileShardResult> shardResults;
    private static final Pattern SHARD_ID_DECOMPOSITION = Pattern.compile("\\[([^]]+)\\]\\[([^]]+)\\]\\[(\\d+)\\]");

    public SearchProfileResults(Map<String, SearchProfileShardResult> shardResults) {
        this.shardResults = Collections.unmodifiableMap(shardResults);
    }

    public SearchProfileResults(StreamInput in) throws IOException {
        this.shardResults = in.readMap(SearchProfileShardResult::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.shardResults, StreamOutput::writeWriteable);
    }

    public Map<String, SearchProfileShardResult> getShardResults() {
        return this.shardResults;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(PROFILE_FIELD).startArray(SHARDS_FIELD);
        TreeSet<String> sortedKeys = new TreeSet<String>(this.shardResults.keySet());
        for (String key : sortedKeys) {
            builder.startObject();
            builder.field(ID_FIELD, key);
            ShardProfileId shardProfileId = SearchProfileResults.parseCompositeProfileShardId(key);
            if (shardProfileId != null) {
                builder.field(NODE_ID_FIELD, shardProfileId.nodeId());
                builder.field(SHARD_ID_FIELD, shardProfileId.shardId());
                builder.field(INDEX_NAME_FIELD, shardProfileId.indexName());
                String cluster = shardProfileId.clusterName();
                if (cluster == null) {
                    cluster = "(local)";
                }
                builder.field(CLUSTER_FIELD, cluster);
            }
            SearchProfileShardResult shardResult = this.shardResults.get(key);
            shardResult.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray().endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchProfileResults other = (SearchProfileResults)obj;
        return this.shardResults.equals(other.shardResults);
    }

    public int hashCode() {
        return this.shardResults.hashCode();
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static ShardProfileId parseCompositeProfileShardId(String compositeId) {
        assert (!Strings.isNullOrEmpty(compositeId)) : "An empty id should not be passed to parseCompositeProfileShardId";
        Matcher m = SHARD_ID_DECOMPOSITION.matcher(compositeId);
        if (m.find()) {
            String nodeId = m.group(1);
            String[] tokens = RemoteClusterAware.splitIndexName(m.group(2));
            String cluster = tokens[0];
            String indexName = tokens[1];
            int shardId = Integer.parseInt(m.group(3));
            return new ShardProfileId(nodeId, indexName, shardId, cluster);
        }
        assert (false) : "Unable to match input against expected pattern of [nodeId][indexName][shardId]. Input: " + compositeId;
        logger.warn("Unable to match input against expected pattern of [nodeId][indexName][shardId]. Input: {}", (Object)compositeId);
        return null;
    }

    record ShardProfileId(String nodeId, String indexName, int shardId, @Nullable String clusterName) {
    }
}

