/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets;

import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.ItemSetBitSet;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.ItemSetTraverser;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.TransactionStore;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.TransactionsLookupTable;

final class CountingItemSetTraverser
implements Releasable {
    private static final int OCCURENCES_SIZE_INCREMENT = 10;
    private final TransactionStore transactionStore;
    private final ItemSetTraverser topItemSetTraverser;
    private final TransactionStore.TopTransactionIds topTransactionIds;
    private final TransactionsLookupTable transactionsLookupTable;
    private final int cacheTraversalDepth;
    private final int cacheNumberOfTransactions;
    private final long[] transactionSkipCounts;
    private final BitSet transactionSkipList;
    private long[] occurencesStack;
    private BitSet visited;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CountingItemSetTraverser(TransactionStore transactionStore, TransactionStore.TopItemIds topItemIds, int cacheTraversalDepth, int cacheNumberOfTransactions, long minCount) throws IOException {
        this.transactionStore = transactionStore;
        boolean success = false;
        try {
            this.topItemSetTraverser = new ItemSetTraverser(topItemIds);
            this.topTransactionIds = transactionStore.getTopTransactionIds();
            this.transactionsLookupTable = transactionStore.createLookupTableByTopTransactions(topItemIds, this.topTransactionIds);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
        this.cacheTraversalDepth = cacheTraversalDepth;
        this.cacheNumberOfTransactions = cacheNumberOfTransactions;
        this.transactionSkipCounts = new long[cacheTraversalDepth - 1];
        this.transactionSkipList = new BitSet((cacheTraversalDepth - 1) * cacheNumberOfTransactions);
        this.occurencesStack = new long[10];
        this.visited = new BitSet();
    }

    public boolean next(long earlyStopMinCount) throws IOException {
        if (!this.topItemSetTraverser.next()) {
            return false;
        }
        long totalTransactionCount = this.transactionStore.getTotalTransactionCount();
        int depth = this.topItemSetTraverser.getNumberOfItems();
        long occurencesOfSingleItem = this.transactionStore.getItemCount(this.topItemSetTraverser.getItemId());
        if (depth == 1) {
            this.occurencesStack[0] = occurencesOfSingleItem;
            return true;
        }
        if (occurencesOfSingleItem < earlyStopMinCount) {
            this.rememberCountInStack(depth, occurencesOfSingleItem);
            return true;
        }
        if (depth < this.cacheTraversalDepth) {
            long skipCount = this.transactionSkipCounts[depth - 2];
            long maxReachableTransactionCount = totalTransactionCount - skipCount;
            this.transactionSkipList.clear((depth - 1) * this.cacheNumberOfTransactions, depth * this.cacheNumberOfTransactions);
            int topTransactionPos = 0;
            long occurrences = 0L;
            while ((long)topTransactionPos < this.topTransactionIds.size()) {
                if (topTransactionPos < this.cacheNumberOfTransactions && this.transactionSkipList.get(this.cacheNumberOfTransactions * (depth - 2) + topTransactionPos)) {
                    this.transactionSkipList.set(this.cacheNumberOfTransactions * (depth - 1) + topTransactionPos);
                    ++topTransactionPos;
                    continue;
                }
                long transactionCount = this.transactionStore.getTransactionCount(this.topTransactionIds.getItemIdAt(topTransactionPos));
                if (this.transactionsLookupTable.isSubsetOf(topTransactionPos, this.topItemSetTraverser.getItemSetBitSet())) {
                    occurrences += transactionCount;
                } else if (topTransactionPos < this.cacheNumberOfTransactions) {
                    skipCount += transactionCount;
                    this.transactionSkipList.set(this.cacheNumberOfTransactions * (depth - 1) + topTransactionPos);
                }
                if ((maxReachableTransactionCount -= transactionCount) + occurrences < earlyStopMinCount) break;
                ++topTransactionPos;
            }
            this.transactionSkipCounts[depth - 1] = skipCount;
            this.rememberCountInStack(depth, occurrences);
            return true;
        }
        long skipCount = this.transactionSkipCounts[this.cacheTraversalDepth - 2];
        long maxReachableTransactionCount = totalTransactionCount - skipCount;
        int transactionNumber = 0;
        long occurrences = 0L;
        for (Long transactionId : this.topTransactionIds) {
            if (transactionNumber < this.cacheNumberOfTransactions && this.transactionSkipList.get(this.cacheNumberOfTransactions * (this.cacheTraversalDepth - 2) + transactionNumber)) {
                ++transactionNumber;
                continue;
            }
            long transactionCount = this.transactionStore.getTransactionCount(transactionId);
            if (this.transactionsLookupTable.isSubsetOf(transactionNumber, this.topItemSetTraverser.getItemSetBitSet())) {
                occurrences += transactionCount;
            }
            if ((maxReachableTransactionCount -= transactionCount) + occurrences < earlyStopMinCount) break;
            ++transactionNumber;
        }
        this.rememberCountInStack(depth, occurrences);
        return true;
    }

    public long getCount() {
        if (this.topItemSetTraverser.getNumberOfItems() > 0) {
            return this.occurencesStack[this.topItemSetTraverser.getNumberOfItems() - 1];
        }
        return 0L;
    }

    public long getParentCount() {
        if (this.topItemSetTraverser.getNumberOfItems() > 1) {
            return this.occurencesStack[this.topItemSetTraverser.getNumberOfItems() - 2];
        }
        return 0L;
    }

    public boolean hasBeenVisited() {
        if (this.topItemSetTraverser.getNumberOfItems() > 0) {
            return this.visited.get(this.topItemSetTraverser.getNumberOfItems() - 1);
        }
        return true;
    }

    public boolean hasParentBeenVisited() {
        if (this.topItemSetTraverser.getNumberOfItems() > 1) {
            return this.visited.get(this.topItemSetTraverser.getNumberOfItems() - 2);
        }
        return true;
    }

    public void setVisited() {
        if (this.topItemSetTraverser.getNumberOfItems() > 0) {
            this.visited.set(this.topItemSetTraverser.getNumberOfItems() - 1);
        }
    }

    public void setParentVisited() {
        if (this.topItemSetTraverser.getNumberOfItems() > 1) {
            this.visited.set(this.topItemSetTraverser.getNumberOfItems() - 2);
        }
    }

    public int getNumberOfItems() {
        return this.topItemSetTraverser.getNumberOfItems();
    }

    public ItemSetBitSet getItemSetBitSet() {
        return this.topItemSetTraverser.getItemSetBitSet();
    }

    public ItemSetBitSet getParentItemSetBitSet() {
        return this.topItemSetTraverser.getParentItemSetBitSet();
    }

    public void prune() {
        this.topItemSetTraverser.prune();
    }

    public void pruneToNextMainBranch() {
        long thisCount = this.getCount();
        while (this.getNumberOfItems() > 1 && this.getCount() == thisCount) {
            this.topItemSetTraverser.prune();
        }
    }

    public boolean atLeaf() {
        return this.topItemSetTraverser.atLeaf();
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.topTransactionIds, this.transactionsLookupTable});
    }

    private void rememberCountInStack(int index, long occurences) {
        if (this.occurencesStack.length < index) {
            this.occurencesStack = Arrays.copyOf(this.occurencesStack, index + 10);
        }
        this.occurencesStack[index - 1] = occurences;
        this.visited.clear(index - 1);
    }
}

