/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.categorization;

import java.io.IOException;
import org.elasticsearch.xpack.ml.job.categorization.AbstractMlTokenizer;

public class MlStandardTokenizer
extends AbstractMlTokenizer {
    public static final String NAME = "ml_standard";
    private int putBackChar = -1;

    MlStandardTokenizer() {
    }

    public final boolean incrementToken() throws IOException {
        char toCheck;
        int curChar;
        this.clearAttributes();
        this.skippedPositions = 0;
        int start = -1;
        int length = 0;
        boolean haveNonHex = false;
        int lettersBeforeColon = 0;
        boolean haveColon = false;
        int firstBackslashPos = -1;
        int firstForwardSlashPos = -1;
        int slashCount = 0;
        while ((curChar = this.getNextChar()) >= 0) {
            ++this.nextOffset;
            if (Character.isLetterOrDigit(curChar) || length > 0 && (curChar == 95 || curChar == 46 || curChar == 45 || curChar == 64 || curChar == 58 && lettersBeforeColon == length) || curChar == 47 || curChar == 92 && (length == 0 || haveColon && lettersBeforeColon == 1 || firstBackslashPos == 0)) {
                if (length == 0) {
                    start = this.nextOffset - 1;
                }
                this.termAtt.append((char)curChar);
                ++length;
                if (curChar == 58) {
                    haveColon = true;
                } else if (curChar == 47) {
                    ++slashCount;
                    if (firstForwardSlashPos == -1) {
                        firstForwardSlashPos = length - 1;
                    }
                } else if (curChar == 92) {
                    ++slashCount;
                    if (firstBackslashPos == -1) {
                        firstBackslashPos = length - 1;
                    }
                } else if (haveColon) {
                    if (firstBackslashPos != lettersBeforeColon + 1 && firstForwardSlashPos != lettersBeforeColon + 1) {
                        assert (length - lettersBeforeColon == 2);
                        length -= 2;
                        this.putBackChar = curChar;
                        --this.nextOffset;
                        break;
                    }
                } else if (Character.isLetter(curChar)) {
                    ++lettersBeforeColon;
                }
                haveNonHex = haveNonHex || Character.digit(curChar, 16) == -1 && curChar != 46 && curChar != 45 && curChar != 64 && curChar != 58;
                continue;
            }
            if (length <= 0) continue;
            if (haveNonHex && !Character.isDigit(this.termAtt.charAt(0)) && length > slashCount) break;
            ++this.skippedPositions;
            start = -1;
            length = 0;
            this.termAtt.setEmpty();
            haveNonHex = false;
            lettersBeforeColon = 0;
            haveColon = false;
            firstBackslashPos = -1;
            firstForwardSlashPos = -1;
            slashCount = 0;
        }
        if (length == 0) {
            return false;
        }
        if (!haveNonHex || Character.isDigit(this.termAtt.charAt(0)) || length == slashCount) {
            ++this.skippedPositions;
            return false;
        }
        while ((toCheck = this.termAtt.charAt(length - 1)) == '_' || toCheck == '.' || toCheck == '-' || toCheck == '@' || toCheck == ':') {
            --length;
        }
        this.termAtt.setLength(length);
        this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(start + length));
        this.posIncrAtt.setPositionIncrement(this.skippedPositions + 1);
        return true;
    }

    private int getNextChar() throws IOException {
        int nextChar;
        if (this.putBackChar >= 0) {
            nextChar = this.putBackChar;
            this.putBackChar = -1;
        } else {
            nextChar = this.input.read();
        }
        return nextChar;
    }
}

