/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.StateStreamer;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectWorkerExecutorService;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.JobSnapshotUpgraderResultProcessor;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.AutodetectParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.FlushJobParams;
import org.elasticsearch.xpack.ml.job.snapshot.upgrader.SnapshotUpgradeTask;
import org.elasticsearch.xpack.ml.process.NativeStorageProvider;

public final class JobModelSnapshotUpgrader {
    private static final Duration FLUSH_PROCESS_CHECK_FREQUENCY = Duration.ofSeconds(1L);
    private static final Logger logger = LogManager.getLogger(JobModelSnapshotUpgrader.class);
    private final SnapshotUpgradeTask task;
    private final Job job;
    private final String jobId;
    private final String snapshotId;
    private final AutodetectParams params;
    private final Client client;
    private final Consumer<Exception> onFinish;
    private final Supplier<Boolean> continueRunning;
    private final ThreadPool threadPool;
    private final AutodetectProcessFactory autodetectProcessFactory;
    private final JobResultsPersister jobResultsPersister;
    private final NativeStorageProvider nativeStorageProvider;
    private AutodetectProcess process;
    private JobSnapshotUpgraderResultProcessor processor;

    JobModelSnapshotUpgrader(SnapshotUpgradeTask task, Job job, AutodetectParams params, ThreadPool threadPool, AutodetectProcessFactory autodetectProcessFactory, JobResultsPersister jobResultsPersister, Client client, NativeStorageProvider nativeStorageProvider, Consumer<Exception> onFinish, Supplier<Boolean> continueRunning) {
        this.task = Objects.requireNonNull(task);
        this.job = Objects.requireNonNull(job);
        this.params = Objects.requireNonNull(params);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.autodetectProcessFactory = Objects.requireNonNull(autodetectProcessFactory);
        this.jobResultsPersister = Objects.requireNonNull(jobResultsPersister);
        this.nativeStorageProvider = Objects.requireNonNull(nativeStorageProvider);
        this.client = Objects.requireNonNull(client);
        this.onFinish = Objects.requireNonNull(onFinish);
        this.continueRunning = Objects.requireNonNull(continueRunning);
        this.jobId = task.getJobId();
        this.snapshotId = task.getSnapshotId();
    }

    synchronized void start() {
        AutodetectWorkerExecutorService autodetectWorkerExecutor;
        if (!this.task.setJobModelSnapshotUpgrader(this)) {
            this.killProcess(this.task.getReasonCancelled());
            return;
        }
        ExecutorService autodetectExecutorService = this.threadPool.executor("ml_job_comms");
        this.process = this.autodetectProcessFactory.createAutodetectProcess(this.jobId + "-" + this.snapshotId, this.job, this.params, autodetectExecutorService, reason -> {
            this.setTaskToFailed((String)reason, (ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>)ActionListener.wrap(t -> {}, arg_0 -> ((SnapshotUpgradeTask)this.task).markAsFailed(arg_0)));
            try {
                this.nativeStorageProvider.cleanupLocalTmpStorage(this.task.getDescription());
            }
            catch (IOException e) {
                logger.error(() -> Strings.format((String)"[%s] [%s] failed to delete temporary files snapshot upgrade", (Object[])new Object[]{this.jobId, this.snapshotId}), (Throwable)e);
            }
        });
        this.processor = new JobSnapshotUpgraderResultProcessor(this.jobId, this.snapshotId, this.jobResultsPersister, this.process);
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
            autodetectWorkerExecutor = new AutodetectWorkerExecutorService(this.threadPool.getThreadContext());
            autodetectExecutorService.submit(autodetectWorkerExecutor::start);
            autodetectExecutorService.submit(this.processor::process);
        }
        catch (EsRejectedExecutionException e) {
            try {
                IOUtils.close((Closeable)this.process);
                this.process = null;
                this.processor = null;
            }
            catch (IOException ioe) {
                logger.error("Can't close autodetect", (Throwable)ioe);
            }
            this.onFinish.accept((Exception)((Object)e));
            return;
        }
        StateStreamer stateStreamer = new StateStreamer(this.client);
        Executor executor = new Executor(stateStreamer, this.processor, autodetectWorkerExecutor, this.process);
        if (!this.continueRunning.get().booleanValue()) {
            this.onFinish.accept(null);
            return;
        }
        executor.execute();
    }

    private void removeDuplicateModelSnapshotDoc(Consumer<Exception> runAfter) {
        String snapshotDocId = this.jobId + "_model_snapshot_" + this.snapshotId;
        this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.jobResultsIndexPattern()}).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{snapshotDocId}))).setSize(2).addSort(ModelSnapshot.MIN_VERSION.getPreferredName(), SortOrder.ASC).execute(ActionListener.wrap(searchResponse -> {
            if (searchResponse.getHits().getTotalHits().value() > 1L) {
                this.deleteOlderSnapshotDoc((SearchResponse)searchResponse, runAfter);
            } else {
                this.onFinish.accept(null);
            }
        }, e -> {
            logger.warn(() -> Strings.format((String)"[%s] [%s] error during search for model snapshot documents", (Object[])new Object[]{this.jobId, this.snapshotId}), (Throwable)e);
            this.onFinish.accept(null);
        }));
    }

    private void deleteOlderSnapshotDoc(SearchResponse searchResponse, Consumer<Exception> runAfter) {
        SearchHit firstHit = searchResponse.getHits().getAt(0);
        logger.debug(() -> Strings.format((String)"[%s] deleting duplicate model snapshot doc [%s]", (Object[])new Object[]{this.jobId, firstHit.getId()}));
        ((DeleteRequestBuilder)this.client.prepareDelete().setIndex(firstHit.getIndex())).setId(firstHit.getId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).execute(ActionListener.runAfter((ActionListener)ActionListener.wrap(deleteResponse -> {
            if (!(deleteResponse.getResult() == DocWriteResponse.Result.DELETED)) {
                logger.warn(() -> Strings.format((String)"[%s] [%s] failed to delete old snapshot [%s] result document, document not found", (Object[])new Object[]{this.jobId, this.snapshotId, ModelSizeStats.RESULT_TYPE_FIELD.getPreferredName()}));
            }
        }, e -> logger.warn(() -> Strings.format((String)"[%s] [%s] failed to delete old snapshot [%s] result document", (Object[])new Object[]{this.jobId, this.snapshotId, ModelSizeStats.RESULT_TYPE_FIELD.getPreferredName()}), (Throwable)e)), () -> runAfter.accept(null)));
    }

    void setTaskToFailed(String reason, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        SnapshotUpgradeTaskState taskState = new SnapshotUpgradeTaskState(SnapshotUpgradeState.FAILED, this.task.getAllocationId(), reason);
        this.task.updatePersistentTaskState((PersistentTaskState)taskState, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), f -> {
            logger.warn(() -> Strings.format((String)"[%s] [%s] failed to set task to failed", (Object[])new Object[]{this.task.getJobId(), this.task.getSnapshotId()}), (Throwable)f);
            listener.onFailure(f);
        }));
    }

    public synchronized void killProcess(String reason) {
        if (this.process != null) {
            try {
                logger.debug("[{}] killing upgrade process for model snapshot [{}]: reason [{}]", (Object)this.jobId, (Object)this.snapshotId, (Object)reason);
                if (this.processor != null) {
                    this.processor.setProcessKilled();
                }
                this.process.kill(true);
                this.process = null;
                this.processor = null;
            }
            catch (IOException e) {
                logger.error(() -> Strings.format((String)"[%s] failed to kill upgrade process for model snapshot [%s]", (Object[])new Object[]{this.jobId, this.snapshotId}), (Throwable)e);
            }
        } else {
            logger.warn("[{}] attempt to kill upgrade process for model snapshot [{}] when no such process exists", (Object)this.jobId, (Object)this.snapshotId);
        }
    }

    private class Executor {
        private final StateStreamer stateStreamer;
        private final JobSnapshotUpgraderResultProcessor processor;
        private final ExecutorService autodetectWorkerExecutor;
        private final AutodetectProcess process;

        Executor(StateStreamer stateStreamer, JobSnapshotUpgraderResultProcessor processor, ExecutorService autodetectWorkerExecutor, AutodetectProcess process) {
            this.stateStreamer = stateStreamer;
            this.processor = processor;
            this.autodetectWorkerExecutor = autodetectWorkerExecutor;
            this.process = process;
        }

        void execute() {
            this.restoreState();
        }

        protected final Map<String, Integer> outputFieldIndexes() {
            HashMap<String, Integer> fieldIndexes = new HashMap<String, Integer>();
            fieldIndexes.put(JobModelSnapshotUpgrader.this.job.getDataDescription().getTimeField(), 0);
            int index = 1;
            for (String field : JobModelSnapshotUpgrader.this.job.getAnalysisConfig().analysisFields()) {
                if ("mlcategory".equals(field)) continue;
                fieldIndexes.put(field, index++);
            }
            if (JobModelSnapshotUpgrader.this.job.getAnalysisConfig().getCategorizationFieldName() != null) {
                fieldIndexes.put("...", index++);
            }
            fieldIndexes.put(".", index++);
            return fieldIndexes;
        }

        void writeHeader() throws IOException {
            Map<String, Integer> outFieldIndexes = this.outputFieldIndexes();
            int numFields = outFieldIndexes.size();
            String[] record = new String[numFields];
            for (Map.Entry<String, Integer> entry : outFieldIndexes.entrySet()) {
                record[entry.getValue().intValue()] = entry.getKey();
            }
            this.process.writeRecord(record);
        }

        FlushAcknowledgement waitFlushToCompletion(String flushId) throws Exception {
            FlushAcknowledgement flushAcknowledgement;
            logger.debug(() -> Strings.format((String)"[%s] [%s] waiting for flush [%s]", (Object[])new Object[]{JobModelSnapshotUpgrader.this.jobId, JobModelSnapshotUpgrader.this.snapshotId, flushId}));
            try {
                flushAcknowledgement = this.processor.waitForFlushAcknowledgement(flushId, FLUSH_PROCESS_CHECK_FREQUENCY);
                while (flushAcknowledgement == null) {
                    this.checkProcessIsAlive();
                    this.checkResultsProcessorIsAlive();
                    flushAcknowledgement = this.processor.waitForFlushAcknowledgement(flushId, FLUSH_PROCESS_CHECK_FREQUENCY);
                }
            }
            finally {
                this.processor.clearAwaitingFlush(flushId);
            }
            logger.debug(() -> Strings.format((String)"[%s] [%s] flush completed [%s]", (Object[])new Object[]{JobModelSnapshotUpgrader.this.jobId, JobModelSnapshotUpgrader.this.snapshotId, flushId}));
            return flushAcknowledgement;
        }

        void restoreState() {
            try {
                this.process.restoreState(this.stateStreamer, JobModelSnapshotUpgrader.this.params.modelSnapshot());
            }
            catch (Exception e2) {
                logger.error(() -> Strings.format((String)"[%s] [%s] failed to write old state", (Object[])new Object[]{JobModelSnapshotUpgrader.this.jobId, JobModelSnapshotUpgrader.this.snapshotId}), (Throwable)e2);
                JobModelSnapshotUpgrader.this.setTaskToFailed("Failed to write old state due to: " + e2.getMessage(), ActionListener.running(() -> this.shutdownWithFailure(e2)));
                return;
            }
            this.submitOperation(() -> {
                this.writeHeader();
                String flushId = this.process.flushJob(FlushJobParams.builder().waitForNormalization(false).build());
                return this.waitFlushToCompletion(flushId);
            }, (flushAcknowledgement, e) -> {
                Runnable nextStep;
                if (e != null) {
                    logger.error(() -> Strings.format((String)"[%s] [%s] failed to flush after writing old state", (Object[])new Object[]{JobModelSnapshotUpgrader.this.jobId, JobModelSnapshotUpgrader.this.snapshotId}), (Throwable)e);
                    nextStep = () -> JobModelSnapshotUpgrader.this.setTaskToFailed("Failed to flush after writing old state due to: " + e.getMessage(), ActionListener.running(() -> this.shutdownWithFailure((Exception)e)));
                } else {
                    logger.debug(() -> Strings.format((String)"[%s] [%s] flush [%s] acknowledged requesting state write", (Object[])new Object[]{JobModelSnapshotUpgrader.this.jobId, JobModelSnapshotUpgrader.this.snapshotId, flushAcknowledgement.getId()}));
                    nextStep = this::requestStateWrite;
                }
                JobModelSnapshotUpgrader.this.threadPool.executor("ml_utility").execute(nextStep);
            });
        }

        private void requestStateWrite() {
            JobModelSnapshotUpgrader.this.task.updatePersistentTaskState((PersistentTaskState)new SnapshotUpgradeTaskState(SnapshotUpgradeState.SAVING_NEW_STATE, JobModelSnapshotUpgrader.this.task.getAllocationId(), ""), ActionListener.wrap(readingNewState -> {
                if (!JobModelSnapshotUpgrader.this.continueRunning.get().booleanValue()) {
                    this.shutdownWithFailure(null);
                    return;
                }
                this.submitOperation(() -> {
                    this.process.persistState(JobModelSnapshotUpgrader.this.params.modelSnapshot().getTimestamp().getTime(), JobModelSnapshotUpgrader.this.params.modelSnapshot().getSnapshotId(), JobModelSnapshotUpgrader.this.params.modelSnapshot().getDescription());
                    logger.debug("[{}] [{}] state persist call made", (Object)JobModelSnapshotUpgrader.this.jobId, (Object)JobModelSnapshotUpgrader.this.snapshotId);
                    return Void.TYPE;
                }, (aVoid, e) -> JobModelSnapshotUpgrader.this.threadPool.executor("ml_utility").execute(() -> this.handlePersistingState((Exception)e)));
                logger.debug("[{}] [{}] asked for state to be persisted", (Object)JobModelSnapshotUpgrader.this.jobId, (Object)JobModelSnapshotUpgrader.this.snapshotId);
            }, f -> {
                logger.error(() -> Strings.format((String)"[%s] [%s] failed to update snapshot upgrader task to started", (Object[])new Object[]{JobModelSnapshotUpgrader.this.jobId, JobModelSnapshotUpgrader.this.snapshotId}), (Throwable)f);
                this.shutdownWithFailure((Exception)((Object)new ElasticsearchStatusException("Failed to start snapshot upgrade [{}] for job [{}]", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)f, new Object[]{JobModelSnapshotUpgrader.this.snapshotId, JobModelSnapshotUpgrader.this.jobId})));
            }));
        }

        private <T> void submitOperation(final CheckedSupplier<T, Exception> operation, final BiConsumer<T, Exception> handler) {
            this.autodetectWorkerExecutor.execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    if (!JobModelSnapshotUpgrader.this.continueRunning.get().booleanValue()) {
                        handler.accept(null, ExceptionsHelper.conflictStatusException((String)"[{}] Could not submit operation to process as it has been killed", (Object[])new Object[]{JobModelSnapshotUpgrader.this.job.getId()}));
                    } else {
                        logger.error(() -> "[" + JobModelSnapshotUpgrader.this.job.getId() + "] Unexpected exception writing to process", (Throwable)e);
                        handler.accept(null, e);
                    }
                }

                protected void doRun() throws Exception {
                    if (!JobModelSnapshotUpgrader.this.continueRunning.get().booleanValue()) {
                        handler.accept(null, ExceptionsHelper.conflictStatusException((String)"[{}] Could not submit operation to process as it has been killed", (Object[])new Object[]{JobModelSnapshotUpgrader.this.job.getId()}));
                    } else {
                        Executor.this.checkProcessIsAlive();
                        handler.accept(operation.get(), null);
                    }
                }
            });
        }

        private void checkProcessIsAlive() {
            if (!this.process.isProcessAlive()) {
                throw new ElasticsearchException("[{}] Unexpected death of autodetect: {}", new Object[]{JobModelSnapshotUpgrader.this.job.getId(), this.process.readError()});
            }
        }

        private void checkResultsProcessorIsAlive() {
            if (this.processor.isFailed()) {
                throw new ElasticsearchException("[{}] Unexpected death of the result processor", new Object[]{JobModelSnapshotUpgrader.this.job.getId()});
            }
        }

        private void handlePersistingState(@Nullable Exception exception) {
            assert (Thread.currentThread().getName().contains("ml_utility"));
            if (exception != null) {
                this.shutdownWithFailure(exception);
            } else {
                this.stopProcess((aVoid, e) -> JobModelSnapshotUpgrader.this.threadPool.executor("ml_utility").execute(() -> {
                    this.autodetectWorkerExecutor.shutdownNow();
                    JobModelSnapshotUpgrader.this.removeDuplicateModelSnapshotDoc(JobModelSnapshotUpgrader.this.onFinish);
                }));
            }
        }

        void shutdownWithFailure(Exception e) {
            this.stopProcess((aVoid, ignored) -> JobModelSnapshotUpgrader.this.threadPool.executor("ml_utility").execute(() -> {
                JobModelSnapshotUpgrader.this.onFinish.accept(e);
                this.autodetectWorkerExecutor.shutdownNow();
            }));
        }

        private void stopProcess(BiConsumer<Class<Void>, Exception> runNext) {
            logger.debug("[{}] [{}] shutdown initiated", (Object)JobModelSnapshotUpgrader.this.jobId, (Object)JobModelSnapshotUpgrader.this.snapshotId);
            if (!this.process.isProcessAlive()) {
                logger.debug("[{}] [{}] process is dead, no need to shutdown", (Object)JobModelSnapshotUpgrader.this.jobId, (Object)JobModelSnapshotUpgrader.this.snapshotId);
                this.stateStreamer.cancel();
                runNext.accept(null, null);
                return;
            }
            this.submitOperation(() -> {
                try {
                    logger.debug("[{}] [{}] shutdown is now occurring", (Object)JobModelSnapshotUpgrader.this.jobId, (Object)JobModelSnapshotUpgrader.this.snapshotId);
                    if (this.process.isReady()) {
                        this.process.close();
                    } else {
                        this.processor.setProcessKilled();
                        this.process.kill(true);
                        this.stateStreamer.cancel();
                    }
                    this.processor.awaitCompletion();
                }
                catch (IOException | TimeoutException exc) {
                    logger.warn(() -> Strings.format((String)"[%s] [%s] failed to shutdown process", (Object[])new Object[]{JobModelSnapshotUpgrader.this.jobId, JobModelSnapshotUpgrader.this.snapshotId}), (Throwable)exc);
                }
                logger.debug("[{}] [{}] connection for upgrade has been closed, process is shutdown", (Object)JobModelSnapshotUpgrader.this.jobId, (Object)JobModelSnapshotUpgrader.this.snapshotId);
                return Void.TYPE;
            }, runNext);
        }
    }
}

