/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class NormalizerResult
implements ToXContentObject,
Writeable {
    static final ParseField LEVEL_FIELD = new ParseField("level", new String[0]);
    static final ParseField PARTITION_FIELD_NAME_FIELD = new ParseField("partition_field_name", new String[0]);
    static final ParseField PARTITION_FIELD_VALUE_FIELD = new ParseField("partition_field_value", new String[0]);
    static final ParseField PERSON_FIELD_NAME_FIELD = new ParseField("person_field_name", new String[0]);
    static final ParseField PERSON_FIELD_VALUE_FIELD = new ParseField("person_field_value", new String[0]);
    static final ParseField FUNCTION_NAME_FIELD = new ParseField("function_name", new String[0]);
    static final ParseField VALUE_FIELD_NAME_FIELD = new ParseField("value_field_name", new String[0]);
    static final ParseField PROBABILITY_FIELD = new ParseField("probability", new String[0]);
    static final ParseField NORMALIZED_SCORE_FIELD = new ParseField("normalized_score", new String[0]);
    public static final ObjectParser<NormalizerResult, Void> PARSER = new ObjectParser(LEVEL_FIELD.getPreferredName(), NormalizerResult::new);
    private String level;
    private String partitionFieldName;
    private String partitionFieldValue;
    private String personFieldName;
    private String personFieldValue;
    private String functionName;
    private String valueFieldName;
    private double probability;
    private double normalizedScore;

    public NormalizerResult() {
    }

    public NormalizerResult(StreamInput in) throws IOException {
        this.level = in.readOptionalString();
        this.partitionFieldName = in.readOptionalString();
        this.partitionFieldValue = in.readOptionalString();
        this.personFieldName = in.readOptionalString();
        this.personFieldValue = in.readOptionalString();
        this.functionName = in.readOptionalString();
        this.valueFieldName = in.readOptionalString();
        this.probability = in.readDouble();
        this.normalizedScore = in.readDouble();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.level);
        out.writeOptionalString(this.partitionFieldName);
        out.writeOptionalString(this.partitionFieldValue);
        out.writeOptionalString(this.personFieldName);
        out.writeOptionalString(this.personFieldValue);
        out.writeOptionalString(this.functionName);
        out.writeOptionalString(this.valueFieldName);
        out.writeDouble(this.probability);
        out.writeDouble(this.normalizedScore);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LEVEL_FIELD.getPreferredName(), this.level);
        builder.field(PARTITION_FIELD_NAME_FIELD.getPreferredName(), this.partitionFieldName);
        builder.field(PARTITION_FIELD_VALUE_FIELD.getPreferredName(), this.partitionFieldValue);
        builder.field(PERSON_FIELD_NAME_FIELD.getPreferredName(), this.personFieldName);
        builder.field(PERSON_FIELD_VALUE_FIELD.getPreferredName(), this.personFieldValue);
        builder.field(FUNCTION_NAME_FIELD.getPreferredName(), this.functionName);
        builder.field(VALUE_FIELD_NAME_FIELD.getPreferredName(), this.valueFieldName);
        builder.field(PROBABILITY_FIELD.getPreferredName(), this.probability);
        builder.field(NORMALIZED_SCORE_FIELD.getPreferredName(), this.normalizedScore);
        builder.endObject();
        return builder;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public void setPartitionFieldName(String partitionFieldName) {
        this.partitionFieldName = partitionFieldName;
    }

    public String getPartitionFieldValue() {
        return this.partitionFieldValue;
    }

    public void setPartitionFieldValue(String partitionFieldValue) {
        this.partitionFieldValue = partitionFieldValue;
    }

    public String getPersonFieldName() {
        return this.personFieldName;
    }

    public void setPersonFieldName(String personFieldName) {
        this.personFieldName = personFieldName;
    }

    public String getPersonFieldValue() {
        return this.personFieldValue;
    }

    public void setPersonFieldValue(String personFieldValue) {
        this.personFieldValue = personFieldValue;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getValueFieldName() {
        return this.valueFieldName;
    }

    public void setValueFieldName(String valueFieldName) {
        this.valueFieldName = valueFieldName;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public double getNormalizedScore() {
        return this.normalizedScore;
    }

    public void setNormalizedScore(double normalizedScore) {
        this.normalizedScore = normalizedScore;
    }

    public int hashCode() {
        return Objects.hash(this.level, this.partitionFieldName, this.partitionFieldValue, this.personFieldName, this.personFieldValue, this.functionName, this.valueFieldName, this.probability, this.normalizedScore);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NormalizerResult)) {
            return false;
        }
        NormalizerResult that = (NormalizerResult)other;
        return Objects.equals(this.level, that.level) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && Objects.equals(this.partitionFieldValue, that.partitionFieldValue) && Objects.equals(this.personFieldName, that.personFieldName) && Objects.equals(this.personFieldValue, that.personFieldValue) && Objects.equals(this.functionName, that.functionName) && Objects.equals(this.valueFieldName, that.valueFieldName) && this.probability == that.probability && this.normalizedScore == that.normalizedScore;
    }

    static {
        PARSER.declareString(NormalizerResult::setLevel, LEVEL_FIELD);
        PARSER.declareString(NormalizerResult::setPartitionFieldName, PARTITION_FIELD_NAME_FIELD);
        PARSER.declareString(NormalizerResult::setPartitionFieldValue, PARTITION_FIELD_VALUE_FIELD);
        PARSER.declareString(NormalizerResult::setPersonFieldName, PERSON_FIELD_NAME_FIELD);
        PARSER.declareString(NormalizerResult::setPersonFieldValue, PERSON_FIELD_VALUE_FIELD);
        PARSER.declareString(NormalizerResult::setFunctionName, FUNCTION_NAME_FIELD);
        PARSER.declareString(NormalizerResult::setValueFieldName, VALUE_FIELD_NAME_FIELD);
        PARSER.declareDouble(NormalizerResult::setProbability, PROBABILITY_FIELD);
        PARSER.declareDouble(NormalizerResult::setNormalizedScore, NORMALIZED_SCORE_FIELD);
    }
}

