/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.common;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.geo.XYEncodingUtils;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GenericPointParser;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.StandardValidator;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.support.MapXContentParser;

public class CartesianPoint
implements SpatialPoint,
ToXContentFragment {
    private static final String X_FIELD = "x";
    private static final String Y_FIELD = "y";
    private static final String Z_FIELD = "z";
    protected double x;
    protected double y;
    private static final GenericPointParser<CartesianPoint> cartesianPointParser = new GenericPointParser<CartesianPoint>("point", "x", "y"){

        public void assertZValue(boolean ignoreZValue, double zValue) {
            CartesianPoint.assertZValue(ignoreZValue, zValue);
        }

        public CartesianPoint createPoint(double x, double y) {
            return new CartesianPoint(x, y);
        }

        public String fieldError() {
            return "field must be either lat/lon or type/coordinates";
        }
    };

    public CartesianPoint() {
    }

    public CartesianPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public CartesianPoint(SpatialPoint template) {
        this(template.getX(), template.getY());
    }

    public CartesianPoint reset(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public CartesianPoint resetX(double x) {
        this.x = x;
        return this;
    }

    public CartesianPoint resetY(double y) {
        this.y = y;
        return this;
    }

    public CartesianPoint resetFromEncoded(long encoded) {
        double x = XYEncodingUtils.decode((int)((int)(encoded >>> 32)));
        double y = XYEncodingUtils.decode((int)((int)(encoded & 0xFFFFFFFFFFFFFFFFL)));
        return this.reset(x, y);
    }

    public CartesianPoint resetFromString(String value, boolean ignoreZValue) {
        if (value.toLowerCase(Locale.ROOT).contains("point")) {
            return this.resetFromWKT(value, ignoreZValue);
        }
        if (value.contains(",")) {
            return this.resetFromCoordinates(value, ignoreZValue);
        }
        if (value.contains(".")) {
            throw new ElasticsearchParseException("failed to parse [{}], expected 2 or 3 coordinates but found: [{}]", new Object[]{value, 1});
        }
        throw new ElasticsearchParseException("unsupported symbol [{}] in point [{}]", new Object[]{Character.valueOf(value.charAt(0)), value});
    }

    public CartesianPoint resetFromCoordinates(String value, boolean ignoreZValue) {
        double y;
        double x;
        String[] vals = value.split(",");
        if (vals.length > 3 || vals.length < 2) {
            throw new ElasticsearchParseException("failed to parse [{}], expected 2 or 3 coordinates but found: [{}]", new Object[]{vals, vals.length});
        }
        try {
            x = Double.parseDouble(vals[0].trim());
            if (!Double.isFinite(x)) {
                throw new ElasticsearchParseException("invalid [{}] value [{}]; must be between -3.4028234663852886E38 and 3.4028234663852886E38", new Object[]{X_FIELD, x});
            }
        }
        catch (NumberFormatException ex) {
            throw new ElasticsearchParseException("[{}] must be a number", new Object[]{X_FIELD});
        }
        try {
            y = Double.parseDouble(vals[1].trim());
            if (!Double.isFinite(y)) {
                throw new ElasticsearchParseException("invalid [{}] value [{}]; must be between -3.4028234663852886E38 and 3.4028234663852886E38", new Object[]{Y_FIELD, y});
            }
        }
        catch (NumberFormatException ex) {
            throw new ElasticsearchParseException("[{}] must be a number", new Object[]{Y_FIELD});
        }
        if (vals.length > 2) {
            try {
                CartesianPoint.assertZValue(ignoreZValue, Double.parseDouble(vals[2].trim()));
            }
            catch (NumberFormatException ex) {
                throw new ElasticsearchParseException("[{}] must be a number", new Object[]{Y_FIELD});
            }
        }
        return this.reset(x, y);
    }

    private CartesianPoint resetFromWKT(String value, boolean ignoreZValue) {
        Geometry geometry;
        try {
            geometry = WellKnownText.fromWKT((GeometryValidator)StandardValidator.instance((boolean)ignoreZValue), (boolean)false, (String)value);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("Invalid WKT format", (Throwable)e, new Object[0]);
        }
        if (geometry.type() != ShapeType.POINT) {
            throw new ElasticsearchParseException("[{}] supports only POINT among WKT primitives, but found {}", new Object[]{"point", geometry.type()});
        }
        Point point = (Point)geometry;
        return this.reset(point.getX(), point.getY());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CartesianPoint point = (CartesianPoint)o;
        if (Double.compare(point.x, this.x) != 0) {
            return false;
        }
        return Double.compare(point.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return this.x + ", " + this.y;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(X_FIELD, this.x).field(Y_FIELD, this.y).endObject();
    }

    public static CartesianPoint parsePoint(XContentParser parser, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        return (CartesianPoint)cartesianPointParser.parsePoint(parser, ignoreZValue, value -> new CartesianPoint().resetFromString((String)value, ignoreZValue));
    }

    public static CartesianPoint parsePoint(Object value, boolean ignoreZValue) throws ElasticsearchParseException {
        CartesianPoint cartesianPoint;
        MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("null_value", value), null);
        try {
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            cartesianPoint = CartesianPoint.parsePoint((XContentParser)parser, ignoreZValue);
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ElasticsearchParseException("error parsing point", (Throwable)ex, new Object[0]);
            }
        }
        parser.close();
        return cartesianPoint;
    }

    public static void assertZValue(boolean ignoreZValue, double zValue) {
        if (!ignoreZValue) {
            throw new ElasticsearchParseException("Exception parsing coordinates: found Z value [{}] but [ignore_z_value] parameter is [{}]", new Object[]{zValue, ignoreZValue});
        }
        if (!Double.isFinite(zValue)) {
            throw new ElasticsearchParseException("invalid [{}] value [{}]; must be between -3.4028234663852886E38 and 3.4028234663852886E38", new Object[]{Z_FIELD, zValue});
        }
    }
}

