/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.common;

import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.xpack.spatial.common.H3CartesianUtil;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;

class H3CartesianGeometry
extends LatLonGeometry {
    private final long h3;

    H3CartesianGeometry(long h3) {
        this.h3 = h3;
    }

    protected Component2D toComponent2D() {
        return new H3CartesianComponent(this.h3);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        H3CartesianGeometry that = (H3CartesianGeometry)((Object)o);
        return this.h3 == that.h3;
    }

    public int hashCode() {
        return Long.hashCode(this.h3);
    }

    private static class H3CartesianComponent
    implements Component2D {
        private final double[] xs;
        private final double[] ys;
        private final double minX;
        private final double maxX;
        private final double minY;
        private final double maxY;
        private final boolean crossesDateline;

        H3CartesianComponent(long h3) {
            double[] xs = new double[15];
            double[] ys = new double[15];
            int numPoints = H3CartesianUtil.computePoints(h3, xs, ys);
            this.xs = ArrayUtil.copyOfSubArray((double[])xs, (int)0, (int)numPoints);
            this.ys = ArrayUtil.copyOfSubArray((double[])ys, (int)0, (int)numPoints);
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < numPoints; ++i) {
                minX = Math.min(minX, xs[i]);
                maxX = Math.max(maxX, xs[i]);
                minY = Math.min(minY, ys[i]);
                maxY = Math.max(maxY, ys[i]);
            }
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
            this.crossesDateline = maxX - minX > 180.0 && !H3CartesianUtil.isPolar(h3);
        }

        public double getMinX() {
            return this.crossesDateline ? -180.0 : this.minX;
        }

        public double getMaxX() {
            return this.crossesDateline ? 180.0 : this.maxX;
        }

        public double getMinY() {
            return this.minY;
        }

        public double getMaxY() {
            return this.maxY;
        }

        public boolean contains(double x, double y) {
            if (!Rectangle.containsPoint((double)y, (double)x, (double)this.getMinY(), (double)this.getMaxY(), (double)this.getMinX(), (double)this.getMaxX())) {
                return false;
            }
            return H3CartesianUtil.relatePoint(this.xs, this.ys, this.xs.length, this.crossesDateline, x, y) != GeoRelation.QUERY_DISJOINT;
        }

        public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
            if (Component2D.disjoint((double)this.getMinX(), (double)this.getMaxX(), (double)this.getMinY(), (double)this.getMaxY(), (double)minX, (double)maxX, (double)minY, (double)maxY)) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (Component2D.within((double)this.getMinX(), (double)this.getMaxX(), (double)this.getMinY(), (double)this.getMaxY(), (double)minX, (double)maxX, (double)minY, (double)maxY)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            ContainsCorners containsCorners = this.containsCorners(minX, maxX, minY, maxY);
            if (containsCorners == ContainsCorners.ALL) {
                if (H3CartesianUtil.crossesBox(this.xs, this.ys, this.xs.length, this.crossesDateline, minX, maxX, minY, maxY, true)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            if (containsCorners == ContainsCorners.NONE) {
                if (Component2D.containsPoint((double)this.xs[0], (double)this.ys[0], (double)minX, (double)maxX, (double)minY, (double)maxY)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                if (H3CartesianUtil.crossesBox(this.xs, this.ys, this.xs.length, this.crossesDateline, minX, maxX, minY, maxY, true)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
            return this.contains(aX, aY) || this.contains(bX, bY) || this.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true);
        }

        public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
            if (Component2D.disjoint((double)this.getMinX(), (double)this.getMaxX(), (double)this.getMinY(), (double)this.getMaxY(), (double)minX, (double)maxX, (double)minY, (double)maxY)) {
                return false;
            }
            return this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY) || Component2D.pointInTriangle((double)minX, (double)maxX, (double)minY, (double)maxY, (double)this.xs[0], (double)this.ys[0], (double)aX, (double)aY, (double)bX, (double)bY, (double)cX, (double)cY) || H3CartesianUtil.crossesTriangle(this.xs, this.ys, this.xs.length, this.crossesDateline, minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, true);
        }

        public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
            return this.contains(aX, aY) && this.contains(bX, bY) && !this.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, false);
        }

        public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
            return this.contains(aX, aY) && this.contains(bX, bY) && this.contains(cX, cY) && !H3CartesianUtil.crossesTriangle(this.xs, this.ys, this.xs.length, this.crossesDateline, minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, false);
        }

        public Component2D.WithinRelation withinPoint(double x, double y) {
            return this.contains(x, y) ? Component2D.WithinRelation.NOTWITHIN : Component2D.WithinRelation.DISJOINT;
        }

        public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
            if (Component2D.disjoint((double)this.getMinX(), (double)this.getMaxX(), (double)this.getMinY(), (double)this.getMaxY(), (double)minX, (double)maxX, (double)minY, (double)maxY)) {
                return Component2D.WithinRelation.DISJOINT;
            }
            if (this.contains(aX, aY) || this.contains(bX, bY)) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            if (ab && this.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true)) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            return Component2D.WithinRelation.DISJOINT;
        }

        public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
            if (Component2D.disjoint((double)this.getMinX(), (double)this.getMaxX(), (double)this.getMinY(), (double)this.getMaxY(), (double)minX, (double)maxX, (double)minY, (double)maxY)) {
                return Component2D.WithinRelation.DISJOINT;
            }
            if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
            if (this.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true)) {
                if (ab) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (this.crossesLine(minX, maxX, minY, maxY, bX, bY, cX, cY, true)) {
                if (bc) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (this.crossesLine(minX, maxX, minY, maxY, cX, cY, aX, aY, true)) {
                if (ca) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (relation == Component2D.WithinRelation.CANDIDATE) {
                return Component2D.WithinRelation.CANDIDATE;
            }
            if (Component2D.pointInTriangle((double)minX, (double)maxX, (double)minY, (double)maxY, (double)this.xs[0], (double)this.ys[0], (double)aX, (double)aY, (double)bX, (double)bY, (double)cX, (double)cY)) {
                return Component2D.WithinRelation.CANDIDATE;
            }
            return relation;
        }

        private boolean crossesLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, boolean includeBoundary) {
            if (Component2D.disjoint((double)this.getMinX(), (double)this.getMaxX(), (double)this.getMinY(), (double)this.getMaxY(), (double)minX, (double)maxX, (double)minY, (double)maxY)) {
                return false;
            }
            return H3CartesianUtil.crossesLine(this.xs, this.ys, this.xs.length, this.crossesDateline, minX, maxX, minY, maxY, aX, aY, bX, bY, includeBoundary);
        }

        private ContainsCorners containsCorners(double minX, double maxX, double minY, double maxY) {
            int containsCount = 0;
            if (this.contains(minX, minY)) {
                ++containsCount;
            }
            if (this.contains(maxX, minY)) {
                ++containsCount;
            }
            if (containsCount == 1) {
                return ContainsCorners.SOME;
            }
            if (this.contains(maxX, maxY)) {
                ++containsCount;
            }
            if (containsCount == 2) {
                return ContainsCorners.SOME;
            }
            if (this.contains(minX, maxY)) {
                ++containsCount;
            }
            return containsCount == 0 ? ContainsCorners.NONE : (containsCount == 4 ? ContainsCorners.ALL : ContainsCorners.SOME);
        }

        private static enum ContainsCorners {
            NONE,
            SOME,
            ALL;

        }
    }
}

