/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.metrics.InternalCentroid;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.CartesianCentroid;

public class InternalCartesianCentroid
extends InternalCentroid
implements CartesianCentroid {
    public InternalCartesianCentroid(String name, SpatialPoint centroid, long count, Map<String, Object> metadata) {
        super(name, centroid, count, metadata);
    }

    public InternalCartesianCentroid(StreamInput in) throws IOException {
        super(in);
    }

    protected CartesianPoint centroidFromStream(StreamInput in) throws IOException {
        return new CartesianPoint(in.readDouble(), in.readDouble());
    }

    static InternalCartesianCentroid empty(String name, Map<String, Object> metadata) {
        return new InternalCartesianCentroid(name, null, 0L, metadata);
    }

    protected void centroidToStream(StreamOutput out) throws IOException {
        out.writeDouble(this.centroid.getX());
        out.writeDouble(this.centroid.getY());
    }

    public String getWriteableName() {
        return "cartesian_centroid";
    }

    protected double extractDouble(String name) {
        return switch (name) {
            case "x" -> this.centroid.getX();
            case "y" -> this.centroid.getY();
            default -> throw new IllegalArgumentException("Found unknown path element [" + name + "] in [" + this.getName() + "]");
        };
    }

    protected InternalCartesianCentroid copyWith(SpatialPoint result, long count) {
        return new InternalCartesianCentroid(this.name, result, count, this.getMetadata());
    }

    protected InternalCartesianCentroid copyWith(double firstSum, double secondSum, long totalCount) {
        CartesianPoint result = Double.isNaN(firstSum) ? null : new CartesianPoint(firstSum / (double)totalCount, secondSum / (double)totalCount);
        return this.copyWith(result, totalCount);
    }

    protected String nameFirst() {
        return "x";
    }

    protected double extractFirst(SpatialPoint point) {
        return point.getX();
    }

    protected String nameSecond() {
        return "y";
    }

    protected double extractSecond(SpatialPoint point) {
        return point.getY();
    }
}

