/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.capacity;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.Processors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;

public class FixedAutoscalingDeciderService
implements AutoscalingDeciderService {
    public static final String NAME = "fixed";
    public static final Setting<ByteSizeValue> STORAGE = Setting.byteSizeSetting((String)"storage", (ByteSizeValue)ByteSizeValue.ofBytes((long)-1L), (Setting.Property[])new Setting.Property[0]);
    public static final Setting<ByteSizeValue> MEMORY = Setting.byteSizeSetting((String)"memory", (ByteSizeValue)ByteSizeValue.ofBytes((long)-1L), (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Processors> PROCESSORS = new Setting("processors", Double.toString(1.0), textValue -> Processors.of((Double)Double.parseDouble(textValue)), new Setting.Property[0]);
    public static final Setting<Integer> NODES = Setting.intSetting((String)"nodes", (int)1, (int)0, (Setting.Property[])new Setting.Property[0]);

    @Inject
    public FixedAutoscalingDeciderService() {
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public AutoscalingDeciderResult scale(Settings configuration, AutoscalingDeciderContext context) {
        int nodes = (Integer)NODES.get(configuration);
        ByteSizeValue storage = STORAGE.exists(configuration) ? (ByteSizeValue)STORAGE.get(configuration) : null;
        ByteSizeValue memory = MEMORY.exists(configuration) ? (ByteSizeValue)MEMORY.get(configuration) : null;
        Processors processors = PROCESSORS.exists(configuration) ? (Processors)PROCESSORS.get(configuration) : null;
        AutoscalingCapacity requiredCapacity = storage != null || memory != null || processors != null ? AutoscalingCapacity.builder().total(FixedAutoscalingDeciderService.totalCapacity(storage, nodes), FixedAutoscalingDeciderService.totalCapacity(memory, nodes), FixedAutoscalingDeciderService.totalCapacity(processors, nodes)).node(storage, memory, processors).build() : null;
        return new AutoscalingDeciderResult(requiredCapacity, new FixedReason(storage, memory, nodes, processors));
    }

    private static ByteSizeValue totalCapacity(ByteSizeValue nodeCapacity, int nodes) {
        if (nodeCapacity != null) {
            return ByteSizeValue.ofBytes((long)(nodeCapacity.getBytes() * (long)nodes));
        }
        return null;
    }

    private static Processors totalCapacity(Processors nodeCapacity, int nodes) {
        if (nodeCapacity != null) {
            return nodeCapacity.multiply(nodes);
        }
        return null;
    }

    @Override
    public List<Setting<?>> deciderSettings() {
        return List.of(STORAGE, MEMORY, NODES, PROCESSORS);
    }

    @Override
    public List<DiscoveryNodeRole> roles() {
        return DiscoveryNodeRole.roles().stream().toList();
    }

    @Override
    public boolean appliesToEmptyRoles() {
        return true;
    }

    @Override
    public boolean defaultOn() {
        return false;
    }

    public static class FixedReason
    implements AutoscalingDeciderResult.Reason {
        private final ByteSizeValue storage;
        private final ByteSizeValue memory;
        private final Processors processors;
        private final int nodes;

        public FixedReason(ByteSizeValue storage, ByteSizeValue memory, int nodes, Processors processors) {
            this.storage = storage;
            this.memory = memory;
            this.nodes = nodes;
            this.processors = processors;
        }

        public FixedReason(StreamInput in) throws IOException {
            this.storage = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::readFrom);
            this.memory = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::readFrom);
            this.nodes = in.readInt();
            this.processors = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_4_0) ? (Processors)in.readOptionalWriteable(Processors::readFrom) : null;
        }

        @Override
        public String summary() {
            return String.format(Locale.ROOT, "fixed storage [%s] memory [%s] processors [%s] nodes [%d]", this.storage, this.memory, this.processors, this.nodes);
        }

        public String getWriteableName() {
            return FixedAutoscalingDeciderService.NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.storage);
            out.writeOptionalWriteable((Writeable)this.memory);
            out.writeInt(this.nodes);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_4_0)) {
                out.writeOptionalWriteable((Writeable)this.processors);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("storage", (ToXContent)this.storage);
            builder.field("memory", (ToXContent)this.memory);
            builder.field("nodes", this.nodes);
            if (this.processors != null) {
                builder.field("processors", (ToXContent)this.processors);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixedReason that = (FixedReason)o;
            return this.nodes == that.nodes && Objects.equals(this.storage, that.storage) && Objects.equals(this.memory, that.memory) && Objects.equals(this.processors, that.processors);
        }

        public int hashCode() {
            return Objects.hash(this.storage, this.memory, this.nodes, this.processors);
        }
    }
}

