/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.watcher.WatcherField;
import org.elasticsearch.xpack.watcher.Watcher;

final class EncryptSensitiveDataBootstrapCheck
implements BootstrapCheck {
    EncryptSensitiveDataBootstrapCheck() {
    }

    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        if (((Boolean)Watcher.ENCRYPT_SENSITIVE_DATA_SETTING.get(context.settings())).booleanValue() && !WatcherField.ENCRYPTION_KEY_SETTING.exists(context.settings())) {
            Path systemKeyPath = XPackPlugin.resolveConfigFile((Environment)context.environment(), (String)"system_key").toAbsolutePath();
            String message = Files.exists(systemKeyPath, new LinkOption[0]) ? "Encryption of sensitive data requires the key to be placed in the secure setting store. Run 'bin/elasticsearch-keystore add-file " + WatcherField.ENCRYPTION_KEY_SETTING.getKey() + " " + String.valueOf(systemKeyPath) + "' to import the file.\nAfter importing, the system_key file should be removed from the filesystem.\nRepeat this on every node in the cluster." : "Encryption of sensitive data requires a key to be placed in the secure setting store. First run the bin/elasticsearch-syskeygen tool to generate a key file.\nThen run 'bin/elasticsearch-keystore add-file " + WatcherField.ENCRYPTION_KEY_SETTING.getKey() + " " + String.valueOf(systemKeyPath) + "' to import the key into the secure setting store. Finally, remove the system_key file from the filesystem.\nRepeat this on every node in the cluster";
            return BootstrapCheck.BootstrapCheckResult.failure((String)message);
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }

    public boolean alwaysEnforce() {
        return true;
    }

    public ReferenceDocs referenceDocs() {
        return ReferenceDocs.BOOTSTRAP_CHECK_ENCRYPT_SENSITIVE_DATA;
    }
}

