/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.search;

import java.io.IOException;
import java.util.function.Predicate;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.input.InputFactory;
import org.elasticsearch.xpack.watcher.input.search.ExecutableSearchInput;
import org.elasticsearch.xpack.watcher.input.search.SearchInput;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateService;

public class SearchInputFactory
extends InputFactory<SearchInput, SearchInput.Result, ExecutableSearchInput> {
    private final Client client;
    private final TimeValue defaultTimeout;
    private final WatcherSearchTemplateService searchTemplateService;

    public SearchInputFactory(Settings settings, Client client, NamedXContentRegistry xContentRegistry, Predicate<NodeFeature> clusterSupportsFeature, ScriptService scriptService) {
        this.client = client;
        this.defaultTimeout = settings.getAsTime("xpack.watcher.input.search.default_timeout", TimeValue.timeValueMinutes((long)1L));
        this.searchTemplateService = new WatcherSearchTemplateService(scriptService, xContentRegistry, clusterSupportsFeature);
    }

    @Override
    public String type() {
        return "search";
    }

    @Override
    public SearchInput parseInput(String watchId, XContentParser parser) throws IOException {
        return SearchInput.parse(watchId, parser);
    }

    @Override
    public ExecutableSearchInput createExecutable(SearchInput input) {
        return new ExecutableSearchInput(input, this.client, this.searchTemplateService, this.defaultTimeout);
    }
}

