/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.linear;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.rank.linear.LinearRetrieverComponent;

public class LinearRankDoc
extends RankDoc {
    public static final String NAME = "linear_rank_doc";
    final float[] weights;
    final String[] normalizers;
    public float[] normalizedScores;

    public LinearRankDoc(int doc, float score, int shardIndex) {
        super(doc, score, shardIndex);
        this.weights = null;
        this.normalizers = null;
    }

    public LinearRankDoc(int doc, float score, int shardIndex, float[] weights, String[] normalizers) {
        super(doc, score, shardIndex);
        this.weights = weights;
        this.normalizers = normalizers;
    }

    public LinearRankDoc(StreamInput in) throws IOException {
        super(in);
        this.weights = in.readOptionalFloatArray();
        this.normalizedScores = in.readOptionalFloatArray();
        this.normalizers = in.readOptionalStringArray();
    }

    public Explanation explain(Explanation[] sources, String[] queryNames) {
        assert (this.normalizedScores != null && this.weights != null && this.normalizers != null);
        assert (this.normalizedScores.length == sources.length);
        Explanation[] details = new Explanation[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            String normalizer;
            String queryAlias = queryNames[i] == null ? "" : " [" + queryNames[i] + "]";
            String queryIdentifier = "at index [" + i + "]" + queryAlias;
            float weight = this.weights == null ? 1.0f : this.weights[i];
            float normalizedScore = this.normalizedScores == null ? 0.0f : this.normalizedScores[i];
            String string = normalizer = this.normalizers == null ? LinearRetrieverComponent.DEFAULT_NORMALIZER.getName() : this.normalizers[i];
            if (normalizedScore > 0.0f) {
                details[i] = Explanation.match((Number)Float.valueOf(weight * normalizedScore), (String)("weighted score: [" + weight * normalizedScore + "] in query " + queryIdentifier + " computed as [" + weight + " * " + normalizedScore + "] using score normalizer [" + normalizer + "] for original matching query with score:"), (Explanation[])new Explanation[]{sources[i]});
                continue;
            }
            String description = "weighted score: [0], result not found in query " + queryIdentifier;
            details[i] = Explanation.noMatch((String)description, (Explanation[])new Explanation[0]);
        }
        return Explanation.match((Number)Float.valueOf(this.score), (String)("weighted linear combination score: [" + this.score + "] computed for normalized scores " + Arrays.toString(this.normalizedScores) + (String)(this.weights == null ? "" : " and weights " + Arrays.toString(this.weights)) + " as sum of (weight[i] * score[i]) for each query."), (Explanation[])details);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalFloatArray(this.weights);
        out.writeOptionalFloatArray(this.normalizedScores);
        out.writeOptionalStringArray(this.normalizers);
    }

    protected void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.weights != null) {
            builder.field("weights", (Object)this.weights);
        }
        if (this.normalizedScores != null) {
            builder.field("normalizedScores", (Object)this.normalizedScores);
        }
        if (this.normalizers != null) {
            builder.field("normalizers", this.normalizers);
        }
    }

    public boolean doEquals(RankDoc rd) {
        LinearRankDoc lrd = (LinearRankDoc)rd;
        return Arrays.equals(this.weights, lrd.weights) && Arrays.equals(this.normalizedScores, lrd.normalizedScores) && Arrays.equals(this.normalizers, lrd.normalizers);
    }

    public int doHashCode() {
        int result = Objects.hash(Arrays.hashCode(this.weights), Arrays.hashCode(this.normalizedScores), Arrays.hashCode(this.normalizers));
        return 31 * result;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.LINEAR_RETRIEVER_SUPPORT;
    }
}

