/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.script.expression.FieldDataBasedDoubleValuesSource;
import org.elasticsearch.search.MultiValueMode;

class FieldDataValueSource
extends FieldDataBasedDoubleValuesSource {
    final MultiValueMode multiValueMode;

    protected FieldDataValueSource(IndexFieldData<?> fieldData, MultiValueMode multiValueMode) {
        super(fieldData);
        this.multiValueMode = Objects.requireNonNull(multiValueMode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FieldDataValueSource that = (FieldDataValueSource)((Object)o);
        if (!this.fieldData.equals((Object)that.fieldData)) {
            return false;
        }
        return this.multiValueMode == that.multiValueMode;
    }

    public int hashCode() {
        int result = this.fieldData.hashCode();
        result = 31 * result + this.multiValueMode.hashCode();
        return result;
    }

    public DoubleValues getValues(LeafReaderContext leaf, DoubleValues scores) {
        LeafNumericFieldData leafData = (LeafNumericFieldData)this.fieldData.load(leaf);
        final NumericDoubleValues docValues = this.multiValueMode.select(leafData.getDoubleValues());
        return new DoubleValues(this){

            public double doubleValue() throws IOException {
                return docValues.doubleValue();
            }

            public boolean advanceExact(int doc) throws IOException {
                return docValues.advanceExact(doc);
            }
        };
    }

    public String toString() {
        return "field(" + this.fieldData.getFieldName() + ")";
    }
}

