/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.arrow;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.versionfield.Version;

public class ValueConversions {
    public static BytesRef shortenIpV4Addresses(BytesRef value, BytesRef scratch) {
        if (value.length == 16) {
            boolean isIpV4;
            int pos = value.offset;
            byte[] bytes = value.bytes;
            boolean bl = isIpV4 = bytes[pos++] == 0 && bytes[pos++] == 0 && bytes[pos++] == 0 && bytes[pos++] == 0 && bytes[pos++] == 0 && bytes[pos++] == 0 && bytes[pos++] == 0 && bytes[pos++] == 0 && bytes[pos++] == 0 && bytes[pos++] == 0 && bytes[pos++] == -1 && bytes[pos] == -1;
            if (isIpV4) {
                scratch.bytes = value.bytes;
                scratch.offset = value.offset + 12;
                scratch.length = 4;
                return scratch;
            }
        }
        return value;
    }

    public static BytesRef versionToString(BytesRef value, BytesRef scratch) {
        return new BytesRef((CharSequence)new Version(value).toString());
    }

    public static BytesRef sourceToJson(BytesRef value, BytesRef scratch) {
        try {
            BytesArray valueArray = new BytesArray(value);
            XContentType xContentType = XContentHelper.xContentType((BytesReference)valueArray);
            if (xContentType == XContentType.JSON) {
                return value;
            }
            String json = XContentHelper.convertToJson((BytesReference)valueArray, (boolean)false, (XContentType)xContentType);
            return new BytesRef((CharSequence)json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

