/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.RegressionFeatureImportance;
import org.elasticsearch.xpack.core.ml.inference.results.SingleValueInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfig;

public class RegressionInferenceResults
extends SingleValueInferenceResults {
    public static final String NAME = "regression";
    private final String resultsField;
    private final List<RegressionFeatureImportance> featureImportance;

    public RegressionInferenceResults(double value, InferenceConfig config) {
        this(value, config, Collections.emptyList());
    }

    public RegressionInferenceResults(double value, InferenceConfig config, List<RegressionFeatureImportance> featureImportance) {
        this(value, ((RegressionConfig)config).getResultsField(), ((RegressionConfig)config).getNumTopFeatureImportanceValues(), featureImportance);
    }

    public RegressionInferenceResults(double value, String resultsField) {
        this(value, resultsField, 0, Collections.emptyList());
    }

    public RegressionInferenceResults(double value, String resultsField, List<RegressionFeatureImportance> featureImportance) {
        this(value, resultsField, featureImportance.size(), featureImportance);
    }

    public RegressionInferenceResults(double value, String resultsField, int topNFeatures, List<RegressionFeatureImportance> featureImportance) {
        super(value);
        this.resultsField = resultsField;
        this.featureImportance = RegressionInferenceResults.takeTopFeatureImportances(featureImportance, topNFeatures);
    }

    static List<RegressionFeatureImportance> takeTopFeatureImportances(List<RegressionFeatureImportance> featureImportances, int numTopFeatures) {
        if (featureImportances == null || featureImportances.isEmpty()) {
            return Collections.emptyList();
        }
        return featureImportances.stream().sorted((l, r) -> Double.compare(Math.abs(r.getImportance()), Math.abs(l.getImportance()))).limit(numTopFeatures).toList();
    }

    public RegressionInferenceResults(StreamInput in) throws IOException {
        super(in);
        this.featureImportance = in.readCollectionAsList(RegressionFeatureImportance::new);
        this.resultsField = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.featureImportance);
        out.writeString(this.resultsField);
    }

    public List<RegressionFeatureImportance> getFeatureImportance() {
        return this.featureImportance;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RegressionInferenceResults that = (RegressionInferenceResults)object;
        return Objects.equals(this.value(), that.value()) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.featureImportance, that.featureImportance);
    }

    public int hashCode() {
        return Objects.hash(this.value(), this.resultsField, this.featureImportance);
    }

    public Object predictedValue() {
        return super.value();
    }

    public String getResultsField() {
        return this.resultsField;
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.addSupportingFieldsToMap(map);
        map.put(this.resultsField, this.value());
        return map;
    }

    public Map<String, Object> asMap(String outputField) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.addSupportingFieldsToMap(map);
        map.put(outputField, this.value());
        return map;
    }

    private void addSupportingFieldsToMap(Map<String, Object> map) {
        if (!this.featureImportance.isEmpty()) {
            map.put("feature_importance", this.featureImportance.stream().map(RegressionFeatureImportance::toMap).collect(Collectors.toList()));
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.resultsField, this.value());
        if (!this.featureImportance.isEmpty()) {
            builder.field("feature_importance", this.featureImportance);
        }
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }
}

