/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;

public final class QueryUserRequest
extends ActionRequest {
    @Nullable
    private final QueryBuilder queryBuilder;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final List<FieldSortBuilder> fieldSortBuilders;
    @Nullable
    private final SearchAfterBuilder searchAfterBuilder;
    private final boolean withProfileUid;

    public QueryUserRequest() {
        this(null);
    }

    public QueryUserRequest(QueryBuilder queryBuilder) {
        this(queryBuilder, null, null, null, null, false);
    }

    public QueryUserRequest(@Nullable QueryBuilder queryBuilder, @Nullable Integer from, @Nullable Integer size, @Nullable List<FieldSortBuilder> fieldSortBuilders, @Nullable SearchAfterBuilder searchAfterBuilder, boolean withProfileUid) {
        this.queryBuilder = queryBuilder;
        this.from = from;
        this.size = size;
        this.fieldSortBuilders = fieldSortBuilders;
        this.searchAfterBuilder = searchAfterBuilder;
        this.withProfileUid = withProfileUid;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getSize() {
        return this.size;
    }

    public List<FieldSortBuilder> getFieldSortBuilders() {
        return this.fieldSortBuilders;
    }

    public SearchAfterBuilder getSearchAfterBuilder() {
        return this.searchAfterBuilder;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.from != null && this.from < 0) {
            validationException = ValidateActions.addValidationError((String)("[from] parameter cannot be negative but was [" + this.from + "]"), validationException);
        }
        if (this.size != null && this.size < 0) {
            validationException = ValidateActions.addValidationError((String)("[size] parameter cannot be negative but was [" + this.size + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    public boolean isWithProfileUid() {
        return this.withProfileUid;
    }
}

