/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.RuleSetValidation;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.CacheableYamlSource;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesValidation;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.Validator;
import com.dtolabs.rundeck.core.authorization.providers.YamlProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;

public class YamlValidator
implements Validator {
    public static YamlValidator create() {
        return new YamlValidator();
    }

    public PoliciesValidation validateYamlPolicy(String ident, String text) throws IOException {
        return this.validateYamlPolicy(null, ident, text);
    }

    @Override
    public RuleSetValidation<PolicyCollection> validateYamlPolicy(String ident, File source2) throws IOException {
        return this.validateYamlPolicy(null, ident, source2);
    }

    public PoliciesValidation validateYamlPolicy(String project, String ident, String text) throws IOException {
        ValidationSet validation = new ValidationSet();
        CacheableYamlSource source2 = YamlProvider.sourceFromString(ident, text, new Date(), validation);
        PolicyCollection policies = YamlProvider.policiesFromSource(source2, project != null ? AuthorizationUtil.projectContext(project) : null, validation);
        validation.complete();
        return new PoliciesValidation(validation, policies);
    }

    public PoliciesValidation validateYamlPolicy(String project, String ident, File source2) throws IOException {
        ValidationSet validation = new ValidationSet();
        PolicyCollection policies = null;
        try (FileInputStream stream = new FileInputStream(source2);){
            CacheableYamlSource streamSource = YamlProvider.sourceFromStream(ident, stream, new Date(), validation);
            policies = YamlProvider.policiesFromSource(streamSource, project != null ? AuthorizationUtil.projectContext(project) : null, validation);
        }
        validation.complete();
        return new PoliciesValidation(validation, policies);
    }

    public PoliciesValidation validateYamlPolicy(File file) throws IOException {
        ValidationSet validation = new ValidationSet();
        PolicyCollection policies = YamlProvider.policiesFromSource(YamlProvider.sourceFromFile(file, validation), null, validation);
        validation.complete();
        return new PoliciesValidation(validation, policies);
    }
}

