/*
 * ftpsys_windows.cpp
 * Copyleft (C) 2002 Zachary Bedell <aramis@adirondack.net>
 *  Based on ftpsys_unix.cpp which is:
 * Copyright (C) 2002 Florin Malita <mali@go.ro>
 *
 * This file is part of LUFS, a free userspace filesystem implementation.
 * See http://lufs.sourceforge.net/ for updates.
 *
 * LUFS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LUFS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include <sys/types.h>
#include <sys/stat.h>

#ifndef __USE_XOPEN
#define __USE_XOPEN
#endif

#include <time.h>

#include <lufs/proto.h>
#include <lufs/fs.h>

#include "ftpsys.h"
#include "ftpsys_windows.h"

static char*
next_word(char *c){
    while( (*c != ' ') && (*c != 0))
        c++;
    if(! *c)
        return c;

    while(*c == ' ')
        c++;    
    return c;
}

ftpsys_windows::ftpsys_windows(){
    CMD_LIST = "LIST -al";
}

ftpsys_windows::~ftpsys_windows(){

}

int
ftpsys_windows::parse_line(char *buf, char *file, struct lufs_fattr *fattr, char *link, struct credentials *cred){
    unsigned long size = 0;
    int res;
    struct tm tm;
    time_t tt;
    char sDate[20], sTime[20], datetime[40];

    *file = *link = sDate[0] = sTime[0] = datetime[0] = 0;

    if(tolower(buf[25]) == 'd') {
        res = sscanf(buf, "%8s %7s %*5s %1024s", sDate, sTime, file);
    } else {
        res = sscanf(buf, "%8s %7s %lu %1024s", sDate, sTime, &size, file);
    }

    if(res < 2) {
        TRACE("could only match "<<res<<" attributes");
        return -1;
    }

    sprintf(datetime, "%s %s", sDate, sTime);

    tt = time(NULL);
    gmtime_r(&tt, &tm);
    tm.tm_sec = 0;

    strptime(datetime, "%m-%e-%y  %I:%M%p", &tm);

    memset(fattr, 0, sizeof(struct lufs_fattr));

    fattr->f_uid = 1;
    fattr->f_gid = 1;

    fattr->f_nlink = 0;
    fattr->f_size = size;
    fattr->f_ctime = fattr->f_mtime = fattr->f_atime = mktime(&tm);
    
    if(tolower(buf[25]) == 'd') fattr->f_mode = S_IFDIR;
    else fattr->f_mode = S_IFREG;

    fattr->f_mode |= S_IRUSR | S_IWUSR | S_IXUSR | S_IRGRP | S_IWGRP | S_IXGRP | S_IROTH | S_IWOTH | S_IXOTH;

    TRACE("file: " << file<<", link: " << link);
    return 0;
}


