#include <unistd.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>

#include <sys/socket.h>

#include <arpa/inet.h>

#include "gnet_lib.h"
#include "gnet_host.h"
#include "gnet_channel.h"



static int
add_peer(struct gnet *gnet, struct host *hst){
    struct channel *chan;

    if(!(chan = gnet_channel_create(gnet)))
	return -1;

    memcpy(chan->c_addr, &hst->ip, 4);
    chan->c_port = hst->port;

    if(gnet_channel_connect(chan) < 0){
	WARN("could not initiate connection: %s", strerror(errno));
	gnet_channel_destroy(gnet, chan);
	return -1;
    }

    list_add(&chan->c_list, &gnet->g_channels);
    gnet->g_connecting_peers++;
    gnet_test_wr(gnet, chan);

//    TRACE("new peer added...");

    return 0;
}

int
gnet_add_host(struct gnet *gnet, char *ip, unsigned short port){
    struct host *hst;

//    TRACE("adding %s:%hu", ip, port);

    if(!(hst = malloc(sizeof(struct host))) || (gnet->g_nr_hosts >= gnet->g_cfg->max_hosts))
	return -1;

    hst->ip = inet_addr(ip);
    hst->port = port;

    list_add_tail(&hst->list, &gnet->g_hosts);
    gnet->g_nr_hosts++;

//    TRACE("%d known hosts", gnet->g_nr_hosts);

    return 0;
}

int
gnet_check_peers(struct gnet *gnet){
    struct host *hst;

    if(gnet->g_connected_peers >= gnet->g_cfg->keep_peers){
//	TRACE("enough connected peers");
	return 0;
    }

    while((gnet->g_connecting_peers < gnet->g_cfg->keep_connecting) && (!list_empty(&gnet->g_hosts))){
//	TRACE("adding peer");
	hst = list_entry(gnet->g_hosts.next, struct host, list);

	add_peer(gnet, hst);

	list_del(&hst->list);
	gnet->g_nr_hosts--;
    }

    if(gnet->g_connecting_peers >= gnet->g_cfg->keep_connecting){
//	TRACE("we have enough connecting peers");
	return 0;
    }else{
//	TRACE("not enough known hosts...");
	return -1;
    }
    
}

int
gnet_get_hosts(struct gnet *gnet, char *reply){
    char *xtry, *eol, *c, *sep;
    int found = 0;

//    TRACE("scanning for new hosts...");

    if(!(xtry = strstr(reply, "X-Try:"))){
//	TRACE("no hosts");
	return -1;
    }

    if(!(eol = strstr(xtry, "\r\n"))){
	TRACE("no eol?!");
	return -1;
    }

    *eol = 0;
    xtry += strlen("X-Try:");

    while((c = strsep(&xtry, ","))){
//	TRACE("host: %s", c);

	if(!(sep = strchr(c, ':'))){
	    TRACE("no port delimiter");
	    continue;
	}

	*sep++ = 0;
	
	if(!atoi(sep)){
	    TRACE("could not convert port");
	    continue;
	}

	gnet_add_host(gnet, c, atoi(sep));
	found++;
    }

//    TRACE("done");

    return found;
}
