/*
	file automatically generated by make_test_files.pl
	Wed Mar 16 14:50:45 2022
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for DAU
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_dau_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */

#define COMPARE_SAMPLE_SIZE   (10000)
#define VIOLATE_SAMPLE_SIZE   (20)

double *make_geometric_vector(double q, int len);
double *make_random_vector(int len);
UNUR_DISTR *get_distr_with_invalid_pv( void );
UNUR_DISTR *get_distr_with_pv( void );




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



/*---------------------------------------------------------------------------*/

/* make a probability vector (need not sum to one)
   (use random entries)                                                      */
double *make_random_vector(int len)
{
  double *pv;
  int i;

  /* allocate memory */
  pv = malloc(len*sizeof(double));
  if (!pv) abort();
     
  /* main part of geometric distribution */
  for( i=0; i<len; i++ ) 
    pv[i] = unur_urng_fish(NULL);

  return pv;

} /* end of make_random_vector() */

/*---------------------------------------------------------------------------*/

/* make a probability vector (need not sum to one)
   (use geometric distribution)                                              */
double *make_geometric_vector(double q, int len)
{
  double *pv;
  int i;

  /* allocate memory */
  pv = malloc(len * sizeof(double));
  if (!pv) abort();

  /* main part of geometric distribution */
  pv[0] = 1.;
  for( i=1; i<len; i++ ) 
    pv[i] = pv[i-1] * q;

  return pv;

} /* end of make_geometric_vector() */

/*---------------------------------------------------------------------------*/

UNUR_DISTR *get_distr_with_pv( void )
{
#define PV_SIZE 200
  double pv[PV_SIZE];
  UNUR_DISTR *distr;
  int i;

  for (i=0; i<PV_SIZE; i++)
    pv[i] = unur_urng_fish(NULL);

  distr = unur_distr_discr_new();
  unur_distr_discr_set_pv(distr,pv,PV_SIZE);

  return distr;

#undef PV_SIZE
} /* end of get_distr_with_pv() */

/*---------------------------------------------------------------------------*/

UNUR_DISTR *get_distr_with_invalid_pv( void )
{
#define PV_SIZE 10
  double pv[PV_SIZE];
  UNUR_DISTR *distr;
  int i;

  pv[0] = -1.;    /* invalid ! */

  for (i=1; i<PV_SIZE; i++)
    pv[i] = unur_urng_fish(NULL);

  distr = unur_distr_discr_new();
  unur_distr_discr_set_pv(distr,pv,PV_SIZE);

  return distr;
  
#undef PV_SIZE
} /* end of get_distr_with_invalid_pv() */

/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,31,(unur_dau_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,31,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,37,(unur_dau_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,37,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* data missing in distribution object */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new();   /* no probability vector */ 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,43,(unur_dau_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,43,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,53,(unur_dau_set_urnfactor(par,1.)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,53,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = get_distr_with_pv();
   par = unur_dgt_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,60,(unur_dau_set_urnfactor(par,1.)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,60,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = get_distr_with_pv();
   par = unur_dau_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,69,(unur_dau_set_urnfactor(par,0.8)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,69,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [init] */

void test_init (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[init "); fflush(stdout);
	fprintf(TESTLOG,"\n[init]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,89,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,89,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid data */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = get_distr_with_invalid_pv();
   par = unur_dau_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,97,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,97,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_init() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* exist */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {10.,0.63};
   distr = unur_distr_binomial(fpar,2);
   par = unur_dau_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 108,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_reinit(TESTLOG,112,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double fpar[] = {10,0.3}; 
   distr = unur_distr_binomial(fpar,2);
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_dau_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,129,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,135,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare reinit */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[] = {10,0.3}; 
   distr = unur_distr_binomial(fpar,2);
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_dau_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,148,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* reinit */
unur_reinit(gen);
n_tests_failed += (compare_sequence_gen(TESTLOG,152,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare stringparser */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double pv[] = {.1, .2, .3, .4, .5, .6, .7, .8, .9, 1.};
   double fpar[] = {0.8};
   distr = NULL;
   par = NULL;
   gen = NULL; 


unur_reset_errno();
distr = unur_distr_discr_new();
unur_distr_discr_set_pv(distr,pv,10);
par = unur_dau_new(distr);
unur_dau_set_urnfactor(par,3.);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,168,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "discr; pv = (.1, .2, .3, .4, .5, .6, .7, .8, .9, 1.) & \
  method = dau; urnfactor = 3." );
n_tests_failed += (compare_sequence_gen(TESTLOG,174,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_geometric(fpar,1);
par = unur_dau_new(distr);
unur_dau_set_urnfactor(par,3.);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,182,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "geometric(0.8) & method = dau; urnfactor = 3." );
n_tests_failed += (compare_sequence_gen(TESTLOG,187,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	/* suppress GCC compiler warning */
GCC_DIAG_OFF(unused-variable)

	UNUR_DISTR *distr[23];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	double *darray;
	double fpm[10];
	int n_tests_failed;
	int rcode;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 23 */
{
distr[0] = unur_distr_discr_new();
darray = make_random_vector(10);
unur_distr_discr_set_pv(distr[0],darray,10);
free(darray);
unur_distr_set_name(distr[0],"pv(random)");
}

{
distr[1] = unur_distr_discr_new();
darray = make_random_vector(100);
unur_distr_discr_set_pv(distr[1],darray,100);
free(darray);
unur_distr_set_name(distr[1],"pv(random)");
}

{
distr[2] = unur_distr_discr_new();
darray = make_random_vector(1000);
unur_distr_discr_set_pv(distr[2],darray,1000);
free(darray);
unur_distr_set_name(distr[2],"pv(random)");
}

{
distr[3] = unur_distr_discr_new();
darray = make_random_vector(10000);
unur_distr_discr_set_pv(distr[3],darray,10000);
free(darray);
unur_distr_set_name(distr[3],"pv(random)");
}

{
distr[4] = unur_distr_discr_new();
darray = make_geometric_vector(1.,1000);
unur_distr_discr_set_pv(distr[4],darray,1000);
free(darray);
unur_distr_set_name(distr[4],"pv(geometric)");
}

{
distr[5] = unur_distr_discr_new();
darray = make_geometric_vector(0.99,1000);
unur_distr_discr_set_pv(distr[5],darray,1000);
free(darray);
unur_distr_set_name(distr[5],"pv(geometric)");
}

{
distr[6] = unur_distr_discr_new();
darray = make_geometric_vector(0.9,1000);
unur_distr_discr_set_pv(distr[6],darray,1000);
free(darray);
unur_distr_set_name(distr[6],"pv(geometric)");
}

{
distr[7] = unur_distr_discr_new();
darray = make_geometric_vector(0.5,1000);
unur_distr_discr_set_pv(distr[7],darray,1000);
free(darray);
unur_distr_set_name(distr[7],"pv(geometric)");
}

{
distr[8] = unur_distr_discr_new();
darray = make_geometric_vector(0.1,1000);
unur_distr_discr_set_pv(distr[8],darray,1000);
free(darray);
unur_distr_set_name(distr[8],"pv(geometric)");
}

{
distr[9] = unur_distr_discr_new();
darray = make_geometric_vector(0.9,100);
unur_distr_discr_set_pv(distr[9],darray,100);
unur_distr_discr_set_domain(distr[9],10,209);
free(darray);
unur_distr_set_name(distr[9],"pv(geometric) - shifted domain");
}

{
distr[10] = unur_distr_discr_new();
darray = make_geometric_vector(0.9,100);
unur_distr_discr_set_pv(distr[10],darray,100);
unur_distr_discr_set_domain(distr[10],-10,209);
free(darray);
unur_distr_set_name(distr[10],"pv(geometric) - shifted domain");
}

{
fpm[0] = 0.5;
distr[11] = unur_distr_geometric(fpm,1);
}

{
fpm[0] = 0.001;
distr[12] = unur_distr_geometric(fpm,1);
}

{
fpm[0] = 0.1;
distr[13] = unur_distr_logarithmic(fpm,1);
}

{
fpm[0] = 0.999;
distr[14] = unur_distr_logarithmic(fpm,1);
}

{
fpm[0] = 0.5;
fpm[1] = 10.;
distr[15] = unur_distr_negativebinomial(fpm,2);
}

{
fpm[0] = 0.01;
fpm[1] = 20.;
distr[16] = unur_distr_negativebinomial(fpm,2);
}

{
fpm[0] = 0.1;
distr[17] = unur_distr_poisson(fpm,1);
}

{
fpm[0] = 0.999;
distr[18] = unur_distr_poisson(fpm,1);
}

{
fpm[0] = 2.;
fpm[1] = 1.;
distr[19] = unur_distr_zipf(fpm,2);
unur_distr_discr_set_domain(distr[19],1,1000);
}

{
fpm[0] = 0.001;
fpm[1] = 1.;
distr[20] = unur_distr_zipf(fpm,2);
unur_distr_discr_set_domain(distr[20],1,1000);
}

{
fpm[0] = 20.;
fpm[1] = 0.8;
distr[21] = unur_distr_binomial(fpm,2);
}

{
fpm[0] = 2000.;
fpm[1] = 0.0013;
distr[22] = unur_distr_binomial(fpm,2);
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 92 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [1] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [2] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [3] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [4] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [5] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [6] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [7] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [8] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [9] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [10] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [12] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [13] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [14] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [15] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [16] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [17] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [18] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [19] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [20] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [21] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
fpm[0] = 10.;
fpm[1] = 0.63;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [22] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_dau_new(distr_localcopy);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_dau_new(distr_localcopy);
unur_dau_set_urnfactor(par,10.);
unur_set_debug(par, 1u);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_domain(dg,2,7);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
{ UNUR_DISTR *dg =NULL;
par = unur_dau_new(distr_localcopy);
fpm[0] = 10.;
fpm[1] = 0.63;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_distr_discr_upd_pmfsum(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);
	unur_distr_free(distr[11]);
	unur_distr_free(distr[12]);
	unur_distr_free(distr[13]);
	unur_distr_free(distr[14]);
	unur_distr_free(distr[15]);
	unur_distr_free(distr[16]);
	unur_distr_free(distr[17]);
	unur_distr_free(distr[18]);
	unur_distr_free(distr[19]);
	unur_distr_free(distr[20]);
	unur_distr_free(distr[21]);
	unur_distr_free(distr[22]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_validate */

/* enable GCC compiler warning */
GCC_DIAG_ON(unused-variable)


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_dau_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_dau_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_dau_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_dau_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 601733;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 601733;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("dau: ");

	/* run tests */
test_new();
test_set();
test_init();
test_reinit();
test_sample();
test_validate();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

