// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2alpha1

import (
	"context"
	"time"

	v2alpha1 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2alpha1"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CiliumBGPPeeringPoliciesGetter has a method to return a CiliumBGPPeeringPolicyInterface.
// A group's client should implement this interface.
type CiliumBGPPeeringPoliciesGetter interface {
	CiliumBGPPeeringPolicies() CiliumBGPPeeringPolicyInterface
}

// CiliumBGPPeeringPolicyInterface has methods to work with CiliumBGPPeeringPolicy resources.
type CiliumBGPPeeringPolicyInterface interface {
	Create(ctx context.Context, ciliumBGPPeeringPolicy *v2alpha1.CiliumBGPPeeringPolicy, opts v1.CreateOptions) (*v2alpha1.CiliumBGPPeeringPolicy, error)
	Update(ctx context.Context, ciliumBGPPeeringPolicy *v2alpha1.CiliumBGPPeeringPolicy, opts v1.UpdateOptions) (*v2alpha1.CiliumBGPPeeringPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2alpha1.CiliumBGPPeeringPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2alpha1.CiliumBGPPeeringPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumBGPPeeringPolicy, err error)
	CiliumBGPPeeringPolicyExpansion
}

// ciliumBGPPeeringPolicies implements CiliumBGPPeeringPolicyInterface
type ciliumBGPPeeringPolicies struct {
	client rest.Interface
}

// newCiliumBGPPeeringPolicies returns a CiliumBGPPeeringPolicies
func newCiliumBGPPeeringPolicies(c *CiliumV2alpha1Client) *ciliumBGPPeeringPolicies {
	return &ciliumBGPPeeringPolicies{
		client: c.RESTClient(),
	}
}

// Get takes name of the ciliumBGPPeeringPolicy, and returns the corresponding ciliumBGPPeeringPolicy object, and an error if there is any.
func (c *ciliumBGPPeeringPolicies) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2alpha1.CiliumBGPPeeringPolicy, err error) {
	result = &v2alpha1.CiliumBGPPeeringPolicy{}
	err = c.client.Get().
		Resource("ciliumbgppeeringpolicies").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CiliumBGPPeeringPolicies that match those selectors.
func (c *ciliumBGPPeeringPolicies) List(ctx context.Context, opts v1.ListOptions) (result *v2alpha1.CiliumBGPPeeringPolicyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2alpha1.CiliumBGPPeeringPolicyList{}
	err = c.client.Get().
		Resource("ciliumbgppeeringpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ciliumBGPPeeringPolicies.
func (c *ciliumBGPPeeringPolicies) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("ciliumbgppeeringpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ciliumBGPPeeringPolicy and creates it.  Returns the server's representation of the ciliumBGPPeeringPolicy, and an error, if there is any.
func (c *ciliumBGPPeeringPolicies) Create(ctx context.Context, ciliumBGPPeeringPolicy *v2alpha1.CiliumBGPPeeringPolicy, opts v1.CreateOptions) (result *v2alpha1.CiliumBGPPeeringPolicy, err error) {
	result = &v2alpha1.CiliumBGPPeeringPolicy{}
	err = c.client.Post().
		Resource("ciliumbgppeeringpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumBGPPeeringPolicy).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ciliumBGPPeeringPolicy and updates it. Returns the server's representation of the ciliumBGPPeeringPolicy, and an error, if there is any.
func (c *ciliumBGPPeeringPolicies) Update(ctx context.Context, ciliumBGPPeeringPolicy *v2alpha1.CiliumBGPPeeringPolicy, opts v1.UpdateOptions) (result *v2alpha1.CiliumBGPPeeringPolicy, err error) {
	result = &v2alpha1.CiliumBGPPeeringPolicy{}
	err = c.client.Put().
		Resource("ciliumbgppeeringpolicies").
		Name(ciliumBGPPeeringPolicy.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumBGPPeeringPolicy).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ciliumBGPPeeringPolicy and deletes it. Returns an error if one occurs.
func (c *ciliumBGPPeeringPolicies) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("ciliumbgppeeringpolicies").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ciliumBGPPeeringPolicies) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("ciliumbgppeeringpolicies").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ciliumBGPPeeringPolicy.
func (c *ciliumBGPPeeringPolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumBGPPeeringPolicy, err error) {
	result = &v2alpha1.CiliumBGPPeeringPolicy{}
	err = c.client.Patch(pt).
		Resource("ciliumbgppeeringpolicies").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
