--
-- Generated by RecordFlux 0.10.1.dev8+g53cf133e on 2023-07-26
--
-- Copyright (C) 2018-2023 AdaCore GmbH
--
-- This file is distributed under the terms of the GNU Affero General Public License version 3.
--

pragma Style_Checks ("N3aAbCdefhiIklnOprStux");
pragma Warnings (Off, "redundant conversion");
with RFLX.RFLX_Types;

package RFLX.DHCP with
  SPARK_Mode
is

   type Code is (Pad_Option, Subnet_Mask_Option, Router_Option, Domain_Name_Server_Option, Domain_Name_Option, Broadcast_Address_Option, Requested_IP_Address_Option, IP_Address_Lease_Time_Option, Option_Overload_Option, DHCP_Message_Type_Option, Server_Identifier_Option, Parameter_Request_List_Option, Message_Option, Maximum_DHCP_Message_Size_Option, Renewal_Time_Value_Option, Rebinding_Time_Value_Option, Class_Identifier_Option, Client_Identifier_Option, End_Option) with
     Size =>
       8;
   for Code use (Pad_Option => 0, Subnet_Mask_Option => 1, Router_Option => 3, Domain_Name_Server_Option => 6, Domain_Name_Option => 15, Broadcast_Address_Option => 28, Requested_IP_Address_Option => 50, IP_Address_Lease_Time_Option => 51, Option_Overload_Option => 52, DHCP_Message_Type_Option => 53, Server_Identifier_Option => 54, Parameter_Request_List_Option => 55, Message_Option => 56, Maximum_DHCP_Message_Size_Option => 57, Renewal_Time_Value_Option => 58, Rebinding_Time_Value_Option => 59, Class_Identifier_Option => 60, Client_Identifier_Option => 61, End_Option => 255);

   use type RFLX.RFLX_Types.Base_Integer;

   function Valid_Code (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val in 0 | 255 | 1 | 3 | 6 | 15 | 28 | 50 | 51 | 52 | 53 | 54 | 55 | 56 | 57 | 58 | 59 | 60 | 61);

   function To_Base_Integer (Enum : RFLX.DHCP.Code) return RFLX.RFLX_Types.Base_Integer is
     ((case Enum is
          when Pad_Option =>
             0,
          when End_Option =>
             255,
          when Subnet_Mask_Option =>
             1,
          when Router_Option =>
             3,
          when Domain_Name_Server_Option =>
             6,
          when Domain_Name_Option =>
             15,
          when Broadcast_Address_Option =>
             28,
          when Requested_IP_Address_Option =>
             50,
          when IP_Address_Lease_Time_Option =>
             51,
          when Option_Overload_Option =>
             52,
          when DHCP_Message_Type_Option =>
             53,
          when Server_Identifier_Option =>
             54,
          when Parameter_Request_List_Option =>
             55,
          when Message_Option =>
             56,
          when Maximum_DHCP_Message_Size_Option =>
             57,
          when Renewal_Time_Value_Option =>
             58,
          when Rebinding_Time_Value_Option =>
             59,
          when Class_Identifier_Option =>
             60,
          when Client_Identifier_Option =>
             61));

   pragma Warnings (Off, "unreachable branch");

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Code is
     ((case Val is
          when 0 =>
             Pad_Option,
          when 255 =>
             End_Option,
          when 1 =>
             Subnet_Mask_Option,
          when 3 =>
             Router_Option,
          when 6 =>
             Domain_Name_Server_Option,
          when 15 =>
             Domain_Name_Option,
          when 28 =>
             Broadcast_Address_Option,
          when 50 =>
             Requested_IP_Address_Option,
          when 51 =>
             IP_Address_Lease_Time_Option,
          when 52 =>
             Option_Overload_Option,
          when 53 =>
             DHCP_Message_Type_Option,
          when 54 =>
             Server_Identifier_Option,
          when 55 =>
             Parameter_Request_List_Option,
          when 56 =>
             Message_Option,
          when 57 =>
             Maximum_DHCP_Message_Size_Option,
          when 58 =>
             Renewal_Time_Value_Option,
          when 59 =>
             Rebinding_Time_Value_Option,
          when 60 =>
             Class_Identifier_Option,
          when 61 =>
             Client_Identifier_Option,
          when others =>
             RFLX.DHCP.Code'Last))
    with
     Pre =>
       Valid_Code (Val);

   pragma Warnings (On, "unreachable branch");

   type Len is range 1 .. 255 with
     Size =>
       8;

   function Valid_Len (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val >= 1
      and Val <= 255);

   function To_Base_Integer (Val : RFLX.DHCP.Len) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Len is
     (RFLX.DHCP.Len (Val))
    with
     Pre =>
       Valid_Len (Val);

   type Subnet_Mask is range 0 .. 2**32 - 1 with
     Size =>
       32;

   function Valid_Subnet_Mask (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val <= 4294967295);

   function To_Base_Integer (Val : RFLX.DHCP.Subnet_Mask) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Subnet_Mask is
     (RFLX.DHCP.Subnet_Mask (Val))
    with
     Pre =>
       Valid_Subnet_Mask (Val);

   type Enabled_Disabled is (Disabled, Enabled) with
     Size =>
       8;
   for Enabled_Disabled use (Disabled => 0, Enabled => 1);

   function Valid_Enabled_Disabled (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val in 1 | 0);

   function To_Base_Integer (Enum : RFLX.DHCP.Enabled_Disabled) return RFLX.RFLX_Types.Base_Integer is
     ((case Enum is
          when Enabled =>
             1,
          when Disabled =>
             0));

   pragma Warnings (Off, "unreachable branch");

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Enabled_Disabled is
     ((case Val is
          when 1 =>
             Enabled,
          when 0 =>
             Disabled,
          when others =>
             RFLX.DHCP.Enabled_Disabled'Last))
    with
     Pre =>
       Valid_Enabled_Disabled (Val);

   pragma Warnings (On, "unreachable branch");

   type MTU is range 68 .. 2**16 - 1 with
     Size =>
       16;

   function Valid_MTU (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val >= 68
      and Val <= 65535);

   function To_Base_Integer (Val : RFLX.DHCP.MTU) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.MTU is
     (RFLX.DHCP.MTU (Val))
    with
     Pre =>
       Valid_MTU (Val);

   type TTL is range 1 .. 255 with
     Size =>
       8;

   function Valid_TTL (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val >= 1
      and Val <= 255);

   function To_Base_Integer (Val : RFLX.DHCP.TTL) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.TTL is
     (RFLX.DHCP.TTL (Val))
    with
     Pre =>
       Valid_TTL (Val);

   type NetBIOS_Over_TCP_IP_Node_Type is (B_Node, P_Node, M_Node, H_Node) with
     Size =>
       8;
   for NetBIOS_Over_TCP_IP_Node_Type use (B_Node => 1, P_Node => 2, M_Node => 4, H_Node => 8);

   function Valid_NetBIOS_Over_TCP_IP_Node_Type (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val in 1 | 2 | 4 | 8);

   function To_Base_Integer (Enum : RFLX.DHCP.NetBIOS_Over_TCP_IP_Node_Type) return RFLX.RFLX_Types.Base_Integer is
     ((case Enum is
          when B_Node =>
             1,
          when P_Node =>
             2,
          when M_Node =>
             4,
          when H_Node =>
             8));

   pragma Warnings (Off, "unreachable branch");

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.NetBIOS_Over_TCP_IP_Node_Type is
     ((case Val is
          when 1 =>
             B_Node,
          when 2 =>
             P_Node,
          when 4 =>
             M_Node,
          when 8 =>
             H_Node,
          when others =>
             RFLX.DHCP.NetBIOS_Over_TCP_IP_Node_Type'Last))
    with
     Pre =>
       Valid_NetBIOS_Over_TCP_IP_Node_Type (Val);

   pragma Warnings (On, "unreachable branch");

   type Lease_Time is range 0 .. 2**32 - 1 with
     Size =>
       32;

   function Valid_Lease_Time (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val <= 4294967295);

   function To_Base_Integer (Val : RFLX.DHCP.Lease_Time) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Lease_Time is
     (RFLX.DHCP.Lease_Time (Val))
    with
     Pre =>
       Valid_Lease_Time (Val);

   type Option_Overload is (File_Overload, Sname_Overload, File_And_Sname_Overload) with
     Size =>
       8;
   for Option_Overload use (File_Overload => 1, Sname_Overload => 2, File_And_Sname_Overload => 3);

   function Valid_Option_Overload (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val in 1 | 2 | 3);

   function To_Base_Integer (Enum : RFLX.DHCP.Option_Overload) return RFLX.RFLX_Types.Base_Integer is
     ((case Enum is
          when File_Overload =>
             1,
          when Sname_Overload =>
             2,
          when File_And_Sname_Overload =>
             3));

   pragma Warnings (Off, "unreachable branch");

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Option_Overload is
     ((case Val is
          when 1 =>
             File_Overload,
          when 2 =>
             Sname_Overload,
          when 3 =>
             File_And_Sname_Overload,
          when others =>
             RFLX.DHCP.Option_Overload'Last))
    with
     Pre =>
       Valid_Option_Overload (Val);

   pragma Warnings (On, "unreachable branch");

   type DHCP_Message_Type is (DHCPDISCOVER, DHCPOFFER, DHCPREQUEST, DHCPDECLINE, DHCPACK, DHCPNAK, DHCPRELEASE) with
     Size =>
       8;
   for DHCP_Message_Type use (DHCPDISCOVER => 1, DHCPOFFER => 2, DHCPREQUEST => 3, DHCPDECLINE => 4, DHCPACK => 5, DHCPNAK => 6, DHCPRELEASE => 7);

   function Valid_DHCP_Message_Type (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val in 1 | 2 | 3 | 4 | 5 | 6 | 7);

   function To_Base_Integer (Enum : RFLX.DHCP.DHCP_Message_Type) return RFLX.RFLX_Types.Base_Integer is
     ((case Enum is
          when DHCPDISCOVER =>
             1,
          when DHCPOFFER =>
             2,
          when DHCPREQUEST =>
             3,
          when DHCPDECLINE =>
             4,
          when DHCPACK =>
             5,
          when DHCPNAK =>
             6,
          when DHCPRELEASE =>
             7));

   pragma Warnings (Off, "unreachable branch");

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.DHCP_Message_Type is
     ((case Val is
          when 1 =>
             DHCPDISCOVER,
          when 2 =>
             DHCPOFFER,
          when 3 =>
             DHCPREQUEST,
          when 4 =>
             DHCPDECLINE,
          when 5 =>
             DHCPACK,
          when 6 =>
             DHCPNAK,
          when 7 =>
             DHCPRELEASE,
          when others =>
             RFLX.DHCP.DHCP_Message_Type'Last))
    with
     Pre =>
       Valid_DHCP_Message_Type (Val);

   pragma Warnings (On, "unreachable branch");

   type Maximum_DHCP_Message_Size is range 576 .. 2**16 - 1 with
     Size =>
       16;

   function Valid_Maximum_DHCP_Message_Size (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val >= 576
      and Val <= 65535);

   function To_Base_Integer (Val : RFLX.DHCP.Maximum_DHCP_Message_Size) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Maximum_DHCP_Message_Size is
     (RFLX.DHCP.Maximum_DHCP_Message_Size (Val))
    with
     Pre =>
       Valid_Maximum_DHCP_Message_Size (Val);

   type Time_Interval is range 0 .. 2**32 - 1 with
     Size =>
       32;

   function Valid_Time_Interval (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val <= 4294967295);

   function To_Base_Integer (Val : RFLX.DHCP.Time_Interval) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Time_Interval is
     (RFLX.DHCP.Time_Interval (Val))
    with
     Pre =>
       Valid_Time_Interval (Val);

   type Message_Op_Code is (BOOTREQUEST, BOOTREPLY) with
     Size =>
       8;
   for Message_Op_Code use (BOOTREQUEST => 1, BOOTREPLY => 2);

   function Valid_Message_Op_Code (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val in 1 | 2);

   function To_Base_Integer (Enum : RFLX.DHCP.Message_Op_Code) return RFLX.RFLX_Types.Base_Integer is
     ((case Enum is
          when BOOTREQUEST =>
             1,
          when BOOTREPLY =>
             2));

   pragma Warnings (Off, "unreachable branch");

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Message_Op_Code is
     ((case Val is
          when 1 =>
             BOOTREQUEST,
          when 2 =>
             BOOTREPLY,
          when others =>
             RFLX.DHCP.Message_Op_Code'Last))
    with
     Pre =>
       Valid_Message_Op_Code (Val);

   pragma Warnings (On, "unreachable branch");

   type Hardware_Address_Type_Enum is (HT_Reserved, HT_Ethernet_10) with
     Size =>
       8;
   for Hardware_Address_Type_Enum use (HT_Reserved => 0, HT_Ethernet_10 => 1);

   type Hardware_Address_Type (Known : Boolean := False) is
      record
         case Known is
            when True =>
               Enum : Hardware_Address_Type_Enum;
            when False =>
               Raw : RFLX_Types.Base_Integer;
         end case;
      end record;

   function Valid_Hardware_Address_Type (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val < 2**8);

   function Valid_Hardware_Address_Type (Val : Hardware_Address_Type) return Boolean is
     ((if Val.Known then True else Valid_Hardware_Address_Type (Val.Raw) and Val.Raw not in 0 | 1));

   function To_Base_Integer (Enum : RFLX.DHCP.Hardware_Address_Type_Enum) return RFLX.RFLX_Types.Base_Integer is
     ((case Enum is
          when HT_Reserved =>
             0,
          when HT_Ethernet_10 =>
             1));

   function To_Actual (Enum : Hardware_Address_Type_Enum) return RFLX.DHCP.Hardware_Address_Type is
     ((True, Enum));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Hardware_Address_Type is
     ((case Val is
          when 0 =>
             (True, HT_Reserved),
          when 1 =>
             (True, HT_Ethernet_10),
          when others =>
             (False, Val)))
    with
     Pre =>
       Valid_Hardware_Address_Type (Val);

   function To_Base_Integer (Val : RFLX.DHCP.Hardware_Address_Type) return RFLX.RFLX_Types.Base_Integer is
     ((if Val.Known then To_Base_Integer (Val.Enum) else Val.Raw));

   type Hardware_Address_Length is (HL_Ethernet) with
     Size =>
       8;
   for Hardware_Address_Length use (HL_Ethernet => 6);

   function Valid_Hardware_Address_Length (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val in 6);

   function To_Base_Integer (Enum : RFLX.DHCP.Hardware_Address_Length) return RFLX.RFLX_Types.Base_Integer is
     ((case Enum is
          when HL_Ethernet =>
             6));

   pragma Warnings (Off, "unreachable branch");

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Hardware_Address_Length is
     ((case Val is
          when 6 =>
             HL_Ethernet,
          when others =>
             RFLX.DHCP.Hardware_Address_Length'Last))
    with
     Pre =>
       Valid_Hardware_Address_Length (Val);

   pragma Warnings (On, "unreachable branch");

   type Hops is range 0 .. 2**8 - 1 with
     Size =>
       8;

   function Valid_Hops (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val <= 255);

   function To_Base_Integer (Val : RFLX.DHCP.Hops) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Hops is
     (RFLX.DHCP.Hops (Val))
    with
     Pre =>
       Valid_Hops (Val);

   type Transaction_ID is range 0 .. 2**32 - 1 with
     Size =>
       32;

   function Valid_Transaction_ID (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val <= 4294967295);

   function To_Base_Integer (Val : RFLX.DHCP.Transaction_ID) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Transaction_ID is
     (RFLX.DHCP.Transaction_ID (Val))
    with
     Pre =>
       Valid_Transaction_ID (Val);

   type Secs is range 0 .. 2**16 - 1 with
     Size =>
       16;

   function Valid_Secs (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val <= 65535);

   function To_Base_Integer (Val : RFLX.DHCP.Secs) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Secs is
     (RFLX.DHCP.Secs (Val))
    with
     Pre =>
       Valid_Secs (Val);

   type Reserved_Flags is range 0 .. 0 with
     Size =>
       15;

   function Valid_Reserved_Flags (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val = 0);

   function To_Base_Integer (Val : RFLX.DHCP.Reserved_Flags) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Reserved_Flags is
     (RFLX.DHCP.Reserved_Flags (Val))
    with
     Pre =>
       Valid_Reserved_Flags (Val);

   type Magic_Cookie is range 16#63825363# .. 16#63825363# with
     Size =>
       32;

   function Valid_Magic_Cookie (Val : RFLX.RFLX_Types.Base_Integer) return Boolean is
     (Val = 16#63825363#);

   function To_Base_Integer (Val : RFLX.DHCP.Magic_Cookie) return RFLX.RFLX_Types.Base_Integer is
     (RFLX.RFLX_Types.Base_Integer (Val));

   function To_Actual (Val : RFLX.RFLX_Types.Base_Integer) return RFLX.DHCP.Magic_Cookie is
     (RFLX.DHCP.Magic_Cookie (Val))
    with
     Pre =>
       Valid_Magic_Cookie (Val);

end RFLX.DHCP;
