/*
 * wmXName - windowMaker dock-app for XName.org
 *
 * code taken from wmWeather 
 * http://nis-www.lanl.gov/~mgh/WindowMaker/DockApps.shtml
 *
 * Addapted by Yann Hirou <hirou@xname.org>
 * 
 * Licence: GPL
 *
 */



/*  
 *   Includes  
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <X11/X.h>
#include <X11/xpm.h>
#include "xutils.h"
#include "wmXName_master.xpm"
#include "wmXName_mask.xbm"



/* 
 *  Delay between refreshes (in microseconds) 
 */
#define DELAY 10000L
#define WMXNAME_VERSION "0.01"
#define DEFAULT_UPDATEDELAY 900L

void  ButtonPressEvent(XButtonEvent *);
void  KeyPressEvent(XKeyEvent *);

int		UpToDate = 0;
int		ForceUpdate = 1;
int		ForceDownload = 1;
long		UpdateDelay;
int             GotFirstClick1, GotDoubleClick1;
int             GotFirstClick2, GotDoubleClick2;
int             GotFirstClick3, GotDoubleClick3;
char *login, *password, *browser;

/*  
 *   main  
 */
int main(int argc, char *argv[]) {

struct tm	*tTime;
int		n, s, m, dt1, dt2, dt3;
int		UpdateLTHour = 0.0, UpdateLTMin = 0.0;
long		CurrentLocalTime;
double		hour24();
char	LabelColor[30]    	= "#000000";
char	WindGustColor[30] 	= "#000000";
char	DataColor[30]     	= "#000000";
char	BackColor[30]     	= "#ffaaaa";
char	InfoColor[30]     	= "#00ff00";
char	WarnColor[30]     	= "#ffff00";
char	ErrColor[30]     	= "#ff0000";
char	StationTimeColor[30]    = "#000000";
XEvent		event;
double		jd();
char		command[1024], FileName[10];
int 	NbZones, NbInfo, NbWarn, NbError;
FILE 	*fp;
int q, chr, Tens,digit, startPic, startNb;
char temp[255];


/* 
 * Retrieve login & password from config file
 */

   sprintf(FileName, "%s/.wmXName/config", getenv("HOME"));
   if ((fp = fopen(FileName, "r")) != NULL){
		
    	fscanf(fp, "Login: %s\n", temp);
		login = malloc(sizeof(temp));
		strcpy(login,temp);
    	fscanf(fp, "Password: %s\n", temp);
		password = malloc(sizeof(temp));
		strcpy(password,temp);
    	fscanf(fp, "Browser: %s\n", temp);
		browser = malloc(sizeof(temp));
		strcpy(browser,temp);
        fclose(fp);
	}


    /*
     *  Do the window opening in 2 stages. After the initXwindow() call,
     *  we know what the Depth of the Display is. We can then pick an appropriate
     *  XPM to use. I.e. may want to use one that has fewer colors to make the App work
     *  better on a low-color 8-bit display.
     */
    initXwindow(argc, argv);
    openXwindow(argc, argv, wmXName_master, wmXName_mask_bits, wmXName_mask_width, 
		wmXName_mask_height, BackColor, LabelColor, WindGustColor, DataColor,
			StationTimeColor,InfoColor,WarnColor,ErrColor);



	   
    /*
     *  Loop until we die
     */
    n = 32000;
    s = 32000;
    m = 32000;
    dt1 = 32000;
    dt2 = 32000;
    dt3 = 32000;
    UpToDate = 0;
	ForceUpdate = 1;

    while(1) {

			/*
	 *  Keep track of # of seconds
	 */
	if (m > 1000){
	
	    m = 0;
	    ++dt1;
	    ++dt2;
	    ++dt3;
	
	} else {
	
	    /*
	     *  Increment counter
	     */
	    ++m;
	
	}


		
		
	/* 
	 *   Process any pending X events.
	 */
        while(XPending(display)){
            XNextEvent(display, &event);
            switch(event.type){
                case Expose:
                        RedrawWindow();
                        break;
                case ButtonPress:
                        ButtonPressEvent(&event.xbutton);
                        break;
                case KeyPress:
                        KeyPressEvent(&event.xkey);
                        break;
                case ButtonRelease:
                        break;
                case EnterNotify:
                        XSetInputFocus(display, PointerRoot, RevertToParent, CurrentTime);
                        break;
                case LeaveNotify:
                        XSetInputFocus(display, PointerRoot, RevertToParent, CurrentTime);
                        break;

            } 
        }


		
	/*
	 *  Check the Current file every (approx.) several seconds.
	 *  Can significantly reduce this frequency later. But its
	 *  easier to debug this way...
	 *  Do this before trying to download again! The file may be there and it
	 *  may be Up-To-Date!
	 */
	if ((dt2 > 5)||(ForceUpdate)){
	    
	    dt2 = 0;
	    


    	    /*
    	     *  Read in XName data
			 */
	    sprintf(FileName, "%s/.wmXName/data", getenv("HOME"));
   	    if ((fp = fopen(FileName, "r")) != NULL){

    	fscanf(fp, "NbZones: %d\n", &NbZones);
    	fscanf(fp, "NbI: %d\n", &NbInfo);
    	fscanf(fp, "NbW: %d\n", &NbWarn);
    	fscanf(fp, "NbE: %d\n", &NbError);		
        fclose(fp);

	    } else {
			NbZones = 0;
			NbInfo = 0;
			NbWarn = 0;
			NbError = 0;
	    }



	} 

		

		
		
	
	
	/*
	 *  Draw window.
	 */
	if ( (dt3 > 5) || ForceUpdate){


	    dt3 = 0;
	    


	    /*
	     * Clear window.
	     */
	   /* copyXPMArea(5, 69, 54, 54, 5, 5); */
		startPic = 69;
		startNb = 135;
		if(NbInfo != 0){
			startPic = 175;
			startNb = 142;
		}	
		if(NbWarn != 0){
			startPic = 235;
			startNb = 151;
		}
		if(NbError != 0){
			startPic = 295;
			startNb = 160;
		}

	    copyXPMArea(5, startPic + 8, 54, 46, 5, 5+8);

	    /*
	     * Paste up Station ID and time of last update.
	     */

	    q = 0;
	    chr = (int)'X' - 65; copyXPMArea(chr*5+2, 128, 5, 6, 7+q, 6); q+= 5;
	    chr = (int)'N' - 65; copyXPMArea(chr*5+2, 128, 5, 6, 7+q, 6); q+= 5;
	    chr = (int)'A' - 65; copyXPMArea(chr*5+2, 128, 5, 6, 7+q, 6); q+= 5;
	    chr = (int)'M' - 65; copyXPMArea(chr*5+2, 128, 5, 6, 7+q, 6); q+= 5;
	    chr = (int)'E'- 65; copyXPMArea(chr*5+2, 128, 5, 6, 7+q, 6); q+= 5;

	    if (UpdateLTHour != 99){
	    	q = 0; 
	    	Tens = (int)(UpdateLTHour);
	    	copyXPMArea(Tens/10*5+2, 135, 5, 6, 36+q, 6); q+= 5;
	    	copyXPMArea(Tens%10*5+2, 135, 5, 6, 36+q, 6); q+= 5;
	    	copyXPMArea(53, 135, 1, 6, 36+q, 6); q+= 2;
	    	Tens = (int)(UpdateLTMin);
	    	copyXPMArea(Tens/10*5+2, 135, 5, 6, 36+q, 6); q+= 5;
	    	copyXPMArea(Tens%10*5+2, 135, 5, 6, 36+q, 6); q+= 5;
	    }


		/*
	     * Paste up zones number.
		 */
	        q = 0;
	        if (NbZones >= 100){
			    digit = (int)(NbZones/100);
	            copyXPMArea(digit*6+2, startNb, 6, 8, 40+q, 15); q+= 6;
	            Tens = (int)(NbZones-digit*100);
	            copyXPMArea(Tens/10*6+2, startNb, 6, 8, 40+q, 15); q+= 6;
	            copyXPMArea(Tens%10*6+2, startNb, 6, 8, 40+q, 15); q+= 6;
	        } else {
	            Tens = (int)(NbZones);
	            if (Tens >= 10) { 
					copyXPMArea(Tens/10*6+2, startNb, 6, 8, 40+q, 15); 
					q+= 6; 
				}
	            copyXPMArea(Tens%10*6+2, startNb, 6, 8, 40+q, 15); 
				q+= 6;
	        }




		/*
	     *   Paste up Nb Info
		 */
			
	        q = 0;
			if(NbInfo != 0){
		        if (NbInfo >= 100){
			    digit = (int)(NbInfo/100);
	    	        copyXPMArea(digit*6+2, startNb, 6, 8, 40+q, 25); q+= 6;
	        	    Tens = (int)(NbInfo-digit*100);
	            	copyXPMArea(Tens/10*6+2, startNb, 6, 8, 40+q, 25); q+= 6;
		            copyXPMArea(Tens%10*6+2, startNb, 6, 8, 40+q, 25); q+= 6;
		        } else {
	    	        Tens = (int)(NbInfo);
	
			            if (Tens >= 10) { 
						copyXPMArea(Tens/10*6+2, startNb, 6, 8, 40+q, 25); 
						q+= 6; 
					}
		            copyXPMArea(Tens%10*6+2, startNb, 6, 8, 40+q, 25); 
					q+= 6;
	        	}
			}






		/*
	     * Paste up NbWarn.
		 */

	        q = 0;
			if(NbWarn != 0){
		        if (NbWarn >= 100){
			    digit = (int)(NbWarn/100);
		            copyXPMArea(digit*6+2, startNb, 6, 8, 40+q, 35); q+= 6;
	    	        Tens = (int)(NbWarn-digit*100);
	        	    copyXPMArea(Tens/10*6+2, startNb, 6, 8, 40+q, 35); q+= 6;
	            	copyXPMArea(Tens%10*6+2, startNb, 6, 8, 40+q, 35); q+= 6;
		        } else {
		            Tens = (int)(NbWarn);
	
			            if (Tens >= 10) { 
						copyXPMArea(Tens/10*6+2, startNb, 6, 8, 40+q, 35); 
						q+= 6; 
					}
		            copyXPMArea(Tens%10*6+2, startNb, 6, 8, 40+q, 35); 
					q+= 6;
	    	    }
			}


		/*
	     * Paste up NbError.
		 */

	        q = 0;
			if(NbError != 0){
		        if (NbError >= 100){
			    digit = (int)(NbError/100);
	    	        copyXPMArea(digit*6+2, startNb, 6, 8, 40+q, 43); q+= 6;
	        	    Tens = (int)(NbError-digit*100);
	            	copyXPMArea(Tens/10*6+2, startNb, 6, 8, 40+q, 43); q+= 6;
		            copyXPMArea(Tens%10*6+2, startNb, 6, 8, 40+q, 43); q+= 6;
		        } else {
	    	        Tens = (int)(NbError);
	
			            if (Tens >= 10) { 
						copyXPMArea(Tens/10*6+2, startNb, 6, 8, 40+q, 43); 
						q+= 6; 
					}
		            copyXPMArea(Tens%10*6+2, startNb, 6, 8, 40+q, 43); 
					q+= 6;
	    	    }
			}						

	    /*
	     * Make changes visible
	     */
	    RedrawWindow();



	}
	
		/*
	 *  Reset "force update" flag
	 */
	ForceUpdate = 0;




	/*
	 *  Check every 5 min if the values are not up to date...
	 */

	UpToDate = 0;
	if (((!UpToDate)&&(dt1 > UpdateDelay)) || ForceDownload){

	    dt1 = 0;

	    /*
	     *  Execute Perl script to grab the Latest METAR Report
	     */
	    sprintf(command, "GrabXName &");
	    system(command);

	    ForceDownload = 0;
	    ForceUpdate = 1;
		
		CurrentLocalTime = time(CurrentTime);
	    tTime = localtime(&CurrentLocalTime);
	    UpdateLTHour = tTime->tm_hour;
	    UpdateLTMin  = tTime->tm_min;
		
	}





	/* 
	 *  Wait for next update 
	 */
	usleep(DELAY);



	
			
		
		
	} /* end while(1) */
} /* end main */




/*
 *  This routine handles button presses. 
 */
void ButtonPressEvent(XButtonEvent *xev){
    char 	Command[80];

    /*
     *  Process single clicks.
     */

    if ((xev->button == Button1) && (xev->type == ButtonPress)){

	if (GotFirstClick1) GotDoubleClick1 = 1;
	else GotFirstClick1 = 1;

    } else if ((xev->button == Button2) && (xev->type == ButtonPress)){ 

	if (GotFirstClick2) GotDoubleClick2 = 1;
	else GotFirstClick2 = 1;

    } else if ((xev->button == Button3) && (xev->type == ButtonPress)){

	if (GotFirstClick3) GotDoubleClick3 = 1;
	else GotFirstClick3 = 1;

    }




    /*
     *  We got a double click on Mouse Button1 (i.e. the left one)
     */
    if (GotDoubleClick1) {
	GotFirstClick1 = 0;
	GotDoubleClick1 = 0;
	sprintf(Command, "%s \"https://www.xname.org/index.php?login=%s&password=%s\" &",
			browser, login,password);
	system(Command);
    }


    /*
     *  We got a double click on Mouse Button2 (i.e. the left one)
     */
    if (GotDoubleClick2) {
	GotFirstClick2 = 0;
	GotDoubleClick2 = 0;
    }


    /*
     *  We got a double click on Mouse Button3 (i.e. the left one)
     */
    if (GotDoubleClick3) {
	GotFirstClick3 = 0;
	GotDoubleClick3 = 0;
	ForceDownload = 1;
	ForceUpdate = 1;
    }

   return;


}




/*
 *  This routine handles key presses.
 *
 */
void KeyPressEvent(XKeyEvent *xev){

   return;

}

/*
 *  Compute the Julian Day number for the given date.
 *  Julian Date is the number of days since noon of Jan 1 4713 B.C.
 */
double jd(ny, nm, nd, UT)
int ny, nm, nd;
double UT;
{
        double A, B, C, D, JD, day;

        day = nd + UT/24.0;


        if ((nm == 1) || (nm == 2)){
                ny = ny - 1;
                nm = nm + 12;
        }

        if (((double)ny+nm/12.0+day/365.25)>=(1582.0+10.0/12.0+15.0/365.25)){
                        A = ((int)(ny / 100.0));
                        B = 2.0 - A + (int)(A/4.0);
        }
        else{
                        B = 0.0;
        }
        if (ny < 0.0){
                C = (int)((365.25*(double)ny) - 0.75);
        }
        else{
                C = (int)(365.25*(double)ny);
        }

        D = (int)(30.6001*(double)(nm+1));


        JD = B + C + D + day + 1720994.5;
        return(JD);

}
