/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.rest;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.rest.SpecificationId;
import com.intellij.swagger.core.ui.rest.SwUrlBuilderKt;
import com.intellij.swagger.core.ui.rest.SwWebServerRequestType;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.NettyKt;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u0001?B\u001b\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\rJ\u0006\u0010\u001f\u001a\u00020\u001cJ\u0006\u0010 \u001a\u00020\u001cJ\u0010\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\rJ\b\u0010\"\u001a\u0004\u0018\u00010#J\u000f\u0010$\u001a\u0004\u0018\u00010%\u00a2\u0006\u0004\b&\u0010'J\b\u0010(\u001a\u0004\u0018\u00010\rJ\b\u0010)\u001a\u0004\u0018\u00010*J\u001f\u0010+\u001a\u00020\u001c2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0-\"\u00020\r\u00a2\u0006\u0002\u0010.J!\u0010/\u001a\u0002002\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0-\"\u00020\rH\u0002\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\u0004\u0018\u00010\r*\u000200H\u0002J\u001c\u00103\u001a\u000200*\u0002002\u0006\u00104\u001a\u00020\r2\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u0002002\u0006\u00108\u001a\u00020\r2\u0006\u00105\u001a\u000206H\u0002J\b\u00109\u001a\u000200H\u0002J\u0010\u0010:\u001a\u0002002\u0006\u0010;\u001a\u000206H\u0002J\u0010\u0010<\u001a\u0002002\u0006\u0010;\u001a\u000206H\u0002J\u0012\u0010=\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\rH\u0002J\u0018\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f*\u00020\rH\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006@"}, d2={"Lcom/intellij/swagger/core/ui/rest/SwUrlParser;", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "<init>", "(Lio/netty/handler/codec/http/FullHttpRequest;Lio/netty/handler/codec/http/QueryStringDecoder;)V", "browserRequest", "Lorg/cef/network/CefRequest;", "(Lorg/cef/network/CefRequest;)V", "pathSegments", "", "", "queryParameters", "", "authority", "headers", "presentableUrl", "getPresentableUrl$intellij_swagger_core", "()Ljava/lang/String;", "bundledWebServerUrl", "Lcom/intellij/util/Url;", "getBundledWebServerUrl", "()Lcom/intellij/util/Url;", "bundledWebServerUrl$delegate", "Lkotlin/Lazy;", "hasQueryParameters", "", "recognizeQueryParameter", "name", "isRequestFromPreviewEditor", "isRequestToBundledWebServer", "getHeader", "recognizePreviewType", "Lcom/intellij/swagger/core/ui/SwPreviewType;", "recognizeSpecificationId", "Lcom/intellij/swagger/core/ui/rest/SpecificationId;", "recognizeSpecificationId-2Wqz4Ao", "()Ljava/util/UUID;", "recognizeResourcePath", "recognizeRequestType", "Lcom/intellij/swagger/core/ui/rest/SwWebServerRequestType;", "pathStartsWith", "segments", "", "([Ljava/lang/String;)Z", "doMatchPathSegments", "Lcom/intellij/swagger/core/ui/rest/SwUrlParser$UrlMatchResult;", "([Ljava/lang/String;)Lcom/intellij/swagger/core/ui/rest/SwUrlParser$UrlMatchResult;", "unmatchedTail", "withNextSegment", "segment", "segmentIndexToCompare", "", "compareSegments", "expectedSegment", "initialiseUrlMatching", "failedMatch", "comparedIndex", "successfulMatch", "parsePath", "parseParameters", "UrlMatchResult", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwUrlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwUrlParser.kt\ncom/intellij/swagger/core/ui/rest/SwUrlParser\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,168:1\n462#2:169\n412#2:170\n1246#3,4:171\n1187#3,2:175\n1261#3,4:177\n1187#3,2:188\n1261#3,4:190\n1#4:181\n1310#5,2:182\n12813#5,3:185\n25#6:184\n*S KotlinDebug\n*F\n+ 1 SwUrlParser.kt\ncom/intellij/swagger/core/ui/rest/SwUrlParser\n*L\n17#1:169\n17#1:170\n17#1:171,4\n20#1:175,2\n20#1:177,4\n152#1:188,2\n152#1:190,4\n67#1:182,2\n107#1:185,3\n76#1:184\n*E\n"})
public final class SwUrlParser {
    @NotNull
    private final List<String> pathSegments;
    @NotNull
    private final Map<String, String> queryParameters;
    @NotNull
    private final String authority;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final String presentableUrl;
    @NotNull
    private final Lazy bundledWebServerUrl$delegate;

    /*
     * WARNING - void declaration
     */
    public SwUrlParser(@NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Map.Entry entry;
        void $this$mapValuesTo$iv$iv;
        Iterable $this$mapValues$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        this.bundledWebServerUrl$delegate = LazyKt.lazy(SwUrlParser::bundledWebServerUrl_delegate$lambda$3);
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        this.pathSegments = this.parsePath(string);
        Map map2 = urlDecoder.parameters();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"parameters(...)");
        Map map3 = map2;
        SwUrlParser swUrlParser = this;
        boolean $i$f$mapValues = false;
        void var5_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry2;
            void it$iv$iv;
            entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map5 = map4;
            boolean bl2 = false;
            Object v = entry2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            String string2 = (String)CollectionsKt.lastOrNull((List)((List)v));
            map5.put(k, string2);
        }
        swUrlParser.queryParameters = destination$iv$iv;
        this.presentableUrl = request.uri();
        String string3 = NettyKt.getHost((HttpRequest)((HttpRequest)request));
        if (string3 == null) {
            string3 = "";
        }
        this.authority = string3;
        HttpHeaders httpHeaders = request.headers();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"headers(...)");
        $this$mapValues$iv = (Iterable)httpHeaders;
        swUrlParser = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map6 = destination$iv$iv2;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            entry = TuplesKt.to(it.getKey(), it.getValue());
            map6.put(entry.getFirst(), entry.getSecond());
        }
        swUrlParser.headers = destination$iv$iv2;
    }

    public /* synthetic */ SwUrlParser(FullHttpRequest fullHttpRequest, QueryStringDecoder queryStringDecoder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            queryStringDecoder = new QueryStringDecoder(fullHttpRequest.uri());
        }
        this(fullHttpRequest, queryStringDecoder);
    }

    /*
     * WARNING - void declaration
     */
    public SwUrlParser(@NotNull CefRequest browserRequest) {
        void p0;
        Map map2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)browserRequest, (String)"browserRequest");
        this.bundledWebServerUrl$delegate = LazyKt.lazy(SwUrlParser::bundledWebServerUrl_delegate$lambda$3);
        String string = browserRequest.getURL();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getURL(...)");
        Url parsedUrl = Urls.parseEncoded((String)string);
        boolean bl2 = bl = parsedUrl != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-SwUrlParser$42 = false;
            String $i$a$-assert-SwUrlParser$42 = "invalid url passed to a cef request handler - code should not be reached";
            throw new AssertionError((Object)$i$a$-assert-SwUrlParser$42);
        }
        Intrinsics.checkNotNull((Object)parsedUrl);
        String string2 = parsedUrl.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        this.pathSegments = this.parsePath(string2);
        String string3 = parsedUrl.getParameters();
        Map map3 = string3 != null ? this.parseParameters(string3) : null;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        this.queryParameters = map3;
        this.presentableUrl = parsedUrl.getPath();
        String string4 = parsedUrl.getAuthority();
        if (string4 == null) {
            string4 = "";
        }
        this.authority = string4;
        Map $i$a$-assert-SwUrlParser$42 = map2 = (Map)new LinkedHashMap();
        SwUrlParser swUrlParser = this;
        boolean bl3 = false;
        browserRequest.getHeaderMap((Map)p0);
        swUrlParser.headers = map2;
    }

    @NotNull
    public final String getPresentableUrl$intellij_swagger_core() {
        return this.presentableUrl;
    }

    private final Url getBundledWebServerUrl() {
        Lazy lazy = this.bundledWebServerUrl$delegate;
        return (Url)lazy.getValue();
    }

    public final boolean hasQueryParameters() {
        return !this.queryParameters.isEmpty();
    }

    @Nullable
    public final String recognizeQueryParameter(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.queryParameters.get(name2);
    }

    public final boolean isRequestFromPreviewEditor() {
        String[] stringArray = new String[]{"__ij-openapi-plugin"};
        return this.pathStartsWith(stringArray);
    }

    public final boolean isRequestToBundledWebServer() {
        Url url2 = this.getBundledWebServerUrl();
        return Intrinsics.areEqual((Object)this.authority, (Object)(url2 != null ? url2.getAuthority() : null));
    }

    @Nullable
    public final String getHeader(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.headers.get(name2);
    }

    @Nullable
    public final SwPreviewType recognizePreviewType() {
        SwPreviewType swPreviewType;
        block2: {
            String string = this.queryParameters.get("previewType");
            if (string == null) {
                return null;
            }
            String specificationKey = string;
            SwPreviewType[] $this$firstOrNull$iv = SwPreviewType.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                SwPreviewType element$iv;
                SwPreviewType it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUniqueId(), (Object)specificationKey)) continue;
                swPreviewType = element$iv;
                break block2;
            }
            swPreviewType = null;
        }
        return swPreviewType;
    }

    @Nullable
    public final UUID recognizeSpecificationId-2Wqz4Ao() {
        Object object;
        String string = this.queryParameters.get("specificationKey");
        if (string == null) {
            return null;
        }
        String serializedSpecificationId = string;
        Object object2 = this;
        try {
            SwUrlParser $this$recognizeSpecificationId_2Wqz4Ao_u24lambda_u245 = object2;
            boolean bl = false;
            UUID uUID = UUID.fromString(serializedSpecificationId);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            object = Result.constructor-impl((Object)SpecificationId.box-impl(SpecificationId.constructor-impl(uUID)));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            SwUrlParser $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwUrlParser.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Could not get UUID from string: " + serializedSpecificationId);
        }
        SpecificationId specificationId = (SpecificationId)(Result.isFailure-impl((Object)object2) ? null : object2);
        return specificationId != null ? specificationId.unbox-impl() : null;
    }

    @Nullable
    public final String recognizeResourcePath() {
        String string = this.queryParameters.get("resourcePath");
        if (string == null) {
            String[] stringArray = new String[]{"__ij-openapi-plugin"};
            string = this.unmatchedTail(this.doMatchPathSegments(stringArray));
        }
        return string;
    }

    @Nullable
    public final SwWebServerRequestType recognizeRequestType() {
        SwWebServerRequestType swWebServerRequestType;
        if (this.pathSegments.isEmpty()) {
            swWebServerRequestType = null;
        } else {
            String[] stringArray = new String[]{"__ij-openapi-plugin", "specification"};
            if (this.pathStartsWith(stringArray)) {
                swWebServerRequestType = SwWebServerRequestType.SPECIFICATION_FILE;
            } else {
                stringArray = new String[]{"__ij-openapi-plugin", "customResource"};
                if (this.pathStartsWith(stringArray)) {
                    swWebServerRequestType = SwWebServerRequestType.CUSTOM_BUNDLED_RESOURCE;
                } else {
                    stringArray = new String[]{"__ij-openapi-plugin", "html"};
                    if (this.pathStartsWith(stringArray)) {
                        swWebServerRequestType = SwWebServerRequestType.HTML_FILE;
                    } else {
                        stringArray = new String[]{"__ij-openapi-plugin", "libraryResource"};
                        if (this.pathStartsWith(stringArray)) {
                            swWebServerRequestType = SwWebServerRequestType.LIBRARY_RESOURCE;
                        } else {
                            stringArray = new String[]{"__ij-openapi-plugin", "errorTemplate"};
                            if (this.pathStartsWith(stringArray)) {
                                swWebServerRequestType = SwWebServerRequestType.ERROR_PAGE_TEMPLATE;
                            } else {
                                stringArray = new String[]{"__ij-openapi-plugin", "errorHandler"};
                                if (this.pathStartsWith(stringArray)) {
                                    swWebServerRequestType = SwWebServerRequestType.ERROR_SCRIPT;
                                } else {
                                    stringArray = new String[]{"__ij-openapi-plugin"};
                                    swWebServerRequestType = this.pathStartsWith(stringArray) ? SwWebServerRequestType.LIBRARY_RESOURCE : null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return swWebServerRequestType;
    }

    public final boolean pathStartsWith(String ... segments) {
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        return this.doMatchPathSegments(Arrays.copyOf(segments, segments.length)).isMatch();
    }

    /*
     * WARNING - void declaration
     */
    private final UrlMatchResult doMatchPathSegments(String ... segments) {
        void $this$fold$iv;
        String[] stringArray = segments;
        UrlMatchResult initial$iv = this.initialiseUrlMatching();
        boolean $i$f$fold = false;
        UrlMatchResult accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void nextSegment;
            void element$iv;
            void var9_9 = element$iv = $this$fold$iv[i];
            UrlMatchResult previousSegmentMatchResult = accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.withNextSegment(previousSegmentMatchResult, (String)nextSegment, previousSegmentMatchResult.getLastProcessedSegmentIndex() + 1);
        }
        return accumulator$iv;
    }

    private final String unmatchedTail(UrlMatchResult $this$unmatchedTail) {
        if (!$this$unmatchedTail.isMatch()) {
            return null;
        }
        int firstUnprocessedSegmentIndex = $this$unmatchedTail.getLastProcessedSegmentIndex() + 1;
        if (firstUnprocessedSegmentIndex >= this.pathSegments.size()) {
            return null;
        }
        return CollectionsKt.joinToString$default((Iterable)this.pathSegments.subList(firstUnprocessedSegmentIndex, this.pathSegments.size()), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    private final UrlMatchResult withNextSegment(UrlMatchResult $this$withNextSegment, String segment, int segmentIndexToCompare) {
        return $this$withNextSegment.isMatch() ? this.compareSegments(segment, segmentIndexToCompare) : $this$withNextSegment;
    }

    private final UrlMatchResult compareSegments(String expectedSegment, int segmentIndexToCompare) {
        return this.pathSegments.size() <= segmentIndexToCompare ? this.failedMatch(segmentIndexToCompare) : (Intrinsics.areEqual((Object)this.pathSegments.get(segmentIndexToCompare), (Object)expectedSegment) ? this.successfulMatch(segmentIndexToCompare) : this.failedMatch(segmentIndexToCompare));
    }

    private final UrlMatchResult initialiseUrlMatching() {
        return new UrlMatchResult(-1, true);
    }

    private final UrlMatchResult failedMatch(int comparedIndex) {
        return new UrlMatchResult(comparedIndex, false);
    }

    private final UrlMatchResult successfulMatch(int comparedIndex) {
        return new UrlMatchResult(comparedIndex, true);
    }

    private final List<String> parsePath(String $this$parsePath) {
        char[] cArray = new char[]{'/'};
        CharSequence charSequence = StringsKt.trim((String)StringsKt.substringBefore$default((String)$this$parsePath, (char)'?', null, (int)2, null), (char[])cArray);
        cArray = new char[]{'/'};
        return StringsKt.split$default((CharSequence)charSequence, (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseParameters(String $this$parseParameters) {
        void $this$associateTo$iv$iv;
        char[] cArray = new char[]{'&'};
        Iterable $this$associate$iv = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)$this$parseParameters, (CharSequence)"?"), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)StringsKt.substringBefore$default((String)it, (char)'=', null, (int)2, null), (Object)StringsKt.substringAfter$default((String)it, (char)'=', null, (int)2, null));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final Url bundledWebServerUrl_delegate$lambda$3() {
        return Urls.parseEncoded((String)SwUrlBuilderKt.builtInSeverUrl());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/swagger/core/ui/rest/SwUrlParser$UrlMatchResult;", "", "lastProcessedSegmentIndex", "", "isMatch", "", "<init>", "(IZ)V", "getLastProcessedSegmentIndex", "()I", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "intellij.swagger.core"})
    private static final class UrlMatchResult {
        private final int lastProcessedSegmentIndex;
        private final boolean isMatch;

        public UrlMatchResult(int lastProcessedSegmentIndex, boolean isMatch) {
            this.lastProcessedSegmentIndex = lastProcessedSegmentIndex;
            this.isMatch = isMatch;
        }

        public final int getLastProcessedSegmentIndex() {
            return this.lastProcessedSegmentIndex;
        }

        public final boolean isMatch() {
            return this.isMatch;
        }

        public final int component1() {
            return this.lastProcessedSegmentIndex;
        }

        public final boolean component2() {
            return this.isMatch;
        }

        @NotNull
        public final UrlMatchResult copy(int lastProcessedSegmentIndex, boolean isMatch) {
            return new UrlMatchResult(lastProcessedSegmentIndex, isMatch);
        }

        public static /* synthetic */ UrlMatchResult copy$default(UrlMatchResult urlMatchResult, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = urlMatchResult.lastProcessedSegmentIndex;
            }
            if ((n2 & 2) != 0) {
                bl = urlMatchResult.isMatch;
            }
            return urlMatchResult.copy(n, bl);
        }

        @NotNull
        public String toString() {
            return "UrlMatchResult(lastProcessedSegmentIndex=" + this.lastProcessedSegmentIndex + ", isMatch=" + this.isMatch + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.lastProcessedSegmentIndex);
            result2 = result2 * 31 + Boolean.hashCode(this.isMatch);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UrlMatchResult)) {
                return false;
            }
            UrlMatchResult urlMatchResult = (UrlMatchResult)other;
            if (this.lastProcessedSegmentIndex != urlMatchResult.lastProcessedSegmentIndex) {
                return false;
            }
            return this.isMatch == urlMatchResult.isMatch;
        }
    }
}

