/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.find.SearchReplaceComponent;
import com.intellij.jupyter.core.editor.settings.JupyterDSSettings;
import com.intellij.jupyter.core.jupyter.helper.JupyterMarkdownHelperKt;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/core/editor/JupyterMarkdownCaretListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "isMarkdownCellFolded", "", "cell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "intellij.jupyter.core"})
public final class JupyterMarkdownCaretListener
implements CaretListener {
    @NotNull
    private final EditorImpl editor;

    public JupyterMarkdownCaretListener(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        block7: {
            EditorCell oldCell;
            NotebookCellLines.Interval oldInterval;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!JupyterDSSettings.Companion.getInstance().getAutoRunMarkdownCellOnFocusLeave()) {
                return;
            }
            String string = ActionManagerEx.Companion.getInstanceEx().getLastPreformedActionId();
            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"Introduce", (boolean)false, (int)2, null) : false;
            if (bl) {
                return;
            }
            NotebookCellLines.Interval newInterval = NotebookVisualizationUiUtilKt.getCell((Editor)((Editor)this.editor), (int)event.getNewPosition().line);
            boolean hasSearchReplaceComponent = this.editor.getHeaderComponent() instanceof SearchReplaceComponent;
            if (hasSearchReplaceComponent) {
                EditorCell newCell;
                NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)this.editor);
                EditorCell editorCell = newCell = notebookCellInlayManager != null ? notebookCellInlayManager.getCell(newInterval) : null;
                if (editorCell != null) {
                    JupyterMarkdownHelperKt.setMarkdownRendered(editorCell, false);
                }
            }
            if ((oldInterval = NotebookVisualizationUiUtilKt.getCell((Editor)((Editor)this.editor), (int)event.getOldPosition().line)).getType() != NotebookCellLines.CellType.MARKDOWN) {
                return;
            }
            if (Intrinsics.areEqual((Object)oldInterval, (Object)newInterval)) {
                return;
            }
            if (this.isMarkdownCellFolded(oldInterval)) {
                return;
            }
            NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)this.editor);
            EditorCell editorCell = oldCell = notebookCellInlayManager != null ? notebookCellInlayManager.getCell(oldInterval.getOrdinal()) : null;
            if (editorCell == null) break block7;
            JupyterMarkdownHelperKt.setMarkdownRendered(editorCell, true);
        }
    }

    private final boolean isMarkdownCellFolded(NotebookCellLines.Interval cell) {
        int startOffset = this.editor.getDocument().getLineStartOffset(cell.getLines().getFirst() + 1);
        int endOffset = this.editor.getDocument().getLineEndOffset(cell.getLines().getLast());
        return this.editor.getFoldingModel().getFoldRegion(startOffset, endOffset) != null;
    }
}

