/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.markdown;

import com.intellij.jupyter.core.editor.markdown.Heading;
import com.intellij.jupyter.core.editor.markdown.MarkdownEditorCellKt;
import com.intellij.jupyter.core.editor.markdown.MarkdownExtension;
import com.intellij.jupyter.core.editor.markdown.NotebookStructureElement;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.notebooks.ui.observables.DistinctObservablePropertyKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellExtension;
import com.intellij.notebooks.visualization.ui.EditorNotebook;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.MutableBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020\u0017H\u0016J\b\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/intellij/jupyter/core/editor/markdown/MarkdownEditorCell;", "Lcom/intellij/notebooks/visualization/ui/EditorCellExtension;", "Lcom/intellij/openapi/Disposable;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "parser", "Lorg/intellij/markdown/parser/MarkdownParser;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;Lorg/intellij/markdown/parser/MarkdownParser;)V", "heading", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "Lcom/intellij/jupyter/core/editor/markdown/Heading;", "getHeading", "()Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "sectionFolded", "Lcom/intellij/openapi/observable/properties/MutableBooleanProperty;", "getSectionFolded", "()Lcom/intellij/openapi/observable/properties/MutableBooleanProperty;", "rendered", "getRendered", "getSection", "Lcom/intellij/jupyter/core/editor/markdown/NotebookStructureElement$NotebookSection;", "onBeforeRemove", "", "source", "", "isHeading", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "getLevel", "", "dispose", "backgroundHeadingUpdate", "Lkotlinx/coroutines/Job;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownEditorCell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownEditorCell.kt\ncom/intellij/jupyter/core/editor/markdown/MarkdownEditorCell\n+ 2 EditorNotebook.kt\ncom/intellij/notebooks/visualization/ui/EditorNotebookKt\n*L\n1#1,79:1\n130#2:80\n*S KotlinDebug\n*F\n+ 1 MarkdownEditorCell.kt\ncom/intellij/jupyter/core/editor/markdown/MarkdownEditorCell\n*L\n50#1:80\n*E\n"})
public final class MarkdownEditorCell
implements EditorCellExtension,
Disposable {
    @NotNull
    private final EditorCell cell;
    @NotNull
    private final MarkdownParser parser;
    @NotNull
    private final ObservableMutableProperty<Heading> heading;
    @NotNull
    private final MutableBooleanProperty sectionFolded;
    @NotNull
    private final MutableBooleanProperty rendered;

    public MarkdownEditorCell(@NotNull EditorCell cell, @NotNull MarkdownParser parser) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.cell = cell;
        this.parser = parser;
        this.heading = DistinctObservablePropertyKt.distinct((ObservableMutableProperty)((ObservableMutableProperty)new AtomicProperty(null)));
        this.sectionFolded = (MutableBooleanProperty)new AtomicBooleanProperty(false);
        this.rendered = (MutableBooleanProperty)new AtomicBooleanProperty(true);
        this.cell.getSource().afterChange(arg_0 -> MarkdownEditorCell._init_$lambda$0(this, arg_0));
        this.backgroundHeadingUpdate();
        Disposer.register((Disposable)((Disposable)this.cell), (Disposable)this);
    }

    @NotNull
    public final ObservableMutableProperty<Heading> getHeading() {
        return this.heading;
    }

    @NotNull
    public final MutableBooleanProperty getSectionFolded() {
        return this.sectionFolded;
    }

    @NotNull
    public final MutableBooleanProperty getRendered() {
        return this.rendered;
    }

    @Nullable
    public final NotebookStructureElement.NotebookSection getSection() {
        EditorNotebook $this$getExtension$iv = this.cell.getNotebook();
        boolean $i$f$getExtension = false;
        Object object = (ObservableMutableProperty<NotebookStructureElement.Notebook>)$this$getExtension$iv.getExtension(Reflection.getOrCreateKotlinClass(MarkdownExtension.class));
        NotebookStructureElement notebookStructureElement = object != null && (object = ((MarkdownExtension)object).getStructure()) != null && (object = (NotebookStructureElement.Notebook)object.get()) != null ? ((NotebookStructureElement.WithChildren)object).getElement(this.cell) : null;
        return notebookStructureElement instanceof NotebookStructureElement.NotebookSection ? (NotebookStructureElement.NotebookSection)notebookStructureElement : null;
    }

    public void onBeforeRemove() {
        block0: {
            NotebookStructureElement.NotebookSection notebookSection = this.getSection();
            if (notebookSection == null) break block0;
            notebookSection.unfold();
        }
    }

    private final Heading getHeading(String source) {
        if (this.cell.getType() != NotebookCellLines.CellType.MARKDOWN) {
            return null;
        }
        ASTNode parsedTree = MarkdownParser.parse$default((MarkdownParser)this.parser, (IElementType)new IElementType("ROOT"), (String)source, (boolean)false, (int)4, null);
        ASTNode firstNode = (ASTNode)CollectionsKt.firstOrNull((List)parsedTree.getChildren());
        return firstNode != null && this.isHeading(firstNode) ? new Heading(this.getLevel(firstNode), ((Object)ASTUtilKt.getTextInNode((ASTNode)firstNode, (CharSequence)source)).toString()) : null;
    }

    private final boolean isHeading(ASTNode node) {
        return MarkdownEditorCellKt.access$getHEADING_TYPES$p().containsKey(node.getType());
    }

    private final int getLevel(ASTNode node) {
        Integer n = (Integer)MarkdownEditorCellKt.access$getHEADING_TYPES$p().get(node.getType());
        if (n == null) {
            throw new IllegalStateException("Node is not a heading".toString());
        }
        return n;
    }

    public void dispose() {
    }

    private final Job backgroundHeadingUpdate() {
        return JupyterCoroutineKt.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MarkdownEditorCell this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.getHeading().set((Object)MarkdownEditorCell.access$getHeading(this.this$0, (String)MarkdownEditorCell.access$getCell$p(this.this$0).getSource().get()));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final Unit _init_$lambda$0(MarkdownEditorCell this$0, String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this$0.backgroundHeadingUpdate();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Heading access$getHeading(MarkdownEditorCell $this, String source) {
        return $this.getHeading(source);
    }

    public static final /* synthetic */ EditorCell access$getCell$p(MarkdownEditorCell $this) {
        return $this.cell;
    }
}

