/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.Processor;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.view.FilteredByPercent;
import com.jetbrains.nodejs.run.profile.cpu.view.LineColorProvider;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ColumnForNumbers;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfileLineTreeCellRenderer;
import com.jetbrains.nodejs.run.profile.cpu.view.V8TreeTableModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopCalledV8TreeTableModel
implements FilteredByPercent,
TreeTableModelWithCustomRenderer {
    private final Object myRoot;
    private final List<String> myGroups;
    private final Map<String, List<V8ProfileLine>> myCalls;
    private final ColumnInfo[] myColumns;
    private List<String> myFilteredGroups;
    private Map<String, List<V8ProfileLine>> myFilteredCalls;
    private int myTensPercentLevelInclusive;
    private V8ProfileLineTreeCellRenderer<V8ProfileLine> myZeroRenderer;

    public TopCalledV8TreeTableModel(@NotNull List<Pair<String, List<V8ProfileLine>>> data, @NotNull LineColorProvider fileColor) {
        if (data == null) {
            TopCalledV8TreeTableModel.$$$reportNull$$$0(0);
        }
        if (fileColor == null) {
            TopCalledV8TreeTableModel.$$$reportNull$$$0(1);
        }
        this.myRoot = new Object();
        this.myTensPercentLevelInclusive = 0;
        this.myCalls = new HashMap<String, List<V8ProfileLine>>(data.size(), 1.0f);
        this.myGroups = new ArrayList<String>(data.size());
        for (Pair<String, List<V8ProfileLine>> pair : data) {
            this.myCalls.put((String)pair.getFirst(), (List)pair.getSecond());
            this.myGroups.add((String)pair.getFirst());
        }
        List<ColumnInfo> list = this.createColumns(fileColor);
        this.myColumns = list.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    public V8ProfileLineTreeCellRenderer getZeroRenderer() {
        return this.myZeroRenderer;
    }

    public int getColumnCount() {
        return this.myColumns.length;
    }

    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(int column, Object o, TableCellRenderer renderer) {
        return this.myColumns[column].getCustomizedRenderer(o, renderer);
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(node);
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
        throw new UnsupportedOperationException();
    }

    public void setTree(JTree tree) {
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public Object getChild(Object parent, int index) {
        Map<String, List<V8ProfileLine>> calls;
        List<String> groups = this.myFilteredGroups != null ? this.myFilteredGroups : this.myGroups;
        Map<String, List<V8ProfileLine>> map = calls = this.myFilteredCalls != null ? this.myFilteredCalls : this.myCalls;
        if (this.myRoot == parent) {
            return groups.get(index);
        }
        if (parent instanceof String) {
            List<V8ProfileLine> lines = calls.get(parent);
            return lines == null ? null : lines.get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        Map<String, List<V8ProfileLine>> calls;
        List<String> groups = this.myFilteredGroups != null ? this.myFilteredGroups : this.myGroups;
        Map<String, List<V8ProfileLine>> map = calls = this.myFilteredCalls != null ? this.myFilteredCalls : this.myCalls;
        if (this.myRoot == parent) {
            return groups.size();
        }
        if (parent instanceof String) {
            List<V8ProfileLine> lines = calls.get(parent);
            return lines == null ? 0 : lines.size();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        block3: {
            Map<String, List<V8ProfileLine>> calls;
            block2: {
                List<String> groups = this.myFilteredGroups != null ? this.myFilteredGroups : this.myGroups;
                Map<String, List<V8ProfileLine>> map = calls = this.myFilteredCalls != null ? this.myFilteredCalls : this.myCalls;
                if (this.myRoot != parent) break block2;
                for (int i = 0; i < groups.size(); ++i) {
                    String s = groups.get(i);
                    if (child != s) continue;
                    return i;
                }
                break block3;
            }
            if (!(parent instanceof String)) break block3;
            List<V8ProfileLine> lines = calls.get(parent);
            for (int i = 0; i < lines.size(); ++i) {
                V8ProfileLine line = lines.get(i);
                if (line != child) continue;
                return i;
            }
        }
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public boolean isFiltered() {
        return this.myFilteredCalls != null && this.myFilteredGroups != null;
    }

    @Override
    public int getTensPercentLevelInclusive() {
        return this.myTensPercentLevelInclusive;
    }

    @Override
    public void clearFilter() {
        this.myFilteredGroups = null;
        this.myFilteredCalls = null;
        this.myTensPercentLevelInclusive = 0;
    }

    @Override
    public void filterByLevel(int tensPercentLevelInclusive) {
        this.myTensPercentLevelInclusive = tensPercentLevelInclusive;
        this.myFilteredCalls = new HashMap<String, List<V8ProfileLine>>();
        for (Map.Entry<String, List<V8ProfileLine>> entry : this.myCalls.entrySet()) {
            String group = entry.getKey();
            List<V8ProfileLine> lines = entry.getValue();
            ArrayList<V8ProfileLine> filtered = new ArrayList<V8ProfileLine>();
            for (V8ProfileLine line : lines) {
                if (line.getTotalTensPercent() < tensPercentLevelInclusive) continue;
                filtered.add(line.cloneWithoutChildren(null));
            }
            if (filtered.isEmpty()) continue;
            this.myFilteredCalls.put(group, filtered);
        }
        this.myFilteredGroups = new ArrayList<String>(this.myFilteredCalls.size());
        for (String group : this.myGroups) {
            if (!this.myFilteredCalls.containsKey(group)) continue;
            this.myFilteredGroups.add(group);
        }
    }

    public Map<V8ProfileLine, String> search(@NotNull String text, boolean caseSensitive) {
        if (text == null) {
            TopCalledV8TreeTableModel.$$$reportNull$$$0(2);
        }
        HashMap<V8ProfileLine, String> map = new HashMap<V8ProfileLine, String>();
        for (Map.Entry<String, List<V8ProfileLine>> entry : this.myCalls.entrySet()) {
            for (V8ProfileLine line : entry.getValue()) {
                String presentation = line.getPresentation(false);
                boolean matches = caseSensitive ? presentation.contains(text) : StringUtil.toLowerCase((String)presentation).contains(StringUtil.toLowerCase((String)text));
                if (!matches) continue;
                map.put(line, entry.getKey());
            }
        }
        return map;
    }

    private List<ColumnInfo> createColumns(@NotNull LineColorProvider fileColor) {
        if (fileColor == null) {
            TopCalledV8TreeTableModel.$$$reportNull$$$0(3);
        }
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        Processor processor = line -> V8TreeTableModel.v8LineIsAboveThresholds(line);
        this.myZeroRenderer = new V8ProfileLineTreeCellRenderer<V8ProfileLine>(processor, fileColor){

            @Override
            protected V8CpuLogCall getCall(Object object) {
                if (!(object instanceof V8ProfileLine)) {
                    return null;
                }
                return ((V8ProfileLine)object).getCall();
            }
        };
        list.add(new V8ProfileLineColumnInfo(this.myZeroRenderer));
        V8ColumnForNumbers<Object> totalPercent = new V8ColumnForNumbers<Object>(NodeJSBundle.message("profile.cpu.top_called_table.total_perc.column.name", new Object[0]), processor){

            @NotNull
            public String valueOf(Object line) {
                if (line instanceof V8ProfileLine) {
                    String string = V8Utils.formatPercent(((V8ProfileLine)line).getTotalTensPercent());
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/view/TopCalledV8TreeTableModel$2", "valueOf"));
            }
        };
        V8ColumnForNumbers<Object> selfPercent = new V8ColumnForNumbers<Object>(NodeJSBundle.message("profile.cpu.top_called_table.self_perc.column.name", new Object[0]), processor){

            @NotNull
            public String valueOf(Object line) {
                if (line instanceof V8ProfileLine) {
                    String string = V8Utils.formatPercent(((V8ProfileLine)line).getSelfTensPercent());
                    if (string == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/view/TopCalledV8TreeTableModel$3", "valueOf"));
            }
        };
        V8ColumnForNumbers<Object> total = new V8ColumnForNumbers<Object>(NodeJSBundle.message("profile.cpu.top_called_table.total.column.name", new Object[0]), processor){

            @NotNull
            public String valueOf(Object line) {
                if (line instanceof V8ProfileLine) {
                    String string = String.valueOf(((V8ProfileLine)line).getTotalTicks());
                    if (string == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/view/TopCalledV8TreeTableModel$4", "valueOf"));
            }
        };
        V8ColumnForNumbers<Object> self = new V8ColumnForNumbers<Object>(NodeJSBundle.message("profile.cpu.top_called_table.self.column.name", new Object[0]), processor){

            @NotNull
            public String valueOf(Object line) {
                if (line instanceof V8ProfileLine) {
                    String string = String.valueOf(((V8ProfileLine)line).getSelfTicks());
                    if (string == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/view/TopCalledV8TreeTableModel$5", "valueOf"));
            }
        };
        list.add(self);
        list.add(selfPercent);
        list.add(total);
        list.add(totalPercent);
        return list;
    }

    @Nullable
    public TreePath createPathToCall(@NotNull String group, long stringId) {
        if (group == null) {
            TopCalledV8TreeTableModel.$$$reportNull$$$0(4);
        }
        Object[] path = new Object[3];
        path[0] = this.getRoot();
        path[1] = group;
        V8ProfileLine found = TopCalledV8TreeTableModel.findLine(group, stringId, this.myFilteredCalls != null ? this.myFilteredCalls : this.myCalls);
        if (found == null && this.myFilteredCalls != null && (found = TopCalledV8TreeTableModel.findLine(group, stringId, this.myCalls)) != null) {
            this.clearFilter();
        }
        if (found == null) {
            return null;
        }
        path[2] = found;
        return new TreePath(path);
    }

    /*
     * WARNING - void declaration
     */
    private static V8ProfileLine findLine(@NotNull String group, long stringId, @NotNull Map<String, List<V8ProfileLine>> map) {
        void map2;
        List list;
        if (group == null) {
            TopCalledV8TreeTableModel.$$$reportNull$$$0(5);
        }
        if (map == null) {
            TopCalledV8TreeTableModel.$$$reportNull$$$0(6);
        }
        if ((list = (List)map2.get(group)) == null) {
            return null;
        }
        for (V8ProfileLine line : list) {
            if (line.getCall().getStringId() != stringId) continue;
            return line;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileColor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/TopCalledV8TreeTableModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "search";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createColumns";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createPathToCall";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class V8ProfileLineColumnInfo
    extends ColumnInfo<Object, String> {
        private final ColoredTreeCellRenderer myCellRenderer;

        V8ProfileLineColumnInfo(@NotNull V8ProfileLineTreeCellRenderer renderer) {
            if (renderer == null) {
                V8ProfileLineColumnInfo.$$$reportNull$$$0(0);
            }
            super(NodeJSBundle.message("profile.cpu.top_called_table.column.calls.name", new Object[0]));
            this.myCellRenderer = renderer;
        }

        @Nullable
        public String valueOf(Object line) {
            return line.toString();
        }

        public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
            if (renderer instanceof TreeTableCellRenderer) {
                ((TreeTableCellRenderer)renderer).setCellRenderer((TreeCellRenderer)this.myCellRenderer);
            }
            return renderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/nodejs/run/profile/cpu/view/TopCalledV8TreeTableModel$V8ProfileLineColumnInfo", "<init>"));
        }
    }
}

