/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.services;

import com.intellij.collaboration.auth.services.OAuthCallbackHandlerKt;
import com.intellij.collaboration.auth.services.OAuthService;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.Future;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0005H$J\"\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler;", "", "<init>", "()V", "service", "Lcom/intellij/collaboration/auth/services/OAuthService;", "getService", "()Lcom/intellij/collaboration/auth/services/OAuthService;", "getServiceName", "", "oauthService", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "handleOAuthResult", "Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult;", "oAuthResult", "Lcom/intellij/collaboration/auth/services/OAuthService$OAuthResult;", "handleAcceptCode", "isAccepted", "", "sendRedirect", "", "url", "Lcom/intellij/util/Url;", "AcceptCodeHandleResult", "intellij.platform.collaborationTools.auth.base"})
public abstract class OAuthCallbackHandler {
    @NotNull
    protected final OAuthService<?> getService() {
        return this.oauthService();
    }

    @NotNull
    public final String getServiceName() {
        return this.getService().getName();
    }

    @NotNull
    protected abstract OAuthService<?> oauthService();

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Channel channel = context.channel();
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        channel.closeFuture().addListener(arg_0 -> OAuthCallbackHandler.execute$lambda$0(indicator, arg_0));
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
        ExecutorService executor = executorService;
        CompletableFuture.supplyAsync(() -> OAuthCallbackHandler.execute$lambda$2(indicator, this, urlDecoder), executor).handle((arg_0, arg_1) -> OAuthCallbackHandler.execute$lambda$4((arg_0, arg_1) -> OAuthCallbackHandler.execute$lambda$3(channel, context, request, this, arg_0, arg_1), arg_0, arg_1));
        return null;
    }

    @NotNull
    protected AcceptCodeHandleResult handleOAuthResult(@NotNull OAuthService.OAuthResult<?> oAuthResult) {
        Intrinsics.checkNotNullParameter(oAuthResult, (String)"oAuthResult");
        return this.handleAcceptCode(oAuthResult.isAccepted());
    }

    @Deprecated(message="Use handleOAuthResult instead", replaceWith=@ReplaceWith(expression="handleOAuthResult", imports={}))
    @NotNull
    public AcceptCodeHandleResult handleAcceptCode(boolean isAccepted) {
        throw new UnsupportedOperationException();
    }

    private final void sendRedirect(FullHttpRequest request, ChannelHandlerContext context, Url url) {
        HttpHeaders headers = new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.LOCATION, (Object)url.toExternalForm());
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.FOUND;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"FOUND");
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        Responses.send((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)headers);
    }

    private static final void execute$lambda$0(EmptyProgressIndicator $indicator, Future it) {
        $indicator.cancel();
    }

    private static final AcceptCodeHandleResult execute$handle$lambda$1(OAuthCallbackHandler this$0, QueryStringDecoder $urlDecoder) {
        OAuthService<?> oAuthService = this$0.getService();
        String string = $urlDecoder.path();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path(...)");
        Map map2 = $urlDecoder.parameters();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"parameters(...)");
        OAuthService.OAuthResult<?> oAuthResult = oAuthService.handleOAuthServerCallback(string, map2);
        if (oAuthResult == null) {
            return null;
        }
        OAuthService.OAuthResult<?> oAuthResult2 = oAuthResult;
        return this$0.handleOAuthResult(oAuthResult2);
    }

    private static final AcceptCodeHandleResult execute$handle(OAuthCallbackHandler this$0, QueryStringDecoder $urlDecoder, EmptyProgressIndicator indicator) {
        return (AcceptCodeHandleResult)ProgressManager.getInstance().runProcess(() -> OAuthCallbackHandler.execute$handle$lambda$1(this$0, $urlDecoder), (ProgressIndicator)indicator);
    }

    private static final AcceptCodeHandleResult execute$lambda$2(EmptyProgressIndicator $indicator, OAuthCallbackHandler this$0, QueryStringDecoder $urlDecoder) {
        return OAuthCallbackHandler.execute$handle(this$0, $urlDecoder, $indicator);
    }

    private static final Object execute$lambda$3(Channel $channel, ChannelHandlerContext $context, FullHttpRequest $request, OAuthCallbackHandler this$0, AcceptCodeHandleResult res, Throwable err) {
        ChannelFuture channelFuture;
        if (err != null) {
            if (err instanceof ProcessCanceledException) {
                channelFuture = $channel.close();
            } else {
                OAuthCallbackHandlerKt.access$getLOG$p().warn(err);
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
                Intrinsics.checkNotNull((Object)$channel);
                Responses.responseStatus((HttpResponseStatus)httpResponseStatus, (boolean)false, (Channel)$channel);
                channelFuture = Unit.INSTANCE;
            }
        } else if (res != null) {
            AcceptCodeHandleResult acceptCodeHandleResult = res;
            if (acceptCodeHandleResult instanceof AcceptCodeHandleResult.Page) {
                byte[] byArray = ((AcceptCodeHandleResult.Page)res).getHtml().getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                HttpResponse httpResponse = (HttpResponse)Responses.response((String)"text/html;charset=utf-8", (ByteBuf)Unpooled.wrappedBuffer((byte[])byArray));
                Channel channel = $context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)$request), null, (int)4, null);
            } else if (acceptCodeHandleResult instanceof AcceptCodeHandleResult.Redirect) {
                this$0.sendRedirect($request, $context, ((AcceptCodeHandleResult.Redirect)res).getUrl());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            channelFuture = Unit.INSTANCE;
        } else {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NO_CONTENT;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NO_CONTENT");
            Intrinsics.checkNotNull((Object)$channel);
            Responses.responseStatus((HttpResponseStatus)httpResponseStatus, (boolean)false, (Channel)$channel);
            channelFuture = Unit.INSTANCE;
        }
        return channelFuture;
    }

    private static final Object execute$lambda$4(Function2 $tmp0, Object p0, Throwable p1) {
        return $tmp0.invoke(p0, (Object)p1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult;", "", "<init>", "()V", "Redirect", "Page", "Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult$Page;", "Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult$Redirect;", "intellij.platform.collaborationTools.auth.base"})
    public static abstract class AcceptCodeHandleResult {
        private AcceptCodeHandleResult() {
        }

        public /* synthetic */ AcceptCodeHandleResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult$Page;", "Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult;", "html", "", "<init>", "(Ljava/lang/String;)V", "getHtml", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.collaborationTools.auth.base"})
        public static final class Page
        extends AcceptCodeHandleResult {
            @NotNull
            private final String html;

            public Page(@NotNull String html) {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                super(null);
                this.html = html;
            }

            @NotNull
            public final String getHtml() {
                return this.html;
            }

            @NotNull
            public final String component1() {
                return this.html;
            }

            @NotNull
            public final Page copy(@NotNull String html) {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                return new Page(html);
            }

            public static /* synthetic */ Page copy$default(Page page, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = page.html;
                }
                return page.copy(string);
            }

            @NotNull
            public String toString() {
                return "Page(html=" + this.html + ")";
            }

            public int hashCode() {
                return this.html.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Page)) {
                    return false;
                }
                Page page = (Page)other;
                return Intrinsics.areEqual((Object)this.html, (Object)page.html);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult$Redirect;", "Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult;", "url", "Lcom/intellij/util/Url;", "<init>", "(Lcom/intellij/util/Url;)V", "getUrl", "()Lcom/intellij/util/Url;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.collaborationTools.auth.base"})
        public static final class Redirect
        extends AcceptCodeHandleResult {
            @NotNull
            private final Url url;

            public Redirect(@NotNull Url url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                super(null);
                this.url = url;
            }

            @NotNull
            public final Url getUrl() {
                return this.url;
            }

            @NotNull
            public final Url component1() {
                return this.url;
            }

            @NotNull
            public final Redirect copy(@NotNull Url url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                return new Redirect(url);
            }

            public static /* synthetic */ Redirect copy$default(Redirect redirect, Url url, int n, Object object) {
                if ((n & 1) != 0) {
                    url = redirect.url;
                }
                return redirect.copy(url);
            }

            @NotNull
            public String toString() {
                return "Redirect(url=" + this.url + ")";
            }

            public int hashCode() {
                return this.url.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Redirect)) {
                    return false;
                }
                Redirect redirect = (Redirect)other;
                return Intrinsics.areEqual((Object)this.url, (Object)redirect.url);
            }
        }
    }
}

