/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.FilePathIconProvider;
import com.intellij.openapi.vcs.impl.RepositoryBrowserPanel;
import com.intellij.openapi.vcs.impl.VcsVirtualFileContentRevision;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.PlatformIcons;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001!B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vcs/impl/RepositoryBrowserPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "localRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoot", "()Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "fileSystemTree", "Lcom/intellij/openapi/fileChooser/ex/FileSystemTreeImpl;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "dispose", "hasSelectedFiles", "", "getSelectionAsChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "createChangeVsLocal", "file", "Lcom/intellij/openapi/vcs/vfs/VcsVirtualFile;", "getLocalFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRepositoryBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryBrowser.kt\ncom/intellij/openapi/vcs/impl/RepositoryBrowserPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,195:1\n3829#2:196\n4344#2,2:197\n12567#2,2:207\n4135#2,11:209\n1557#3:199\n1628#3,3:200\n1557#3:220\n1628#3,3:221\n37#4:203\n36#4,3:204\n*S KotlinDebug\n*F\n+ 1 RepositoryBrowser.kt\ncom/intellij/openapi/vcs/impl/RepositoryBrowserPanel\n*L\n132#1:196\n132#1:197,2\n142#1:207,2\n146#1:209,11\n133#1:199\n133#1:200,3\n147#1:220\n147#1:221,3\n134#1:203\n134#1:204,3\n*E\n"})
public final class RepositoryBrowserPanel
extends JPanel
implements UiDataProvider,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AbstractVcsVirtualFile root;
    @NotNull
    private final VirtualFile localRoot;
    @NotNull
    private final FileSystemTreeImpl fileSystemTree;
    @NotNull
    private static final DataKey<RepositoryBrowserPanel> REPOSITORY_BROWSER_DATA_KEY = DataKey.Companion.create("com.intellij.openapi.vcs.impl.RepositoryBrowserPanel");

    public RepositoryBrowserPanel(@NotNull Project project, @NotNull AbstractVcsVirtualFile root, @NotNull VirtualFile localRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)root), (String)"root");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        super(new BorderLayout());
        this.project = project;
        this.root = root;
        this.localRoot = localRoot;
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(this){
            final /* synthetic */ RepositoryBrowserPanel this$0;
            {
                this.this$0 = $receiver;
                super(true, false, false, false, false, true);
            }

            public List<VirtualFile> getRoots() {
                return CollectionsKt.listOf((Object)((Object)this.this$0.getRoot()));
            }

            public Icon getIcon(VirtualFile file) {
                FilePath localPath;
                Icon icon;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (file.isDirectory()) {
                    return PlatformIcons.FOLDER_ICON;
                }
                if (file instanceof VcsVirtualFile && (icon = (Icon)FilePathIconProvider.EP_NAME.computeSafeIfAny(arg_0 -> fileChooserDescriptor.1.getIcon$lambda$0(localPath = RepositoryBrowserPanel.access$getLocalFilePath(this.this$0, (VcsVirtualFile)file), this.this$0, arg_0))) != null) {
                    return icon;
                }
                return FileTypeManager.getInstance().getFileTypeByFileName(file.getNameSequence()).getIcon();
            }

            private static final Icon getIcon$lambda$0(FilePath $localPath, RepositoryBrowserPanel this$0, FilePathIconProvider it) {
                return it.getIcon($localPath, this$0.getProject());
            }
        };
        Project project2 = this.project;
        this.fileSystemTree = new FileSystemTreeImpl(fileChooserDescriptor2, project2){};
        this.fileSystemTree.addOkAction(() -> RepositoryBrowserPanel._init_$lambda$0(this));
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        actionGroup.add(ActionManager.getInstance().getAction("Vcs.ShowDiffWithLocal"));
        this.fileSystemTree.registerMouseListener((ActionGroup)actionGroup);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)(this.fileSystemTree).getTree(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane scrollPane = jScrollPane;
        this.add((Component)scrollPane, "Center");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final AbstractVcsVirtualFile getRoot() {
        return this.root;
    }

    /*
     * WARNING - void declaration
     */
    public void uiDataSnapshot(@NotNull DataSink sink) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = CommonDataKeys.VIRTUAL_FILE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"VIRTUAL_FILE_ARRAY");
        sink.set(dataKey, (Object)this.fileSystemTree.getSelectedFiles());
        DataKey dataKey2 = CommonDataKeys.NAVIGATABLE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"NAVIGATABLE_ARRAY");
        VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        Object[] objectArray = virtualFileArray;
        DataKey dataKey3 = dataKey2;
        DataSink dataSink = sink;
        boolean $i$f$filter = false;
        void var4_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (VirtualFile element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = element$iv$iv;
            boolean bl = false;
            if (!(!it.isDirectory())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<OpenFileDescriptor> collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile element$iv$iv;
            element$iv$iv = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new OpenFileDescriptor(this.project, (VirtualFile)it));
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        dataSink.set(dataKey3, (Object)thisCollection$iv.toArray(new OpenFileDescriptor[0]));
        sink.set(REPOSITORY_BROWSER_DATA_KEY, (Object)this);
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.fileSystemTree));
    }

    public final boolean hasSelectedFiles() {
        boolean bl;
        block1: {
            VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
            Object[] $this$any$iv = virtualFileArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (!(it instanceof VcsVirtualFile)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Change> getSelectionAsChanges() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        Object[] $this$filterIsInstance$iv = virtualFileArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (VcsVirtualFile element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VcsVirtualFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsVirtualFile element$iv$iv;
            element$iv$iv = (VcsVirtualFile)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createChangeVsLocal((VcsVirtualFile)it));
        }
        return (List)destination$iv$iv;
    }

    private final Change createChangeVsLocal(VcsVirtualFile file) {
        VcsVirtualFileContentRevision repoRevision = new VcsVirtualFileContentRevision(file);
        FilePath localPath = this.getLocalFilePath(file);
        CurrentContentRevision localRevision = new CurrentContentRevision(localPath);
        return new Change((ContentRevision)repoRevision, (ContentRevision)localRevision);
    }

    private final FilePath getLocalFilePath(VcsVirtualFile file) {
        File localFile = new File(this.localRoot.getPath(), file.getPath());
        FilePath filePath = VcsUtil.getFilePath((File)localFile, (boolean)file.isDirectory());
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return filePath;
    }

    private static final void _init_$lambda$0(RepositoryBrowserPanel this$0) {
        VirtualFile[] virtualFileArray = (this$0.fileSystemTree).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        for (VirtualFile file : virtualFileArray) {
            FileEditorManager.getInstance((Project)this$0.project).openFile(file, true);
        }
    }

    public static final /* synthetic */ FilePath access$getLocalFilePath(RepositoryBrowserPanel $this, VcsVirtualFile file) {
        return $this.getLocalFilePath(file);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/RepositoryBrowserPanel$Companion;", "", "<init>", "()V", "REPOSITORY_BROWSER_DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/vcs/impl/RepositoryBrowserPanel;", "getREPOSITORY_BROWSER_DATA_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<RepositoryBrowserPanel> getREPOSITORY_BROWSER_DATA_KEY() {
            return REPOSITORY_BROWSER_DATA_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

