/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ArrayUtilsKt;
import org.jetbrains.letsPlot.util.pngj.BufferedStreamFeeder;
import org.jetbrains.letsPlot.util.pngj.ChunkReader;
import org.jetbrains.letsPlot.util.pngj.DeflatedChunkReader;
import org.jetbrains.letsPlot.util.pngj.DeflatedChunksSet;
import org.jetbrains.letsPlot.util.pngj.ErrorBehaviour;
import org.jetbrains.letsPlot.util.pngj.IBytesConsumer;
import org.jetbrains.letsPlot.util.pngj.InputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjBadSignature;
import org.jetbrains.letsPlot.util.pngj.PngjExceptionInternal;
import org.jetbrains.letsPlot.util.pngj.PngjInputException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\b \u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0002J\b\u0010!\u001a\u00020\u001fH\u0016J \u0010\"\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0016J(\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0016H\u0014J\u0012\u0010)\u001a\u0004\u0018\u00010\u00112\u0006\u0010&\u001a\u00020'H$J\b\u0010*\u001a\u00020'H\u0002J\u001e\u0010+\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007J\u001a\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020\u0016H\u0007J\b\u00101\u001a\u00020'H\u0002J\b\u00102\u001a\u0004\u0018\u00010\u000fJ\b\u00103\u001a\u0004\u0018\u00010\u0011J\u0012\u00104\u001a\u00020\u00162\b\u0010&\u001a\u0004\u0018\u00010'H\u0014J\u0010\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u000fH\u0014J\u000e\u00107\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u00108\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010'H\u0014J\u0018\u00109\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'H\u0014J \u0010:\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020\tH\u0014R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0016@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0017\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/ChunkSeqReader;", "Lorg/jetbrains/letsPlot/util/pngj/IBytesConsumer;", "expectedSignature", "", "([B)V", "buf0", "buf0len", "", "<set-?>", "", "bytesCount", "getBytesCount", "()J", "chunkCount", "curChunkReader", "Lorg/jetbrains/letsPlot/util/pngj/ChunkReader;", "curDeflatedSet", "Lorg/jetbrains/letsPlot/util/pngj/DeflatedChunksSet;", "errorBehaviour", "Lorg/jetbrains/letsPlot/util/pngj/ErrorBehaviour;", "idatBytes", "isAtChunkBoundary", "", "()Z", "isClosed", "isDone", "setDone", "(Z)V", "isSignatureDone", "signatureLength", "checkSignature", "", "buf", "close", "consume", "offset", "len", "createChunkReaderForNewChunk", "id", "", "skip", "createIdatSet", "endChunkId", "feedAll", "off", "feedFromInputStream", "is", "Lorg/jetbrains/letsPlot/util/pngj/InputPngStream;", "closeStream", "firstChunkId", "getCurChunkReader", "getCurDeflatedSet", "isIdatKind", "postProcessChunk", "chunkR", "setErrorBehaviour", "shouldCheckCrc", "shouldSkipContent", "startNewChunk", "plot-api"})
@SourceDebugExtension(value={"SMAP\nChunkSeqReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkSeqReader.kt\norg/jetbrains/letsPlot/util/pngj/ChunkSeqReader\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,405:1\n1064#2,2:406\n*S KotlinDebug\n*F\n+ 1 ChunkSeqReader.kt\norg/jetbrains/letsPlot/util/pngj/ChunkSeqReader\n*L\n191#1:406,2\n*E\n"})
public abstract class ChunkSeqReader
implements IBytesConsumer {
    private final int signatureLength;
    @NotNull
    private final byte[] buf0;
    private int buf0len;
    private boolean isSignatureDone;
    private boolean isDone;
    private boolean isClosed;
    private int chunkCount;
    private long bytesCount;
    @Nullable
    private DeflatedChunksSet curDeflatedSet;
    @Nullable
    private ChunkReader curChunkReader;
    private long idatBytes;
    @NotNull
    private ErrorBehaviour errorBehaviour;

    @JvmOverloads
    public ChunkSeqReader(@Nullable byte[] expectedSignature) {
        this.signatureLength = expectedSignature != null ? expectedSignature.length : 0;
        this.buf0 = new byte[8];
        this.isSignatureDone = this.signatureLength <= 0;
        this.errorBehaviour = ErrorBehaviour.STRICT;
    }

    public /* synthetic */ ChunkSeqReader(byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            byArray = PngHelperInternal.INSTANCE.getPngIdSignature();
        }
        this(byArray);
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    protected void setDone(boolean bl) {
        this.isDone = bl;
    }

    public final long getBytesCount() {
        return this.bytesCount;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int consume(@NotNull byte[] buf, int offset2, int len) {
        int processed;
        block10: {
            block12: {
                int read0;
                block11: {
                    Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                    if (this.isClosed) {
                        return -1;
                    }
                    if (len == 0) {
                        return 0;
                    }
                    if (len < 0) {
                        throw new PngjInputException("This should not happen. Bad length: " + len);
                    }
                    processed = 0;
                    if (!this.isSignatureDone) break block10;
                    if (this.curChunkReader == null) break block11;
                    ChunkReader chunkReader = this.curChunkReader;
                    Intrinsics.checkNotNull((Object)chunkReader);
                    if (!chunkReader.isDone()) break block12;
                }
                if ((read0 = 8 - this.buf0len) > len) {
                    read0 = len;
                }
                ArrayUtilsKt.arraycopy(buf, offset2, this.buf0, this.buf0len, read0);
                this.buf0len += read0;
                processed += read0;
                this.bytesCount += (long)read0;
                if (this.buf0len != 8) return processed;
                int n = this.chunkCount;
                this.chunkCount = n + 1;
                int clen = PngHelperInternal.INSTANCE.readInt4fromBytes(this.buf0, 0);
                String cid = ChunkHelper.INSTANCE.idFromBytes(this.buf0, 4);
                this.startNewChunk(clen, cid, this.bytesCount - (long)8);
                this.buf0len = 0;
                return processed;
            }
            ChunkReader chunkReader = this.curChunkReader;
            Intrinsics.checkNotNull((Object)chunkReader);
            int read1 = chunkReader.consume(buf, offset2, len);
            if (read1 < 0) {
                return -1;
            }
            this.bytesCount += (long)read1;
            return processed += read1;
        }
        int read = this.signatureLength - this.buf0len;
        if (read > len) {
            read = len;
        }
        ArrayUtilsKt.arraycopy(buf, offset2, this.buf0, this.buf0len, read);
        this.buf0len += read;
        if (this.buf0len == this.signatureLength) {
            this.checkSignature(this.buf0);
            this.buf0len = 0;
            this.isSignatureDone = true;
        }
        processed += read;
        this.bytesCount += (long)read;
        return processed;
    }

    public final int feedAll(@NotNull byte[] buf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int off2 = off;
        int len2 = len;
        while (len2 > 0) {
            int n = this.consume(buf, off2, len2);
            if (n < 1) {
                return len2;
            }
            len2 -= n;
            off2 += n;
        }
        if (!(len2 == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    protected void startNewChunk(int len, @NotNull String id, long offset) {
        block18: {
            block17: {
                block16: {
                    Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                    System.out.println((Object)("New chunk: " + id + ' ' + len + " off:" + offset));
                    if (id.length() != 4) break block17;
                    $this$all$iv = id;
                    $i$f$all = false;
                    for (var7_7 = 0; var7_7 < $this$all$iv.length(); ++var7_7) {
                        it = element$iv = $this$all$iv.charAt(var7_7);
                        $i$a$-all-ChunkSeqReader$startNewChunk$1 = false;
                        if ('a' <= it ? it < '{' : false) ** GOTO lbl-1000
                        if (!('A' <= it ? it < '[' : false)) {
                            v0 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v0 = false;
                        }
                        if (v0) continue;
                        v1 = false;
                        break block16;
                    }
                    v1 = true;
                }
                if (!v1) break block18;
            }
            throw new PngjInputException("Bad chunk id: " + id);
        }
        if (len < 0) {
            throw new PngjInputException("Bad chunk len: " + len);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"IDAT")) {
            this.idatBytes += (long)len;
        }
        checkCrc = this.shouldCheckCrc(len, id);
        skip = this.shouldSkipContent(len, id);
        isIdatType = this.isIdatKind(id);
        forCurrentIdatSet = false;
        if (this.curDeflatedSet != null) {
            v2 = this.curDeflatedSet;
            Intrinsics.checkNotNull((Object)v2);
            if (!v2.isClosed()) {
                v3 = this.curDeflatedSet;
                Intrinsics.checkNotNull((Object)v3);
                forCurrentIdatSet = v3.ackNextChunkId(id);
            }
        }
        if (isIdatType && !skip) {
            if (!forCurrentIdatSet) {
                if (this.curDeflatedSet != null) {
                    v4 = this.curDeflatedSet;
                    Intrinsics.checkNotNull((Object)v4);
                    if (!v4.isDone()) {
                        throw new PngjInputException("new IDAT-like chunk when previous was not done");
                    }
                }
                this.curDeflatedSet = this.createIdatSet(id);
            }
            v5 = this.curDeflatedSet;
            Intrinsics.checkNotNull((Object)v5);
            var9_10 = v5;
            this.curChunkReader = new DeflatedChunkReader(len, id, checkCrc, offset, this, var9_10){
                final /* synthetic */ ChunkSeqReader this$0;
                {
                    this.this$0 = $receiver;
                    super($len, $id, $checkCrc, $offset, $super_call_param$1);
                }

                protected void chunkDone() {
                    super.chunkDone();
                    this.this$0.postProcessChunk(this);
                }
            };
        } else {
            this.curChunkReader = this.createChunkReaderForNewChunk(id, len, offset, skip);
        }
        if (this.curChunkReader != null && !checkCrc) {
            v6 = this.curChunkReader;
            Intrinsics.checkNotNull((Object)v6);
            v6.setCrcCheck(false);
        }
    }

    @NotNull
    protected ChunkReader createChunkReaderForNewChunk(@NotNull String id, int len, long offset2, boolean skip) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ChunkReader.ChunkReaderMode chunkReaderMode = skip ? ChunkReader.ChunkReaderMode.SKIP : ChunkReader.ChunkReaderMode.BUFFER;
        return new ChunkReader(len, id, offset2, this, chunkReaderMode){
            final /* synthetic */ ChunkSeqReader this$0;
            {
                this.this$0 = $receiver;
                super($len, $id, $offset, $super_call_param$1);
            }

            protected void chunkDone() {
                this.this$0.postProcessChunk(this);
            }

            protected void processData(int offsetInchunk, @NotNull byte[] buf, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                throw new PngjExceptionInternal("should never happen");
            }
        };
    }

    protected void postProcessChunk(@NotNull ChunkReader chunkR) {
        String cid;
        Intrinsics.checkNotNullParameter((Object)chunkR, (String)"chunkR");
        if (this.chunkCount == 1 && !Intrinsics.areEqual((Object)(cid = this.firstChunkId()), (Object)chunkR.getChunkRaw().getId())) {
            String msg = "Bad first chunk: " + chunkR.getChunkRaw().getId() + " expected: " + this.firstChunkId();
            if (this.errorBehaviour.getC() < ErrorBehaviour.SUPER_LENIENT.getC()) {
                throw new PngjInputException(msg);
            }
            System.out.println((Object)msg);
        }
        if (Intrinsics.areEqual((Object)chunkR.getChunkRaw().getId(), (Object)this.endChunkId())) {
            this.setDone(true);
            this.close();
        }
    }

    @Nullable
    protected abstract DeflatedChunksSet createIdatSet(@NotNull String var1);

    protected boolean isIdatKind(@Nullable String id) {
        return false;
    }

    protected boolean shouldSkipContent(int len, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return false;
    }

    protected boolean shouldCheckCrc(int len, @Nullable String id) {
        return true;
    }

    private final void checkSignature(byte[] buf) {
        if (!Arrays.equals(buf, PngHelperInternal.INSTANCE.getPngIdSignature())) {
            throw new PngjBadSignature("Bad signature:" + ArraysKt.joinToString$default((byte[])buf, null, null, null, (int)0, null, null, (int)63, null));
        }
    }

    @Nullable
    public final ChunkReader getCurChunkReader() {
        return this.curChunkReader;
    }

    @Nullable
    public final DeflatedChunksSet getCurDeflatedSet() {
        return this.curDeflatedSet;
    }

    public void close() {
        DeflatedChunksSet deflatedChunksSet = this.curDeflatedSet;
        if (deflatedChunksSet != null) {
            deflatedChunksSet.close();
        }
        this.isClosed = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAtChunkBoundary() {
        if (this.bytesCount == 0L) return true;
        if (this.bytesCount == 8L) return true;
        if (this.isClosed) return true;
        if (this.curChunkReader == null) return true;
        ChunkReader chunkReader = this.curChunkReader;
        Intrinsics.checkNotNull((Object)chunkReader);
        if (!chunkReader.isDone()) return false;
        return true;
    }

    private final String firstChunkId() {
        return "IHDR";
    }

    private final String endChunkId() {
        return "IEND";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void feedFromInputStream(@NotNull InputPngStream is, boolean closeStream) {
        Intrinsics.checkNotNullParameter((Object)is, (String)"is");
        sf.setCloseStream(closeStream);
        try (BufferedStreamFeeder sf = new BufferedStreamFeeder(is, 0, 2, null);){
            sf.feedAll(this);
        }
    }

    public static /* synthetic */ void feedFromInputStream$default(ChunkSeqReader chunkSeqReader, InputPngStream inputPngStream, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: feedFromInputStream");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        chunkSeqReader.feedFromInputStream(inputPngStream, bl);
    }

    public final void setErrorBehaviour(@NotNull ErrorBehaviour errorBehaviour) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorBehaviour), (String)"errorBehaviour");
        this.errorBehaviour = errorBehaviour;
    }

    @JvmOverloads
    public ChunkSeqReader() {
        this(null, 1, null);
    }

    @JvmOverloads
    public final void feedFromInputStream(@NotNull InputPngStream is) {
        Intrinsics.checkNotNullParameter((Object)is, (String)"is");
        ChunkSeqReader.feedFromInputStream$default(this, is, false, 2, null);
    }
}

