/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import org.apache.xmlgraphics.java2d.color.ICCColorSpaceWithIntent;
import org.apache.xmlgraphics.java2d.color.RenderingIntent;
import org.jetbrains.relocated.apache.batik.anim.dom.AbstractSVGAnimatedLength;
import org.jetbrains.relocated.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMAnimatedPreserveAspectRatio;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMDocument;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMElement;
import org.jetbrains.relocated.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.jetbrains.relocated.apache.batik.bridge.Bridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.CSSUtilities;
import org.jetbrains.relocated.apache.batik.bridge.DocumentLoader;
import org.jetbrains.relocated.apache.batik.bridge.InterruptedBridgeException;
import org.jetbrains.relocated.apache.batik.bridge.Messages;
import org.jetbrains.relocated.apache.batik.bridge.SVGBrokenLinkProvider;
import org.jetbrains.relocated.apache.batik.bridge.SVGColorProfileElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.UserAgent;
import org.jetbrains.relocated.apache.batik.bridge.ViewBox;
import org.jetbrains.relocated.apache.batik.css.engine.CSSEngine;
import org.jetbrains.relocated.apache.batik.dom.AbstractNode;
import org.jetbrains.relocated.apache.batik.dom.events.DOMMouseEvent;
import org.jetbrains.relocated.apache.batik.dom.events.NodeEventTarget;
import org.jetbrains.relocated.apache.batik.dom.svg.LiveAttributeException;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.Filter;
import org.jetbrains.relocated.apache.batik.ext.awt.image.spi.BrokenLinkProvider;
import org.jetbrains.relocated.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.jetbrains.relocated.apache.batik.gvt.CanvasGraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.CompositeGraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.ImageNode;
import org.jetbrains.relocated.apache.batik.gvt.RasterImageNode;
import org.jetbrains.relocated.apache.batik.gvt.ShapeNode;
import org.jetbrains.relocated.apache.batik.util.HaltingThread;
import org.jetbrains.relocated.apache.batik.util.MimeTypeConstants;
import org.jetbrains.relocated.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImageElementBridge
extends AbstractGraphicsNodeBridge {
    protected SVGDocument imgDocument;
    protected EventListener listener = null;
    protected BridgeContext subCtx = null;
    protected boolean hitCheckChildren = false;
    static SVGBrokenLinkProvider brokenLinkProvider = new SVGBrokenLinkProvider();

    @Override
    public String getLocalName() {
        return "image";
    }

    @Override
    public Bridge getInstance() {
        return new SVGImageElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext ctx2, Element e) {
        ImageNode imageNode = (ImageNode)super.createGraphicsNode(ctx2, e);
        if (imageNode == null) {
            return null;
        }
        this.associateSVGContext(ctx2, e, imageNode);
        this.hitCheckChildren = false;
        GraphicsNode node = this.buildImageGraphicsNode(ctx2, e);
        if (node == null) {
            SVGImageElement ie = (SVGImageElement)e;
            String uriStr = ie.getHref().getAnimVal();
            throw new BridgeException(ctx2, e, "uri.image.invalid", new Object[]{uriStr});
        }
        imageNode.setImage(node);
        imageNode.setHitCheckChildren(this.hitCheckChildren);
        RenderingHints hints = null;
        hints = CSSUtilities.convertImageRendering(e, hints);
        hints = CSSUtilities.convertColorRendering(e, hints);
        if (hints != null) {
            imageNode.setRenderingHints(hints);
        }
        return imageNode;
    }

    protected GraphicsNode buildImageGraphicsNode(BridgeContext ctx2, Element e) {
        SVGImageElement ie = (SVGImageElement)e;
        String uriStr = ie.getHref().getAnimVal();
        if (uriStr.length() == 0) {
            throw new BridgeException(ctx2, e, "attribute.missing", new Object[]{"xlink:href"});
        }
        if (uriStr.indexOf(35) != -1) {
            throw new BridgeException(ctx2, e, "attribute.malformed", new Object[]{"xlink:href", uriStr});
        }
        String baseURI = AbstractNode.getBaseURI(e);
        ParsedURL purl = baseURI == null ? new ParsedURL(uriStr) : new ParsedURL(baseURI, uriStr);
        this.checkLoadExternalResource(ctx2, e, purl);
        return this.createImageGraphicsNode(ctx2, e, purl);
    }

    private void checkLoadExternalResource(BridgeContext ctx2, Element e, ParsedURL purl) {
        SVGDocument svgDoc = (SVGDocument)e.getOwnerDocument();
        String docURL = svgDoc.getURL();
        ParsedURL pDocURL = null;
        if (docURL != null) {
            pDocURL = new ParsedURL(docURL);
        }
        UserAgent userAgent = ctx2.getUserAgent();
        try {
            userAgent.checkLoadExternalResource(purl, pDocURL);
        }
        catch (SecurityException secEx) {
            throw new BridgeException(ctx2, e, secEx, "uri.unsecure", new Object[]{purl});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GraphicsNode createImageGraphicsNode(BridgeContext ctx2, Element e, ParsedURL purl) {
        Rectangle2D bounds = SVGImageElementBridge.getImageBounds(ctx2, e);
        if (bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
            ShapeNode sn = new ShapeNode();
            sn.setShape(bounds);
            return sn;
        }
        DocumentLoader loader = ctx2.getDocumentLoader();
        ImageTagRegistry reg = ImageTagRegistry.getRegistry();
        ICCColorSpaceWithIntent colorspace = SVGImageElementBridge.extractColorSpace(e, ctx2);
        try {
            Document doc = loader.checkCache(purl.toString());
            if (doc != null) {
                this.imgDocument = (SVGDocument)doc;
                return this.createSVGImageNode(ctx2, e, this.imgDocument);
            }
        }
        catch (BridgeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            // empty catch block
        }
        Filter img = reg.checkCache(purl, colorspace);
        if (img != null) {
            return this.createRasterImageNode(ctx2, e, img, purl);
        }
        ProtectedStream reference = null;
        try {
            reference = this.openStream(e, purl);
        }
        catch (SecurityException secEx) {
            throw new BridgeException(ctx2, e, secEx, "uri.unsecure", new Object[]{purl});
        }
        catch (IOException ioe) {
            return this.createBrokenImageNode(ctx2, e, purl.toString(), ioe.getLocalizedMessage());
        }
        Filter img2 = reg.readURL(reference, purl, colorspace, false, false);
        if (img2 != null) {
            try {
                reference.tie();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.createRasterImageNode(ctx2, e, img2, purl);
        }
        try {
            reference.retry();
        }
        catch (IOException ioe) {
            reference.release();
            reference = null;
            try {
                reference = this.openStream(e, purl);
            }
            catch (IOException ioe2) {
                return this.createBrokenImageNode(ctx2, e, purl.toString(), ioe2.getLocalizedMessage());
            }
        }
        try {
            Document doc = loader.loadDocument(purl.toString(), reference);
            reference.release();
            this.imgDocument = (SVGDocument)doc;
            return this.createSVGImageNode(ctx2, e, this.imgDocument);
        }
        catch (BridgeException ex) {
            reference.release();
            throw ex;
        }
        catch (SecurityException secEx) {
            reference.release();
            throw new BridgeException(ctx2, e, secEx, "uri.unsecure", new Object[]{purl});
        }
        catch (InterruptedIOException iioe) {
            reference.release();
            if (HaltingThread.hasBeenHalted()) {
                throw new InterruptedBridgeException();
            }
        }
        catch (InterruptedBridgeException ibe) {
            reference.release();
            throw ibe;
        }
        catch (Exception ibe) {
            // empty catch block
        }
        try {
            reference.retry();
        }
        catch (IOException ioe) {
            reference.release();
            reference = null;
            try {
                reference = this.openStream(e, purl);
            }
            catch (IOException ioe2) {
                return this.createBrokenImageNode(ctx2, e, purl.toString(), ioe2.getLocalizedMessage());
            }
        }
        try {
            img = reg.readURL(reference, purl, colorspace, true, true);
            if (img != null) {
                GraphicsNode graphicsNode = this.createRasterImageNode(ctx2, e, img, purl);
                return graphicsNode;
            }
        }
        finally {
            reference.release();
        }
        return null;
    }

    protected ProtectedStream openStream(Element e, ParsedURL purl) throws IOException {
        ArrayList mimeTypes = new ArrayList(ImageTagRegistry.getRegistry().getRegisteredMimeTypes());
        mimeTypes.addAll(MimeTypeConstants.MIME_TYPES_SVG_LIST);
        InputStream reference = purl.openStream(mimeTypes.iterator());
        return new ProtectedStream(reference);
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return new ImageNode();
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    protected void initializeDynamicSupport(BridgeContext ctx2, Element e, GraphicsNode node) {
        if (!ctx2.isInteractive()) {
            return;
        }
        ctx2.bind(e, node);
        if (ctx2.isDynamic()) {
            this.e = e;
            this.node = node;
            this.ctx = ctx2;
            ((SVGOMElement)e).setSVGContext(this);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue alav) {
        try {
            String ns = alav.getNamespaceURI();
            String ln = alav.getLocalName();
            if (ns == null) {
                if (ln.equals("x") || ln.equals("y")) {
                    this.updateImageBounds();
                    return;
                }
                if (ln.equals("width") || ln.equals("height")) {
                    SVGImageElement ie = (SVGImageElement)this.e;
                    ImageNode imageNode = (ImageNode)this.node;
                    AbstractSVGAnimatedLength _attr = ln.charAt(0) == 'w' ? (AbstractSVGAnimatedLength)ie.getWidth() : (AbstractSVGAnimatedLength)ie.getHeight();
                    float val = _attr.getCheckedValue();
                    if (val == 0.0f || imageNode.getImage() instanceof ShapeNode) {
                        this.rebuildImageNode();
                    } else {
                        this.updateImageBounds();
                    }
                    return;
                }
                if (ln.equals("preserveAspectRatio")) {
                    this.updateImageBounds();
                    return;
                }
            } else if (ns.equals("http://www.w3.org/1999/xlink") && ln.equals("href")) {
                this.rebuildImageNode();
                return;
            }
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(this.ctx, ex);
        }
        super.handleAnimatedAttributeChanged(alav);
    }

    protected void updateImageBounds() {
        Rectangle2D bounds = SVGImageElementBridge.getImageBounds(this.ctx, this.e);
        GraphicsNode imageNode = ((ImageNode)this.node).getImage();
        float[] vb = null;
        if (imageNode instanceof RasterImageNode) {
            Rectangle2D imgBounds = ((RasterImageNode)imageNode).getImageBounds();
            vb = new float[]{0.0f, 0.0f, (float)imgBounds.getWidth(), (float)imgBounds.getHeight()};
        } else if (this.imgDocument != null) {
            SVGSVGElement svgElement = this.imgDocument.getRootElement();
            String viewBox = svgElement.getAttributeNS(null, "viewBox");
            vb = ViewBox.parseViewBoxAttribute(this.e, viewBox, this.ctx);
        }
        if (imageNode != null) {
            SVGImageElementBridge.initializeViewport(this.ctx, this.e, imageNode, vb, bounds);
        }
    }

    protected void rebuildImageNode() {
        if (this.imgDocument != null && this.listener != null) {
            NodeEventTarget tgt = (NodeEventTarget)this.imgDocument.getRootElement();
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keypress", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keyup", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousedown", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousemove", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseup", this.listener, false);
            this.listener = null;
        }
        if (this.imgDocument != null) {
            SVGSVGElement svgElement = this.imgDocument.getRootElement();
            SVGImageElementBridge.disposeTree((Node)svgElement);
        }
        this.imgDocument = null;
        this.subCtx = null;
        GraphicsNode inode = this.buildImageGraphicsNode(this.ctx, this.e);
        ImageNode imgNode = (ImageNode)this.node;
        imgNode.setImage(inode);
        if (inode == null) {
            SVGImageElement ie = (SVGImageElement)this.e;
            String uriStr = ie.getHref().getAnimVal();
            throw new BridgeException(this.ctx, this.e, "uri.image.invalid", new Object[]{uriStr});
        }
    }

    @Override
    protected void handleCSSPropertyChanged(int property2) {
        switch (property2) {
            case 6: 
            case 30: {
                RenderingHints hints = CSSUtilities.convertImageRendering(this.e, null);
                hints = CSSUtilities.convertColorRendering(this.e, hints);
                if (hints == null) break;
                this.node.setRenderingHints(hints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(property2);
            }
        }
    }

    protected GraphicsNode createRasterImageNode(BridgeContext ctx2, Element e, Filter img, ParsedURL purl) {
        Rectangle2D bounds = SVGImageElementBridge.getImageBounds(ctx2, e);
        if (bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
            ShapeNode sn = new ShapeNode();
            sn.setShape(bounds);
            return sn;
        }
        if (BrokenLinkProvider.hasBrokenLinkProperty(img)) {
            Object o = img.getProperty("org.jetbrains.relocated.apache.batik.BrokenLinkImage");
            String msg = "unknown";
            if (o instanceof String) {
                msg = (String)o;
            }
            SVGDocument doc = ctx2.getUserAgent().getBrokenLinkDocument(e, purl.toString(), msg);
            return this.createSVGImageNode(ctx2, e, doc);
        }
        RasterImageNode node = new RasterImageNode();
        node.setImage(img);
        Rectangle2D imgBounds = img.getBounds2D();
        float[] vb = new float[]{0.0f, 0.0f, (float)imgBounds.getWidth(), (float)imgBounds.getHeight()};
        SVGImageElementBridge.initializeViewport(ctx2, e, node, vb, bounds);
        return node;
    }

    protected GraphicsNode createSVGImageNode(BridgeContext ctx2, Element e, SVGDocument imgDocument) {
        CSSEngine eng = ((SVGOMDocument)imgDocument).getCSSEngine();
        this.subCtx = ctx2.createSubBridgeContext((SVGOMDocument)imgDocument);
        CompositeGraphicsNode result2 = new CompositeGraphicsNode();
        Rectangle2D bounds = SVGImageElementBridge.getImageBounds(ctx2, e);
        if (bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
            ShapeNode sn = new ShapeNode();
            sn.setShape(bounds);
            result2.getChildren().add(sn);
            return result2;
        }
        Rectangle2D r = CSSUtilities.convertEnableBackground(e);
        if (r != null) {
            result2.setBackgroundEnable(r);
        }
        SVGSVGElement svgElement = imgDocument.getRootElement();
        CanvasGraphicsNode node = (CanvasGraphicsNode)this.subCtx.getGVTBuilder().build(this.subCtx, (Element)svgElement);
        if (eng == null && ctx2.isInteractive()) {
            this.subCtx.addUIEventListeners((Document)imgDocument);
        }
        node.setClip(null);
        node.setViewingTransform(new AffineTransform());
        result2.getChildren().add(node);
        String viewBox = svgElement.getAttributeNS(null, "viewBox");
        float[] vb = ViewBox.parseViewBoxAttribute(e, viewBox, ctx2);
        SVGImageElementBridge.initializeViewport(ctx2, e, result2, vb, bounds);
        if (ctx2.isInteractive()) {
            this.listener = new ForwardEventListener((Element)svgElement, e);
            NodeEventTarget tgt = (NodeEventTarget)svgElement;
            tgt.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.listener, false, null);
            this.subCtx.storeEventListenerNS(tgt, "http://www.w3.org/2001/xml-events", "click", this.listener, false);
            tgt.addEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this.listener, false, null);
            this.subCtx.storeEventListenerNS(tgt, "http://www.w3.org/2001/xml-events", "keydown", this.listener, false);
            tgt.addEventListenerNS("http://www.w3.org/2001/xml-events", "keypress", this.listener, false, null);
            this.subCtx.storeEventListenerNS(tgt, "http://www.w3.org/2001/xml-events", "keypress", this.listener, false);
            tgt.addEventListenerNS("http://www.w3.org/2001/xml-events", "keyup", this.listener, false, null);
            this.subCtx.storeEventListenerNS(tgt, "http://www.w3.org/2001/xml-events", "keyup", this.listener, false);
            tgt.addEventListenerNS("http://www.w3.org/2001/xml-events", "mousedown", this.listener, false, null);
            this.subCtx.storeEventListenerNS(tgt, "http://www.w3.org/2001/xml-events", "mousedown", this.listener, false);
            tgt.addEventListenerNS("http://www.w3.org/2001/xml-events", "mousemove", this.listener, false, null);
            this.subCtx.storeEventListenerNS(tgt, "http://www.w3.org/2001/xml-events", "mousemove", this.listener, false);
            tgt.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.listener, false, null);
            this.subCtx.storeEventListenerNS(tgt, "http://www.w3.org/2001/xml-events", "mouseout", this.listener, false);
            tgt.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.listener, false, null);
            this.subCtx.storeEventListenerNS(tgt, "http://www.w3.org/2001/xml-events", "mouseover", this.listener, false);
            tgt.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseup", this.listener, false, null);
            this.subCtx.storeEventListenerNS(tgt, "http://www.w3.org/2001/xml-events", "mouseup", this.listener, false);
        }
        return result2;
    }

    @Override
    public void dispose() {
        if (this.imgDocument != null && this.listener != null) {
            NodeEventTarget tgt = (NodeEventTarget)this.imgDocument.getRootElement();
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keypress", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keyup", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousedown", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousemove", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.listener, false);
            tgt.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseup", this.listener, false);
            this.listener = null;
        }
        if (this.imgDocument != null) {
            SVGSVGElement svgElement = this.imgDocument.getRootElement();
            SVGImageElementBridge.disposeTree((Node)svgElement);
            this.imgDocument = null;
            this.subCtx = null;
        }
        super.dispose();
    }

    protected static void initializeViewport(BridgeContext ctx2, Element e, GraphicsNode node, float[] vb, Rectangle2D bounds) {
        float x2 = (float)bounds.getX();
        float y2 = (float)bounds.getY();
        float w = (float)bounds.getWidth();
        float h = (float)bounds.getHeight();
        try {
            SVGImageElement ie = (SVGImageElement)e;
            SVGOMAnimatedPreserveAspectRatio _par = (SVGOMAnimatedPreserveAspectRatio)ie.getPreserveAspectRatio();
            _par.check();
            AffineTransform at = ViewBox.getPreserveAspectRatioTransform(e, vb, w, h, _par, ctx2);
            at.preConcatenate(AffineTransform.getTranslateInstance(x2, y2));
            node.setTransform(at);
            Shape clip = null;
            if (CSSUtilities.convertOverflow(e)) {
                float[] offsets = CSSUtilities.convertClip(e);
                clip = offsets == null ? new Rectangle2D.Float(x2, y2, w, h) : new Rectangle2D.Float(x2 + offsets[3], y2 + offsets[0], w - offsets[1] - offsets[3], h - offsets[2] - offsets[0]);
            }
            if (clip != null) {
                try {
                    at = at.createInverse();
                    Filter filter2 = node.getGraphicsNodeRable(true);
                    clip = at.createTransformedShape(clip);
                    node.setClip(new ClipRable8Bit(filter2, clip));
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {}
            }
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx2, ex);
        }
    }

    protected static ICCColorSpaceWithIntent extractColorSpace(Element element, BridgeContext ctx2) {
        SVGColorProfileElementBridge profileBridge;
        String colorProfileProperty = CSSUtilities.getComputedStyle(element, 8).getStringValue();
        ICCColorSpaceWithIntent colorSpace = null;
        if ("srgb".equalsIgnoreCase(colorProfileProperty)) {
            colorSpace = new ICCColorSpaceWithIntent(ICC_Profile.getInstance(1000), RenderingIntent.AUTO, "sRGB", null);
        } else if (!"auto".equalsIgnoreCase(colorProfileProperty) && !"".equalsIgnoreCase(colorProfileProperty) && (profileBridge = (SVGColorProfileElementBridge)ctx2.getBridge("http://www.w3.org/2000/svg", "color-profile")) != null) {
            colorSpace = profileBridge.createICCColorSpaceWithIntent(ctx2, element, colorProfileProperty);
        }
        return colorSpace;
    }

    protected static Rectangle2D getImageBounds(BridgeContext ctx2, Element element) {
        try {
            SVGImageElement ie = (SVGImageElement)element;
            AbstractSVGAnimatedLength _x = (AbstractSVGAnimatedLength)ie.getX();
            float x2 = _x.getCheckedValue();
            AbstractSVGAnimatedLength _y = (AbstractSVGAnimatedLength)ie.getY();
            float y2 = _y.getCheckedValue();
            AbstractSVGAnimatedLength _width = (AbstractSVGAnimatedLength)ie.getWidth();
            float w = _width.getCheckedValue();
            AbstractSVGAnimatedLength _height = (AbstractSVGAnimatedLength)ie.getHeight();
            float h = _height.getCheckedValue();
            return new Rectangle2D.Float(x2, y2, w, h);
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx2, ex);
        }
    }

    GraphicsNode createBrokenImageNode(BridgeContext ctx2, Element e, String uri, String message) {
        SVGDocument doc = ctx2.getUserAgent().getBrokenLinkDocument(e, uri, Messages.formatMessage("uri.image.error", new Object[]{message}));
        return this.createSVGImageNode(ctx2, e, doc);
    }

    static {
        ImageTagRegistry.setBrokenLinkProvider(brokenLinkProvider);
    }

    protected static class ForwardEventListener
    implements EventListener {
        protected Element svgElement;
        protected Element imgElement;

        public ForwardEventListener(Element svgElement, Element imgElement) {
            this.svgElement = svgElement;
            this.imgElement = imgElement;
        }

        @Override
        public void handleEvent(Event e) {
            DOMMouseEvent evt = (DOMMouseEvent)e;
            DOMMouseEvent newMouseEvent = (DOMMouseEvent)((DocumentEvent)((Object)this.imgElement.getOwnerDocument())).createEvent("MouseEvents");
            newMouseEvent.initMouseEventNS("http://www.w3.org/2001/xml-events", evt.getType(), evt.getBubbles(), evt.getCancelable(), evt.getView(), evt.getDetail(), evt.getScreenX(), evt.getScreenY(), evt.getClientX(), evt.getClientY(), evt.getButton(), (EventTarget)((Object)this.imgElement), evt.getModifiersString());
            ((EventTarget)((Object)this.imgElement)).dispatchEvent(newMouseEvent);
        }
    }

    public static class ProtectedStream
    extends BufferedInputStream {
        static final int BUFFER_SIZE = 8192;
        boolean wasClosed = false;
        boolean isTied = false;

        ProtectedStream(InputStream is) {
            super(is, 8192);
            super.mark(8192);
        }

        ProtectedStream(InputStream is, int size2) {
            super(is, size2);
            super.mark(size2);
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int sz) {
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("Reset unsupported");
        }

        public synchronized void retry() throws IOException {
            super.reset();
            this.wasClosed = false;
            this.isTied = false;
        }

        @Override
        public synchronized void close() throws IOException {
            this.wasClosed = true;
            if (this.isTied) {
                super.close();
            }
        }

        public synchronized void tie() throws IOException {
            this.isTied = true;
            if (this.wasClosed) {
                super.close();
            }
        }

        public void release() {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

