/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.override;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.override.PyMethodMember;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyOverrideImplementUtil {
    @Nullable
    public static PyClass getContextClass(@NotNull Editor editor2, @NotNull PsiFile file) {
        PyClass pyClass;
        PsiElement lastChild;
        int offset;
        PsiElement element;
        if (editor2 == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(1);
        }
        if ((element = file.findElementAt(offset = editor2.getCaretModel().getOffset())) == null && (lastChild = file.getLastChild()) != null && offset >= lastChild.getTextRange().getStartOffset() && offset <= lastChild.getTextRange().getEndOffset()) {
            element = lastChild;
        }
        if ((pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false)) == null && element instanceof PsiWhiteSpace && element.getPrevSibling() instanceof PyClass) {
            return (PyClass)element.getPrevSibling();
        }
        return pyClass;
    }

    public static void chooseAndOverrideMethods(@NotNull Project project, @NotNull Editor editor2, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(3);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(5);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        PyPsiUtils.assertValid(cls);
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor2, cls, PyPsiRefactoringUtil.getAllSuperMethods(cls, context), false);
    }

    public static void chooseAndImplementMethods(@NotNull Project project, @NotNull Editor editor2, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(7);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(9);
        }
        PyOverrideImplementUtil.chooseAndImplementMethods(project, editor2, cls, PyPsiRefactoringUtil.getAllSuperAbstractMethods(cls, context));
    }

    public static void chooseAndImplementMethods(@NotNull Project project, @NotNull Editor editor2, @NotNull PyClass cls, @NotNull Collection<PyFunction> methods) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(10);
        }
        if (editor2 == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(11);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(12);
        }
        if (methods == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(13);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        PyPsiUtils.assertValid(cls);
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor2, cls, methods, true);
    }

    private static void chooseAndOverrideOrImplementMethods(@NotNull Project project, @NotNull Editor editor2, @NotNull PyClass cls, @NotNull Collection<PyFunction> methods, boolean implement) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(14);
        }
        if (editor2 == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(15);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(16);
        }
        if (methods == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(17);
        }
        ArrayList<PyMethodMember> elements = new ArrayList<PyMethodMember>();
        for (PyFunction method : methods) {
            String name2 = method.getName();
            if (name2 == null || PyUtil.isClassPrivateName(name2) || cls.findMethodByName(name2, false, null) != null) continue;
            PyMethodMember member = new PyMethodMember(method);
            elements.add(member);
        }
        if (elements.isEmpty()) {
            return;
        }
        MemberChooser chooser = new MemberChooser((ClassMember[])elements.toArray(new PyMethodMember[0]), false, true, project);
        chooser.setTitle(implement ? PyBundle.message("code.insight.select.methods.to.implement", new Object[0]) : PyBundle.message("code.insight.select.methods.to.override", new Object[0]));
        chooser.setCopyJavadocVisible(false);
        chooser.show();
        if (chooser.getExitCode() != 0) {
            return;
        }
        PyOverrideImplementUtil.overrideMethods(editor2, cls, chooser.getSelectedElements(), implement);
    }

    public static void overrideMethods(Editor editor2, PyClass pyClass, List<PyMethodMember> membersToOverride, boolean implement) {
        if (membersToOverride == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)pyClass.getProject(), (PsiFile[])new PsiFile[]{pyClass.getContainingFile()}).run(() -> PyOverrideImplementUtil.write(pyClass, membersToOverride, editor2, implement));
    }

    private static void write(@NotNull PyClass pyClass, @NotNull List<PyMethodMember> newMembers, @NotNull Editor editor2, boolean implement) {
        if (pyClass == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(18);
        }
        if (newMembers == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(19);
        }
        if (editor2 == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(20);
        }
        PyStatementList statementList = pyClass.getStatementList();
        int offset = editor2.getCaretModel().getOffset();
        PyStatement anchor = null;
        for (PyStatement statement : statementList.getStatements()) {
            if (statement.getTextRange().getStartOffset() >= offset && (!(statement instanceof PyExpressionStatement) || !(((PyExpressionStatement)statement).getExpression() instanceof PyStringLiteralExpression))) continue;
            anchor = statement;
        }
        PyFunction element = null;
        for (PyMethodMember newMember : Lists.reverse(newMembers)) {
            element = PyOverrideImplementUtil.writeMember(pyClass, (PyFunction)newMember.getPsiElement(), (PsiElement)anchor, implement);
        }
        PyPsiUtils.removeRedundantPass(statementList);
        if (element != null) {
            PyStatementList targetStatementList = element.getStatementList();
            int start = targetStatementList.getTextRange().getStartOffset();
            editor2.getCaretModel().moveToOffset(start);
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor2.getSelectionModel().setSelection(start, element.getTextRange().getEndOffset());
        }
    }

    @Nullable
    private static PyFunction writeMember(@NotNull PyClass cls, @NotNull PyFunction baseFunction, @Nullable PsiElement anchor, boolean implement) {
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(21);
        }
        if (baseFunction == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(22);
        }
        PyStatementList statementList = cls.getStatementList();
        TypeEvalContext context = TypeEvalContext.userInitiated(cls.getProject(), cls.getContainingFile());
        PyFunction function = PyOverrideImplementUtil.buildOverriddenFunction(cls, baseFunction, implement).addFunctionAfter((PsiElement)statementList, anchor);
        PyClassRefactoringUtil.transplantImportsFromSignature(baseFunction, function);
        PyiUtil.getOverloads(baseFunction, context).forEach(baseOverload -> {
            PyFunction overload = (PyFunction)statementList.addBefore((PsiElement)baseOverload, function);
            PyClassRefactoringUtil.transplantImportsFromSignature(baseOverload, overload);
        });
        return (PyFunction)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)function);
    }

    private static PyFunctionBuilder buildOverriddenFunction(PyClass pyClass, PyFunction baseFunction, boolean implement) {
        String functionName = baseFunction.getName();
        boolean overridingNew = "__new__".equals(functionName);
        assert (functionName != null);
        PyFunctionBuilder pyFunctionBuilder = new PyFunctionBuilder(functionName, baseFunction);
        PyDecoratorList decorators = baseFunction.getDecoratorList();
        boolean baseMethodIsStatic = false;
        boolean isProperty = false;
        if (decorators != null) {
            if (decorators.findDecorator("classmethod") != null) {
                pyFunctionBuilder.decorate("classmethod");
            } else if (decorators.findDecorator("staticmethod") != null) {
                baseMethodIsStatic = true;
                pyFunctionBuilder.decorate("staticmethod");
            } else if (decorators.findDecorator("property") != null || decorators.findDecorator("abstractproperty") != null) {
                isProperty = true;
                pyFunctionBuilder.decorate("property");
            }
        }
        PyAnnotation anno = baseFunction.getAnnotation();
        boolean copyAnnotations = PyPsiRefactoringUtil.shouldCopyAnnotations(baseFunction, pyClass.getContainingFile());
        if (anno != null && copyAnnotations) {
            pyFunctionBuilder.annotation(anno.getText());
        }
        if (baseFunction.isAsync()) {
            pyFunctionBuilder.makeAsync();
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(baseFunction.getProject(), baseFunction.getContainingFile());
        List baseParams = baseFunction.getParameters(context);
        for (PyCallableParameter parameter : baseParams) {
            PyParameter psi = parameter.getParameter();
            PyNamedParameter namedParameter = PyUtil.as(psi, PyNamedParameter.class);
            if (namedParameter != null) {
                PyExpression defaultValue;
                StringBuilder parameterBuilder = new StringBuilder();
                parameterBuilder.append(ParamHelper.getNameInSignature(namedParameter));
                PyAnnotation annotation = namedParameter.getAnnotation();
                if (annotation != null && copyAnnotations) {
                    parameterBuilder.append(annotation.getText());
                }
                if ((defaultValue = namedParameter.getDefaultValue()) != null) {
                    parameterBuilder.append("=");
                    parameterBuilder.append(defaultValue.getText());
                }
                pyFunctionBuilder.parameter(parameterBuilder.toString());
                continue;
            }
            if (psi == null) continue;
            pyFunctionBuilder.parameter(psi.getText());
        }
        PyClass baseClass = baseFunction.getContainingClass();
        assert (baseClass != null);
        StringBuilder statementBody = new StringBuilder();
        boolean hadStar = false;
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (PyCallableParameter parameter : baseParams) {
            PyParameter psi = parameter.getParameter();
            PyNamedParameter namedParameter = PyUtil.as(psi, PyNamedParameter.class);
            if (namedParameter != null) {
                String repr = namedParameter.getRepr(false);
                parameters.add(hadStar && !namedParameter.isKeywordContainer() ? namedParameter.getName() + "=" + repr : repr);
                if (!namedParameter.isPositionalContainer()) continue;
                hadStar = true;
                continue;
            }
            if (psi instanceof PySingleStarParameter) {
                hadStar = true;
                continue;
            }
            if (psi == null || psi instanceof PySlashParameter) continue;
            parameters.add(psi.getText());
        }
        if (implement || baseFunction.onlyRaisesNotImplementedError() || PyKnownDecoratorUtil.hasAbstractDecorator(baseFunction, context)) {
            statementBody.append("pass");
        } else {
            if (!"__init__".equals(functionName) && context.getReturnType(baseFunction) != PyNoneType.INSTANCE || overridingNew || isProperty) {
                statementBody.append("return ");
            }
            if (baseFunction.isAsync()) {
                statementBody.append("await");
                statementBody.append(" ");
            }
            if (baseClass.isNewStyleClass(context)) {
                statementBody.append("super");
                statementBody.append("(");
                LanguageLevel langLevel = ((PyFile)pyClass.getContainingFile()).getLanguageLevel();
                if (langLevel.isPython2()) {
                    String baseFirstName = !baseParams.isEmpty() ? ((PyCallableParameter)baseParams.get(0)).getName() : null;
                    String firstName = baseFirstName != null ? baseFirstName : "self";
                    PyClass outerClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)pyClass, PyClass.class, (boolean)true, (Class[])new Class[]{PyFunction.class});
                    String className = pyClass.getName();
                    ArrayList nameResult = Lists.newArrayList((Object[])new String[]{className});
                    while (outerClass != null) {
                        nameResult.add(0, outerClass.getName());
                        outerClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)outerClass, PyClass.class, (boolean)true, (Class[])new Class[]{PyFunction.class});
                    }
                    StringUtil.join((Collection)nameResult, (String)".", (StringBuilder)statementBody);
                    statementBody.append(", ").append(firstName);
                }
                statementBody.append(").").append(functionName);
                if (!(parameters.isEmpty() || baseMethodIsStatic || overridingNew)) {
                    parameters.remove(0);
                }
            } else {
                statementBody.append(PyOverrideImplementUtil.getReferenceText(pyClass, baseClass)).append(".").append(functionName);
            }
            if (!isProperty) {
                statementBody.append("(");
                StringUtil.join(parameters, (String)", ", (StringBuilder)statementBody);
                statementBody.append(")");
            }
        }
        pyFunctionBuilder.statement(statementBody.toString());
        return pyFunctionBuilder;
    }

    private static String getReferenceText(PyClass fromClass, PyClass toClass) {
        PyExpression[] superClassExpressions;
        for (PyExpression expression : superClassExpressions = fromClass.getSuperClassExpressions()) {
            PsiElement target;
            if (!(expression instanceof PyReferenceExpression) || (target = ((PyReferenceExpression)expression).getReference().resolve()) != toClass) continue;
            return expression.getText();
        }
        return toClass.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMembers";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFunction";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseAndOverrideMethods";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseAndImplementMethods";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseAndOverrideOrImplementMethods";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "writeMember";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

