/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class RedundantParenthesesQuickFix
extends PsiUpdateModCommandQuickFix {
    private static final Logger LOG = Logger.getInstance(RedundantParenthesesQuickFix.class);

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.redundant.parentheses", new Object[0]);
        if (string == null) {
            RedundantParenthesesQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            RedundantParenthesesQuickFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            RedundantParenthesesQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            RedundantParenthesesQuickFix.$$$reportNull$$$0(3);
        }
        if (element instanceof PyParenthesizedExpression) {
            PyExpression binaryExpression = ((PyParenthesizedExpression)element).getContainedExpression();
            PyBinaryExpression parent = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyBinaryExpression.class);
            if (binaryExpression instanceof PyBinaryExpression && parent != null) {
                if (!RedundantParenthesesQuickFix.replaceBinaryExpression((PyBinaryExpression)binaryExpression)) {
                    element.replace((PsiElement)binaryExpression);
                }
            } else {
                PyExpression content2 = PyPsiUtils.flattenParens((PyParenthesizedExpression)element);
                if (content2 != null) {
                    element.replace((PsiElement)content2);
                }
            }
        } else if (element instanceof PyArgumentList) {
            LOG.assertTrue(element.getParent() instanceof PyClass, (Object)("Parent type: " + String.valueOf(element.getParent().getClass())));
            LOG.assertTrue(((PyArgumentList)element).getArguments().length == 0, (Object)("Argument list: " + element.getText()));
            ASTNode nameNode = ((PyClass)PyElementGenerator.getInstance(project).createFromText(LanguageLevel.forElement((PsiElement)element), PyClass.class, "class A: pass")).getNameNode();
            if (nameNode != null) {
                PsiElement emptyArgList = nameNode.getPsi().getNextSibling();
                element.replace(emptyArgList);
            } else {
                element.delete();
            }
        }
    }

    private static boolean replaceBinaryExpression(PyBinaryExpression element) {
        PyExpression left = element.getLeftExpression();
        PyExpression right = element.getRightExpression();
        if (left instanceof PyParenthesizedExpression && right instanceof PyParenthesizedExpression) {
            PyExpression leftContained = ((PyParenthesizedExpression)left).getContainedExpression();
            PyExpression rightContained = ((PyParenthesizedExpression)right).getContainedExpression();
            if (leftContained != null && rightContained != null && !(leftContained instanceof PyTupleExpression) && !(rightContained instanceof PyTupleExpression)) {
                left.replace((PsiElement)leftContained);
                right.replace((PsiElement)rightContained);
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/RedundantParenthesesQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/RedundantParenthesesQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

