/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.Language;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportedModule
extends LightElement
implements PyTypedElement {
    @Nullable
    private final PyImportElement myImportElement;
    @NotNull
    private final PyFile myContainingFile;
    @NotNull
    private final QualifiedName myImportedPrefix;

    public PyImportedModule(@Nullable PyImportElement importElement, @NotNull PyFile containingFile, @NotNull QualifiedName importedPrefix) {
        if (containingFile == null) {
            PyImportedModule.$$$reportNull$$$0(0);
        }
        if (importedPrefix == null) {
            PyImportedModule.$$$reportNull$$$0(1);
        }
        super(containingFile.getManager(), (Language)PythonLanguage.getInstance());
        this.myImportElement = importElement;
        this.myContainingFile = containingFile;
        this.myImportedPrefix = importedPrefix;
    }

    @NotNull
    public PyFile getContainingFile() {
        PyFile pyFile = this.myContainingFile;
        if (pyFile == null) {
            PyImportedModule.$$$reportNull$$$0(2);
        }
        return pyFile;
    }

    @NotNull
    public QualifiedName getImportedPrefix() {
        QualifiedName qualifiedName = this.myImportedPrefix;
        if (qualifiedName == null) {
            PyImportedModule.$$$reportNull$$$0(3);
        }
        return qualifiedName;
    }

    public String getText() {
        return "import " + String.valueOf(this.myImportedPrefix);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PyImportedModule.$$$reportNull$$$0(4);
        }
        super.accept(visitor2);
    }

    public PsiElement copy() {
        return new PyImportedModule(this.myImportElement, this.myContainingFile, this.myImportedPrefix);
    }

    public String toString() {
        return "PyImportedModule:" + String.valueOf(this.myImportedPrefix);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement element;
        if (this.myImportElement != null && (element = PyImportedModule.resolve(this.myImportElement, this.myImportedPrefix)) != null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                PyImportedModule.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        PsiElement psiElement = super.getNavigationElement();
        if (psiElement == null) {
            PyImportedModule.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public boolean isValid() {
        return (this.myImportElement == null || this.myImportElement.isValid()) && this.myContainingFile.isValid();
    }

    @Nullable
    public PyImportElement getImportElement() {
        return this.myImportElement;
    }

    @Deprecated
    public PsiElement resolve() {
        return this.multiResolve().stream().findFirst().map(res -> res.getElement()).orElse(null);
    }

    @NotNull
    public List<RatedResolveResult> multiResolve() {
        ResolveResultList results;
        if (this.myImportElement != null) {
            results = ResolveImportUtil.multiResolveImportElement(this.myImportElement, this.myImportedPrefix);
        } else {
            ResolveResultList resList = new ResolveResultList();
            ResolveImportUtil.multiResolveModuleInRoots(this.myImportedPrefix, (PsiElement)this.myContainingFile).forEach(res -> resList.poke((PsiElement)res, 0));
            results = resList;
        }
        List list = ContainerUtil.map(results, this::tryReplaceDirWithPackage);
        if (list == null) {
            PyImportedModule.$$$reportNull$$$0(7);
        }
        return list;
    }

    private RatedResolveResult tryReplaceDirWithPackage(RatedResolveResult el) {
        PsiElement element = el.getElement();
        return element instanceof PsiDirectory ? el.replace(PyUtil.getPackageElement((PsiDirectory)element, (PsiElement)this)) : el;
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyImportedModule.$$$reportNull$$$0(8);
        }
        if (key == null) {
            PyImportedModule.$$$reportNull$$$0(9);
        }
        return new PyImportedModuleType(this);
    }

    @Nullable
    private static PsiElement resolve(PyImportElement importElement, @NotNull QualifiedName prefix) {
        PsiElement resolved;
        PsiElement packageInit;
        if (prefix == null) {
            PyImportedModule.$$$reportNull$$$0(10);
        }
        return (packageInit = PyUtil.turnDirIntoInit(resolved = ResolveImportUtil.resolveImportElement(importElement, prefix))) != null ? packageInit : resolved;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyImportedModule module = (PyImportedModule)o;
        return Objects.equals(this.myImportElement, module.myImportElement) && Objects.equals(this.myContainingFile, module.myContainingFile) && Objects.equals(this.myImportedPrefix, module.myImportedPrefix);
    }

    public int hashCode() {
        return Objects.hash(this.myImportElement, this.myContainingFile, this.myImportedPrefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedPrefix";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyImportedModule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyImportedModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedPrefix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

