/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.search.PySearchScopeBuilder;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySearchUtilBase {
    @NotNull
    public static GlobalSearchScope defaultSuggestionScope(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PySearchUtilBase.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = PySearchScopeBuilder.forPythonSdkOf(anchor).excludeStandardLibraryTests().excludePythonSkeletonsStubs().excludeThirdPartyPackageTests().excludeThirdPartyPackageBundledDependencies().build();
        if (globalSearchScope == null) {
            PySearchUtilBase.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope excludeSdkTestsScope(@NotNull Project project) {
        if (project == null) {
            PySearchUtilBase.$$$reportNull$$$0(2);
        }
        return PySearchUtilBase.excludeSdkTestScope(ProjectScope.getAllScope((Project)project));
    }

    @NotNull
    public static GlobalSearchScope excludeSdkTestScope(@NotNull GlobalSearchScope scope) {
        Project project;
        Sdk sdk2;
        if (scope == null) {
            PySearchUtilBase.$$$reportNull$$$0(3);
        }
        if ((sdk2 = ProjectRootManager.getInstance((Project)(project = Objects.requireNonNull(scope.getProject()))).getProjectSdk()) != null && PythonSdkUtil.isPythonSdk(sdk2)) {
            GlobalSearchScope globalSearchScope = scope.intersectWith(PySearchScopeBuilder.forPythonSdk(project, sdk2).excludeStandardLibraryTests().build());
            if (globalSearchScope == null) {
                PySearchUtilBase.$$$reportNull$$$0(4);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            PySearchUtilBase.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    @Nullable
    public static VirtualFile findLibDir(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PySearchUtilBase.$$$reportNull$$$0(6);
        }
        return PySearchUtilBase.findLibDir((VirtualFile[])ReadAction.compute(() -> sdk2.getRootProvider().getFiles(OrderRootType.CLASSES)));
    }

    public static VirtualFile findVirtualEnvLibDir(@NotNull Sdk sdk2) {
        File root;
        if (sdk2 == null) {
            PySearchUtilBase.$$$reportNull$$$0(7);
        }
        VirtualFile[] classVFiles = (VirtualFile[])ReadAction.compute(() -> sdk2.getRootProvider().getFiles(OrderRootType.CLASSES));
        String homePath = sdk2.getHomePath();
        if (homePath != null && (root = PythonSdkUtil.getVirtualEnvRoot(homePath)) != null) {
            File versionRoot;
            File libRoot = new File(root, "lib");
            Object[] versionRoots = libRoot.listFiles();
            if (versionRoots != null && !SystemInfo.isWindows && (versionRoot = (File)ContainerUtil.find((Object[])versionRoots, file -> file.isDirectory() && file.getName().startsWith("python"))) != null) {
                libRoot = versionRoot;
            }
            if (classVFiles.length == 0) {
                return LocalFileSystem.getInstance().findFileByIoFile(libRoot);
            }
            String libRootPath = libRoot.getPath();
            for (VirtualFile file2 : classVFiles) {
                if (FileUtil.pathsEqual((String)file2.getPath(), (String)libRootPath)) {
                    return file2;
                }
                VirtualFile parent = file2.getParent();
                if (!"site-packages".equals(file2.getName()) || !FileUtil.pathsEqual((String)parent.getPath(), (String)libRootPath)) continue;
                return parent;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findLibDir(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!file.isValid()) continue;
            if ((file.findChild("__future__.py") != null || file.findChild("__future__.pyc") != null) && file.findChild("xml") != null && file.findChild("email") != null) {
                return file;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode() || !file.getName().equals("Lib")) continue;
            return file;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/search/PySearchUtilBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/search/PySearchUtilBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultSuggestionScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeSdkTestScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "defaultSuggestionScope";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "excludeSdkTestsScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "excludeSdkTestScope";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLibDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualEnvLibDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }
}

