/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslMacroPathConverter;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.FwTaskRunner;
import com.intellij.plugins.watcher.TaskProblemsHolder;
import com.intellij.plugins.watcher.TaskRunner;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.BackgroundTaskFilterFactory;
import com.intellij.plugins.watcher.config.FileDependencyFinder;
import com.intellij.plugins.watcher.config.FileTypeBackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.OutputFilesHandler;
import com.intellij.plugins.watcher.config.WatchersConfigurable;
import com.intellij.plugins.watcher.config.ui.NewWatcherDialog;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.problems.TaskProblemDescription;
import com.intellij.plugins.watcher.problems.TaskProblemFinder;
import com.intellij.plugins.watcher.util.HistoryProcessListener;
import com.intellij.plugins.watcher.util.TaskUtils;
import com.intellij.plugins.watcher.util.WatchedFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.tools.Tool;
import com.intellij.util.Alarm;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public final class TaskRunnerImpl
extends TaskRunner {
    private static final Logger LOG = Logger.getInstance(TaskRunner.class);
    private static final Key<Pair<String, String>> TASK_NAME_AND_FILE_PATH_KEY = Key.create((String)"task.name.and.file.path.key");
    private static final int MAX_RUNNING_JOBS = 10;
    private static final int FILE_INDEPENDENT_WATCHER_DELAY = 1000;
    private final ConcurrentMap<VirtualFile, Pair<DataContext, List<TaskOptions>>> jobsInProgress;
    private final ConcurrentLinkedQueue<Pair<DataContext, List<TaskOptions>>> jobsInQueue;
    private final TaskProblemsHolder myProblemsHolder;
    private final Set<String> myFilesInRefreshState;
    private final Alarm myTasksScheduler;
    private final Map<List<TaskOptions>, Runnable> myFileIndependentTasksToRunnableMap;
    private final AtomicInteger myPendingRefreshes;
    private volatile boolean myBatchFileChangeInProgress;
    private final Project myProject;

    public TaskRunnerImpl(@NotNull Project project) {
        if (project == null) {
            TaskRunnerImpl.$$$reportNull$$$0(0);
        }
        this.jobsInProgress = new ConcurrentHashMap<VirtualFile, Pair<DataContext, List<TaskOptions>>>();
        this.jobsInQueue = new ConcurrentLinkedQueue();
        this.myProblemsHolder = new TaskProblemsHolder();
        this.myFilesInRefreshState = ConcurrentCollectionFactory.createConcurrentSet();
        this.myTasksScheduler = new Alarm(ApplicationManager.getApplication().isUnitTestMode() ? Alarm.ThreadToUse.SWING_THREAD : Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myFileIndependentTasksToRunnableMap = Collections.synchronizedMap(new HashMap());
        this.myPendingRefreshes = new AtomicInteger(0);
        this.myProject = project;
    }

    @Override
    public TaskProblemsHolder getProblemsHolder() {
        return this.myProblemsHolder;
    }

    @Override
    public boolean inRefreshState(@NotNull String fileUrl) {
        if (fileUrl == null) {
            TaskRunnerImpl.$$$reportNull$$$0(1);
        }
        return this.myFilesInRefreshState.contains(fileUrl);
    }

    @Override
    public void runTasksForFile(DataContext mainDataContext, @NotNull List<? extends TaskOptions> allOptions) {
        if (allOptions == null) {
            TaskRunnerImpl.$$$reportNull$$$0(2);
        }
        ArrayList<TaskOptions> fileSpecificOptions = new ArrayList<TaskOptions>(allOptions.size());
        ArrayList<TaskOptions> fileIndependentOptions = new ArrayList<TaskOptions>(allOptions.size());
        for (TaskOptions taskOptions : allOptions) {
            if (TaskRunnerImpl.dependOnFile(taskOptions)) {
                fileSpecificOptions.add(taskOptions);
                continue;
            }
            fileIndependentOptions.add(taskOptions);
        }
        if (!fileIndependentOptions.isEmpty()) {
            Runnable oldRunnable = this.myFileIndependentTasksToRunnableMap.remove(fileIndependentOptions);
            if (oldRunnable != null) {
                this.myTasksScheduler.cancelRequest(oldRunnable);
            }
            Runnable runnable = () -> {
                this.myFileIndependentTasksToRunnableMap.remove(fileIndependentOptions);
                this.doRunTasksForFile(mainDataContext, fileIndependentOptions);
            };
            this.myFileIndependentTasksToRunnableMap.put(fileIndependentOptions, runnable);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.myTasksScheduler.addRequest(runnable, 1000);
            } else {
                runnable.run();
            }
        }
        if (!fileSpecificOptions.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.myTasksScheduler.addRequest(() -> this.doRunTasksForFile(mainDataContext, fileSpecificOptions), 0);
            } else {
                this.doRunTasksForFile(mainDataContext, fileSpecificOptions);
            }
        }
    }

    @Override
    public boolean isBusy() {
        return !this.myTasksScheduler.isEmpty() || !this.jobsInProgress.isEmpty() || !this.jobsInQueue.isEmpty() || this.myPendingRefreshes.get() > 0;
    }

    private void doRunTasksForFile(DataContext mainDataContext, List<? extends TaskOptions> allOptions) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(mainDataContext);
        LOG.assertTrue(project == this.myProject);
        VirtualFile initialFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(mainDataContext);
        if (initialFile == null || !initialFile.isValid()) {
            return;
        }
        LOG.debug(this.jobsInProgress.size() + " jobs are running at the moment.");
        Map<VirtualFile, List<TaskOptions>> data = TaskRunnerImpl.computeFilesAndTasksToPerform(this.myProject, initialFile, allOptions);
        for (Map.Entry<VirtualFile, List<TaskOptions>> entry : data.entrySet()) {
            VirtualFile file = entry.getKey();
            List<TaskOptions> options = entry.getValue();
            DataContext dataContext = SimpleDataContext.getSimpleContext((DataKey)CommonDataKeys.VIRTUAL_FILE, (Object)file, (DataContext)mainDataContext);
            Pair job = Pair.create((Object)dataContext, options);
            if (this.myBatchFileChangeInProgress || this.jobsInProgress.size() >= 10) {
                LOG.debug("Suspend " + file.getName());
                this.jobsInQueue.add((Pair<DataContext, List<TaskOptions>>)job);
                continue;
            }
            if (this.jobsInProgress.put(file, (Pair<DataContext, List<TaskOptions>>)job) == null) {
                this.runTasksForFileImpl((Pair<DataContext, List<TaskOptions>>)job);
                continue;
            }
            LOG.debug("Queue " + file.getName());
        }
    }

    private static Map<VirtualFile, List<TaskOptions>> computeFilesAndTasksToPerform(@NotNull Project project, @NotNull VirtualFile initialFile, @NotNull List<? extends TaskOptions> options) {
        if (project == null) {
            TaskRunnerImpl.$$$reportNull$$$0(3);
        }
        if (initialFile == null) {
            TaskRunnerImpl.$$$reportNull$$$0(4);
        }
        if (options == null) {
            TaskRunnerImpl.$$$reportNull$$$0(5);
        }
        HashMap<VirtualFile, List<TaskOptions>> result = new HashMap<VirtualFile, List<TaskOptions>>();
        for (TaskOptions taskOptions : options) {
            String optionName = StringUtil.notNullize((String)taskOptions.getName());
            if (!TaskRunnerImpl.dependOnFile(taskOptions)) {
                if (optionName.equals(TaskUtils.extractCreatedTaskName(initialFile))) continue;
                LOG.debug("Options don't depend on any file " + String.valueOf(options));
                if (taskOptions.isCheckSyntaxErrors() && PsiErrorElementUtil.hasErrors((Project)project, (VirtualFile)initialFile)) {
                    LOG.debug(initialFile.getName() + " has syntax errors. Skip task " + optionName);
                    continue;
                }
                TaskRunnerImpl.addTask(result, initialFile, taskOptions);
                continue;
            }
            List<VirtualFile> roots = TaskUtils.findRoots(initialFile, project, taskOptions);
            for (VirtualFile rootFile : roots) {
                if (optionName.equals(TaskUtils.extractCreatedTaskName(rootFile))) continue;
                if (taskOptions.isCheckSyntaxErrors() && PsiErrorElementUtil.hasErrors((Project)project, (VirtualFile)rootFile)) {
                    LOG.debug(rootFile.getName() + " has syntax errors. Skip task " + optionName);
                    continue;
                }
                TaskRunnerImpl.addTask(result, rootFile, taskOptions);
            }
        }
        return result;
    }

    private static boolean dependOnFile(@NotNull TaskOptions option) {
        if (option == null) {
            TaskRunnerImpl.$$$reportNull$$$0(6);
        }
        String fileBasedMacroPrefix1 = "$File";
        String fileBasedMacroPrefix2 = "$/File";
        return StringUtil.notNullize((String)option.getArguments()).contains(fileBasedMacroPrefix1) || StringUtil.notNullize((String)option.getArguments()).contains(fileBasedMacroPrefix2) || StringUtil.notNullize((String)option.getWorkingDir()).contains(fileBasedMacroPrefix1) || StringUtil.notNullize((String)option.getWorkingDir()).contains(fileBasedMacroPrefix2);
    }

    private static void addTask(Map<? super VirtualFile, List<TaskOptions>> result, VirtualFile file, TaskOptions option) {
        List options = result.computeIfAbsent((VirtualFile)file, __ -> new ArrayList());
        options.add(option);
    }

    private void runTasksForFileImpl(@Nullable Pair<DataContext, List<TaskOptions>> job) {
        if (job == null) {
            return;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData((DataContext)job.getFirst());
        if (file == null) {
            return;
        }
        if (!file.isValid()) {
            this.jobsInProgress.remove(file);
            return;
        }
        LOG.debug("Run tasks " + TaskUtils.getPresentableNames((List)job.getSecond()) + " for " + file.getName());
        AtomicInteger tasksToFinish = new AtomicInteger(((List)job.getSecond()).size());
        for (TaskOptions taskOptions : (List)job.getSecond()) {
            FileTypeBackgroundTaskConsumer consumer;
            if (TaskRunnerImpl.dependOnFile(taskOptions) && (consumer = BackgroundTaskConsumer.findConsumerByFileType(file.getFileType())) != null && !consumer.isAvailable(file, taskOptions.getEnvData())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skip task " + taskOptions.getName() + " for " + file.getName());
                }
                Runnable removeJob = this.createRemoveJob(file, job, tasksToFinish);
                removeJob.run();
                continue;
            }
            try {
                this.runTask(file, job, taskOptions, tasksToFinish);
            }
            catch (Throwable e) {
                LOG.info("Cannot run " + taskOptions.getName() + " file watcher", e);
            }
        }
    }

    @NotNull
    private Runnable createRemoveJob(@NotNull VirtualFile file, @NotNull Pair<DataContext, List<TaskOptions>> job, @NotNull AtomicInteger tasksToFinish) {
        if (file == null) {
            TaskRunnerImpl.$$$reportNull$$$0(7);
        }
        if (job == null) {
            TaskRunnerImpl.$$$reportNull$$$0(8);
        }
        if (tasksToFinish == null) {
            TaskRunnerImpl.$$$reportNull$$$0(9);
        }
        Runnable runnable = () -> {
            if (tasksToFinish.decrementAndGet() > 0) {
                return;
            }
            if (!this.jobsInProgress.remove(file, job)) {
                LOG.debug(file.getName() + " is dirty. Rerun job.");
                Pair lastJob = (Pair)this.jobsInProgress.get(file);
                this.runTasksForFileImpl((Pair<DataContext, List<TaskOptions>>)lastJob);
            } else if (!this.myBatchFileChangeInProgress) {
                this.processQueue();
            }
        };
        if (runnable == null) {
            TaskRunnerImpl.$$$reportNull$$$0(10);
        }
        return runnable;
    }

    private void processQueue() {
        while (!this.jobsInQueue.isEmpty() && this.jobsInProgress.size() < 10) {
            VirtualFile virtualFile;
            Pair<DataContext, List<TaskOptions>> jobInQueue = this.jobsInQueue.poll();
            if (jobInQueue == null || (virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData((DataContext)jobInQueue.getFirst())) == null) continue;
            LOG.debug("Resume job " + virtualFile.getName());
            if (this.jobsInProgress.put(virtualFile, jobInQueue) != null) continue;
            this.runTasksForFileImpl(jobInQueue);
        }
    }

    private void runTask(final @NotNull VirtualFile file, Pair<DataContext, List<TaskOptions>> job, final TaskOptions taskOptions, AtomicInteger tasksToFinish) {
        GeneralCommandLine commandLine;
        if (file == null) {
            TaskRunnerImpl.$$$reportNull$$$0(11);
        }
        final DataContext dataContext = (DataContext)job.getFirst();
        final Runnable removeJob = this.createRemoveJob(file, job, tasksToFinish);
        if (!ProjectTasksOptions.getInstance(this.myProject).isWatcherEnabled(taskOptions)) {
            removeJob.run();
            return;
        }
        try {
            commandLine = this.createCommandLine(dataContext, taskOptions);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            this.disableWatcherAndNotify(e, taskOptions);
            removeJob.run();
            return;
        }
        File workingIoDir = commandLine.getWorkDirectory();
        final VirtualFile workingDir = workingIoDir != null ? LocalFileSystem.getInstance().findFileByIoFile(workingIoDir) : null;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Document document = FileDocumentManager.getInstance().getCachedDocument(file);
                if (document != null && FileDocumentManager.getInstance().isDocumentUnsaved(document)) {
                    LOG.debug("Task " + taskOptions.getName() + " for " + file.getName() + " skipped because document is not saved");
                    removeJob.run();
                    return;
                }
                LOG.debug("Run task " + taskOptions.getName() + " for " + file.getName());
                String progressTitle = BackgroundTaskBundle.message("progress.title.running.file.watchers", new Object[0]);
                new Task.Backgroundable(TaskRunnerImpl.this.myProject, progressTitle, true){
                    private ProcessOutput output;
                    private CapturingProcessHandler myProcessHandler;
                    private HistoryProcessListener myHistoryProcessListener;

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        indicator.setText(BackgroundTaskBundle.message("progress.text.running.file.watcher.0", taskOptions.getName()));
                        indicator.setIndeterminate(true);
                        try {
                            this.myProcessHandler = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
                            ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
                            this.myHistoryProcessListener = new HistoryProcessListener();
                            this.myProcessHandler.addProcessListener((ProcessListener)this.myHistoryProcessListener);
                            this.output = this.myProcessHandler.runProcessWithProgressIndicator(indicator);
                        }
                        catch (ExecutionException e) {
                            LOG.info((Throwable)e);
                            TaskRunnerImpl.this.disableWatcherAndNotify((Exception)((Object)e), taskOptions);
                        }
                    }

                    public void onSuccess() {
                        if (!this.getProject().isDisposed()) {
                            this.handleSuccess();
                        }
                        removeJob.run();
                    }

                    void handleSuccess() {
                        if (this.output == null) {
                            return;
                        }
                        LOG.debug(commandLine.getCommandLineString() + " exited with exit code: " + this.output.getExitCode());
                        LOG.debug(this.output.getStdout());
                        LOG.debug(this.output.getStderr());
                        if (taskOptions.getOutputFilters().length > 0 && file.isValid()) {
                            TaskRunnerImpl.this.processFilters(this.output, taskOptions, file, workingDir);
                        }
                        this.showOrHideRunWindowIfNeeded();
                        List outputFiles = (List)WriteAction.compute(() -> {
                            try {
                                return this.refreshOutputFiles(TaskRunnerImpl.isBadExitCode(this.output));
                            }
                            catch (Macro.ExecutionCancelledException e) {
                                LOG.debug((Throwable)e);
                                TaskRunnerImpl.this.disableWatcherAndNotify((Exception)((Object)e), taskOptions);
                                return Collections.emptyList();
                            }
                        });
                        for (OutputFilesHandler outputFilesHandler : (OutputFilesHandler[])OutputFilesHandler.EP_NAME.getExtensions()) {
                            outputFilesHandler.handleRefresh(dataContext, file, taskOptions, outputFiles);
                        }
                        this.updateOutputFilesOfDependencies();
                    }

                    private void showOrHideRunWindowIfNeeded() {
                        Pair taskNameAndFilePath = Pair.create((Object)taskOptions.getName(), (Object)file.getPath());
                        if (taskOptions.getExitCodeBehavior() == TaskOptions.ExitCodeBehavior.ALWAYS || TaskRunnerImpl.isBadExitCode(this.output) && taskOptions.getExitCodeBehavior() == TaskOptions.ExitCodeBehavior.ERROR) {
                            ColoredProcessHandler handler = new ColoredProcessHandler(this.myProcessHandler.getProcess(), commandLine.getCommandLineString());
                            handler.putUserData(TASK_NAME_AND_FILE_PATH_KEY, (Object)taskNameAndFilePath);
                            RunContentExecutor runContentExecutor = new RunContentExecutor(this.getProject(), (ProcessHandler)handler);
                            runContentExecutor = runContentExecutor.withFocusToolWindow(false);
                            for (BackgroundTaskFilterFactory backgroundTaskFilterFactory : (BackgroundTaskFilterFactory[])BackgroundTaskFilterFactory.EP_NAME.getExtensions()) {
                                Filter filter = backgroundTaskFilterFactory.createFilter(this.getProject(), file, workingDir);
                                if (filter == null) continue;
                                runContentExecutor = runContentExecutor.withFilter(filter);
                            }
                            for (BackgroundTaskFilterFactory backgroundTaskFilterFactory : taskOptions.getOutputFilters()) {
                                TaskProblemFinder taskProblemFinder = new TaskProblemFinder(backgroundTaskFilterFactory.getRegExp(), taskOptions.getOutputSettings());
                                runContentExecutor = runContentExecutor.withFilter(taskProblemFinder.getFilter(this.getProject(), workingDir, file));
                            }
                            runContentExecutor.run();
                            this.myHistoryProcessListener.apply((ProcessHandler)handler);
                        } else {
                            RunContentDescriptor runContentDescriptor = (RunContentDescriptor)ContainerUtil.find((Iterable)ExecutionManagerImpl.getAllDescriptors((Project)this.getProject()), descriptor -> {
                                ProcessHandler processHandler = descriptor.getProcessHandler();
                                if (processHandler == null) {
                                    return false;
                                }
                                Pair existingTaskNameAndFilePath = (Pair)processHandler.getUserData(TASK_NAME_AND_FILE_PATH_KEY);
                                if (existingTaskNameAndFilePath != null && ((String)existingTaskNameAndFilePath.getSecond()).equals(taskNameAndFilePath.getSecond())) {
                                    if (((String)existingTaskNameAndFilePath.getFirst()).equals(taskNameAndFilePath.getFirst())) {
                                        return true;
                                    }
                                    return !ProjectTasksOptions.getInstance(this.getProject()).hasEnabledWatcherWithName((String)existingTaskNameAndFilePath.getFirst());
                                }
                                return false;
                            });
                            if (runContentDescriptor != null) {
                                RunContentManager runContentManager = RunContentManager.getInstance((Project)this.getProject());
                                Executor executor = DefaultRunExecutor.getRunExecutorInstance();
                                runContentManager.removeRunContent(executor, runContentDescriptor);
                            }
                        }
                    }

                    public void onCancel() {
                        super.onCancel();
                        removeJob.run();
                    }

                    private List<VirtualFile> refreshOutputFiles(boolean badExitCode) throws Macro.ExecutionCancelledException {
                        String pathToWrite;
                        String pathToWritePath;
                        String workingDirPath = TaskRunnerImpl.expandMacros(taskOptions.getWorkingDir(), dataContext);
                        String[] outputPaths = taskOptions.getOutput().split(":");
                        if (!badExitCode && taskOptions.isOutputFromStdout() && outputPaths.length > 0 && (pathToWritePath = TaskRunnerImpl.getOutputFilePath(file, workingDirPath, pathToWrite = TaskRunnerImpl.expandMacros(outputPaths[0], dataContext))) != null) {
                            File fileToRefresh = new File(FileUtil.toSystemDependentName((String)pathToWritePath));
                            try {
                                FileUtil.writeToFile((File)fileToRefresh, (String)this.output.getStdout());
                            }
                            catch (IOException e) {
                                LOG.debug((Throwable)e);
                            }
                        }
                        ArrayList<VirtualFile> outputFiles = new ArrayList<VirtualFile>(outputPaths.length);
                        for (String outputFilePath : outputPaths) {
                            VirtualFile outputFile = TaskRunnerImpl.this.refreshOutput(file, workingDirPath, outputFilePath = TaskRunnerImpl.expandMacros(outputFilePath, dataContext), taskOptions.getName());
                            if (outputFile == null) continue;
                            outputFiles.add(outputFile);
                        }
                        return outputFiles;
                    }

                    private void updateOutputFilesOfDependencies() {
                        if (this.getProject().isDisposed()) {
                            return;
                        }
                        String extension = file.getExtension();
                        GlobalSearchScope scope = taskOptions.getFileScope(this.getProject());
                        for (FileDependencyFinder dependencyFinder : (FileDependencyFinder[])FileDependencyFinder.EP_NAME.getExtensions()) {
                            if (!dependencyFinder.updateGeneratedFilesOfDependencies() || !dependencyFinder.accept(extension)) continue;
                            dependencyFinder.findDependenciesAsync(this.getProject(), file, scope, true, dependencies -> this.handleOutputFilesOfDependencies((Set<? extends VirtualFile>)dependencies));
                            break;
                        }
                    }

                    private void handleOutputFilesOfDependencies(@NotNull Set<? extends VirtualFile> dependencies) {
                        if (dependencies == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (dependencies.isEmpty()) {
                            return;
                        }
                        ArrayList<WatchedFile> watchedFiles = new ArrayList<WatchedFile>();
                        for (VirtualFile virtualFile : dependencies) {
                            try {
                                WatchedFile watchedFile = this.createWatchedFile(virtualFile);
                                watchedFiles.add(watchedFile);
                            }
                            catch (Macro.ExecutionCancelledException e) {
                                LOG.debug((Throwable)e);
                                TaskRunnerImpl.this.disableWatcherAndNotify((Exception)((Object)e), taskOptions);
                                return;
                            }
                        }
                        ArrayList<WatchedFile.GeneratedFile> filesToRefresh = new ArrayList<WatchedFile.GeneratedFile>();
                        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                        ArrayList<VirtualFile> foundFilesToRefresh = new ArrayList<VirtualFile>();
                        for (WatchedFile watchedFile : watchedFiles) {
                            for (WatchedFile.GeneratedFile generatedFile : watchedFile.getGeneratedFiles()) {
                                VirtualFile file = virtualFileManager.findFileByUrl(generatedFile.getUrl());
                                if (file != null && file.isValid()) {
                                    generatedFile.setFile(file);
                                    foundFilesToRefresh.add(file);
                                    continue;
                                }
                                filesToRefresh.add(generatedFile);
                            }
                        }
                        RefreshQueue.getInstance().refresh(true, true, null, foundFilesToRefresh);
                        Runnable update = () -> {
                            ArrayList<VirtualFile> outputFiles = new ArrayList<VirtualFile>();
                            for (WatchedFile watchedFile : watchedFiles) {
                                VirtualFile sourceFile = watchedFile.getSourceFile();
                                for (WatchedFile.GeneratedFile generatedFile : watchedFile.getGeneratedFiles()) {
                                    VirtualFile file12 = generatedFile.getFile();
                                    if (file12 == null || !file12.isValid() || file12.isDirectory()) continue;
                                    outputFiles.add(file12);
                                    TaskUtils.saveOutputFileInfo(file12, taskOptions.getName(), sourceFile);
                                }
                            }
                            for (OutputFilesHandler outputFilesHandler : (OutputFilesHandler[])OutputFilesHandler.EP_NAME.getExtensions()) {
                                outputFilesHandler.handleRefresh(dataContext, file, taskOptions, outputFiles);
                            }
                        };
                        if (!filesToRefresh.isEmpty()) {
                            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                                for (WatchedFile.GeneratedFile generatedFile : filesToRefresh) {
                                    VirtualFile file1 = fileManager.refreshAndFindFileByUrl(generatedFile.getUrl());
                                    if (file1 == null) continue;
                                    generatedFile.setFile(file1);
                                }
                                update.run();
                            });
                        } else {
                            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), (Runnable)update);
                        }
                    }

                    private WatchedFile createWatchedFile(@NotNull VirtualFile file) throws Macro.ExecutionCancelledException {
                        if (file == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        String[] outputPaths = taskOptions.getOutput().split(":");
                        WatchedFile watchedFile = new WatchedFile(file);
                        for (String outputFilePath : outputPaths) {
                            DataContext newDataContext = SimpleDataContext.getSimpleContext((DataKey)CommonDataKeys.VIRTUAL_FILE, (Object)file, (DataContext)dataContext);
                            String expandedOutputPath = TaskRunnerImpl.expandMacros(outputFilePath, newDataContext);
                            String newOutputFilePath = TaskRunnerImpl.getOutputFilePath(file, "", expandedOutputPath);
                            if (!StringUtil.isNotEmpty((String)newOutputFilePath)) continue;
                            watchedFile.addUrl(VfsUtilCore.pathToUrl((String)newOutputFilePath));
                        }
                        return watchedFile;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "dependencies";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/plugins/watcher/TaskRunnerImpl$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "handleOutputFilesOfDependencies";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "createWatchedFile";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }.setCancelText(BackgroundTaskBundle.message("button.stop.file.watcher", new Object[0])).queue();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.any(), __ -> Disposer.isDisposed((Disposable)this));
        }
    }

    @Nullable
    private static String expandMacros(String macrosString, DataContext dataContext) throws Macro.ExecutionCancelledException {
        String expandedString = MacroManager.getInstance().expandSilentMacros(macrosString, false, dataContext);
        return expandedString == null ? null : FileUtil.toSystemIndependentName((String)expandedString);
    }

    private void disableWatcherAndNotify(Exception e, final TaskOptions taskOptions) {
        ProjectTasksOptions.getInstance(this.myProject).disableWatcher(taskOptions.getName());
        NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("File Watchers");
        group.createNotification(BackgroundTaskBundle.message("execution.exception.title", taskOptions.getName()), BackgroundTaskBundle.message("execution.exception.message", e.getMessage()), NotificationType.ERROR).setListener((NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                WatchersConfigurable configurable = new WatchersConfigurable(TaskRunnerImpl.this.myProject);
                ShowSettingsUtil.getInstance().editConfigurable(TaskRunnerImpl.this.myProject, (Configurable)configurable, () -> configurable.getPanel().selectTaskByName(taskOptions.getName()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/plugins/watcher/TaskRunnerImpl$2";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(this.myProject);
    }

    private void processFilters(@NotNull ProcessOutput output, @NotNull TaskOptions taskOptions, @NotNull VirtualFile file, @Nullable VirtualFile workingDir) {
        PsiFile psiFile;
        if (output == null) {
            TaskRunnerImpl.$$$reportNull$$$0(12);
        }
        if (taskOptions == null) {
            TaskRunnerImpl.$$$reportNull$$$0(13);
        }
        if (file == null) {
            TaskRunnerImpl.$$$reportNull$$$0(14);
        }
        this.getProblemsHolder().clearByInitializer(file, taskOptions.getName());
        List<TaskProblemDescription> problems = TaskProblemFinder.findProblems(output.getStderrLines(false), taskOptions);
        if (!taskOptions.isOutputFromStdout() || TaskRunnerImpl.isBadExitCode(output)) {
            problems.addAll(TaskProblemFinder.findProblems(output.getStdoutLines(false), taskOptions));
        }
        if (!problems.isEmpty()) {
            this.processFilters(problems, taskOptions, file, workingDir);
        }
        if ((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file)) != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile);
        }
    }

    private static boolean isBadExitCode(ProcessOutput output) {
        return output.getExitCode() != 0 && output.getExitCode() != 137;
    }

    void processFilters(@NotNull List<? extends TaskProblemDescription> problems, @NotNull TaskOptions taskOptions, @NotNull VirtualFile file, @Nullable VirtualFile workingDir) {
        if (problems == null) {
            TaskRunnerImpl.$$$reportNull$$$0(15);
        }
        if (taskOptions == null) {
            TaskRunnerImpl.$$$reportNull$$$0(16);
        }
        if (file == null) {
            TaskRunnerImpl.$$$reportNull$$$0(17);
        }
        HashMap file2problems = new HashMap();
        for (TaskProblemDescription taskProblemDescription : problems) {
            VirtualFile fileWithProblem = TaskRunnerImpl.findFile(taskProblemDescription, workingDir, file);
            if (fileWithProblem == null) continue;
            TaskRunnerImpl.addProblem(file2problems, fileWithProblem, taskProblemDescription);
        }
        for (Map.Entry entry : file2problems.entrySet()) {
            VirtualFile currentFile = (VirtualFile)entry.getKey();
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(currentFile);
            if (psiFile == null) continue;
            this.getProblemsHolder().addProblems(currentFile, psiFile.getModificationStamp(), file, taskOptions.getName(), (List)entry.getValue());
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile);
        }
    }

    private static void addProblem(Map<? super VirtualFile, List<TaskProblemDescription>> file2problem, VirtualFile virtualFile, TaskProblemDescription problem) {
        List problems = file2problem.computeIfAbsent((VirtualFile)virtualFile, __ -> new ArrayList());
        problems.add(problem);
    }

    @Nullable
    public static VirtualFile findFile(@NotNull TaskProblemDescription problem, @Nullable VirtualFile workingDir, @NotNull VirtualFile currentFile) {
        if (problem == null) {
            TaskRunnerImpl.$$$reportNull$$$0(18);
        }
        if (currentFile == null) {
            TaskRunnerImpl.$$$reportNull$$$0(19);
        }
        if (StringUtil.isEmptyOrSpaces((String)problem.getPath())) {
            return currentFile;
        }
        String path = FileUtil.toSystemIndependentName((String)problem.getPath());
        VirtualFile result = LocalFileFinder.findFile((String)path);
        return result != null ? result : VfsUtil.findRelativeFile((VirtualFile)workingDir, (String[])path.split("/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFile refreshOutput(@NotNull VirtualFile sourceFile, String workingDirPath, String outputFilePath, String watcherName) {
        if (sourceFile == null) {
            TaskRunnerImpl.$$$reportNull$$$0(20);
        }
        if ((outputFilePath = TaskRunnerImpl.getOutputFilePath(sourceFile, workingDirPath, outputFilePath)) != null) {
            String url = VfsUtilCore.pathToUrl((String)outputFilePath);
            this.myFilesInRefreshState.add(url);
            VirtualFile outputFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
            if (outputFile != null) {
                if (outputFile instanceof NewVirtualFile) {
                    ((NewVirtualFile)outputFile).markDirtyRecursively();
                }
                boolean asyncRefresh = !ApplicationManager.getApplication().isUnitTestMode();
                this.myPendingRefreshes.incrementAndGet();
                if (sourceFile.equals(outputFile)) {
                    try {
                        UndoUtil.forceUndoIn((VirtualFile)outputFile, () -> this.handleSourceFileEqualsToOutputFile(sourceFile, watcherName));
                    }
                    finally {
                        this.myPendingRefreshes.decrementAndGet();
                        this.myFilesInRefreshState.remove(url);
                    }
                } else {
                    UndoUtil.setForceUndoFlag((VirtualFile)outputFile, (boolean)true);
                    outputFile.refresh(asyncRefresh, true, () -> {
                        this.myPendingRefreshes.decrementAndGet();
                        this.myFilesInRefreshState.remove(url);
                        if (!outputFile.isDirectory() && !sourceFile.equals(outputFile)) {
                            this.myTasksScheduler.addRequest(() -> FwTaskRunner.tryFindTasksAndRun(this.myProject, outputFile, (Condition<TaskOptions>)((Condition)task -> task.isRunOnExternalChanges())), 0);
                        }
                        UndoUtil.setForceUndoFlag((VirtualFile)outputFile, (boolean)false);
                    });
                }
                if (!outputFile.isDirectory()) {
                    TaskUtils.saveOutputFileInfo(outputFile, watcherName, sourceFile);
                }
            } else {
                this.myFilesInRefreshState.remove(url);
            }
            return outputFile;
        }
        return null;
    }

    private void handleSourceFileEqualsToOutputFile(@NotNull VirtualFile file, @NotNull String watcherName) {
        Document document;
        if (file == null) {
            TaskRunnerImpl.$$$reportNull$$$0(21);
        }
        if (watcherName == null) {
            TaskRunnerImpl.$$$reportNull$$$0(22);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(file)) == null) {
            return;
        }
        if (UndoManager.getInstance((Project)this.myProject).isUndoOrRedoInProgress()) {
            return;
        }
        if (FileDocumentManager.getInstance().isDocumentUnsaved(document)) {
            try {
                LoadTextUtil.write((Project)this.myProject, (VirtualFile)file, (Object)this, (String)document.getText(), (long)document.getModificationStamp());
                CommandProcessor.getInstance().runUndoTransparentAction(() -> FileDocumentManager.getInstance().reloadFromDisk(document));
                this.myTasksScheduler.addRequest(() -> FwTaskRunner.tryFindTasksAndRun(this.myProject, file, (Condition<TaskOptions>)Conditions.alwaysTrue()), 0);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        } else {
            Runnable runnable = () -> {
                if (file.isValid() && document.isWritable()) {
                    CharSequence newText = LoadTextUtil.loadText((VirtualFile)file);
                    if (!StringUtil.equals((CharSequence)document.getCharsSequence(), (CharSequence)newText)) {
                        document.setText(newText);
                    }
                }
            };
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> file.refresh(false, false, runnable), BackgroundTaskBundle.message("command.name.file.watcher.0", watcherName), null, document);
        }
    }

    @Nullable
    private static String getOutputFilePath(VirtualFile virtualFile, String workingDirPath, String outputFilePath) {
        if (!FileUtil.isAbsolute((String)outputFilePath)) {
            String baseFile = StringUtil.isEmpty((String)workingDirPath) ? virtualFile.getParent().getPath() : workingDirPath;
            outputFilePath = TaskUtils.getPathByRelativePath(baseFile, outputFilePath, "/");
        }
        return outputFilePath;
    }

    private GeneralCommandLine createCommandLine(DataContext dataContext, TaskOptions options) throws Exception {
        return (GeneralCommandLine)ReadAction.compute(() -> this.doCreateCommandLine(dataContext, options));
    }

    @NotNull
    private GeneralCommandLine doCreateCommandLine(DataContext dataContext, TaskOptions options) throws ExecutionException, Macro.ExecutionCancelledException {
        VirtualFile fileDir;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        EnvironmentVariablesData data = options.getEnvData();
        MacroManager macroManager = MacroManager.getInstance();
        String exePath = macroManager.expandSilentMacros(options.getProgram(), true, dataContext);
        if ((exePath = TaskRunnerImpl.expandMacros(exePath, dataContext)) == null || StringUtil.isEmpty((String)exePath)) {
            throw new ExecutionException(BackgroundTaskBundle.message("invalid.executable", new Object[0]));
        }
        WSLDistribution wsl = WslPath.getDistributionByWindowsUncPath((String)exePath);
        WslMacroPathConverter pathConverter = null;
        if (wsl != null) {
            pathConverter = new WslMacroPathConverter(wsl);
            dataContext = SimpleDataContext.getSimpleContext((DataKey)MacroManager.PATH_CONVERTER_KEY, (Object)pathConverter, (DataContext)dataContext);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry entry : data.getEnvs().entrySet()) {
            map.put((String)entry.getKey(), macroManager.expandSilentMacros((String)entry.getValue(), true, dataContext));
        }
        EnvironmentVariablesData.create(map, (boolean)data.isPassParentEnvs()).configureCommandLine(commandLine, true);
        commandLine.setRedirectErrorStream(true);
        commandLine.withCharset(EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
        String workingDir = macroManager.expandSilentMacros(options.getWorkingDir(), true, dataContext);
        List rawArguments = ParametersListUtil.parse((String)options.getArguments());
        for (String rawArgument : rawArguments) {
            String expanded = macroManager.expandSilentMacros(rawArgument, true, dataContext);
            String result = macroManager.expandSilentMacros(expanded, false, dataContext);
            commandLine.addParameter(StringUtil.notNullize((String)result));
        }
        EnvironmentUtil.inlineParentOccurrences((Map)commandLine.getEnvironment());
        String workDirExpanded = TaskRunnerImpl.expandMacros(workingDir, dataContext);
        if (StringUtil.isEmpty((String)workDirExpanded) && (fileDir = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null) {
            workDirExpanded = fileDir.getParent().getPath();
        }
        if (!StringUtil.isEmpty((String)workDirExpanded)) {
            commandLine.withWorkDirectory(workDirExpanded);
        }
        if (wsl != null) {
            GeneralCommandLine generalCommandLine = Tool.createWslCommandLine((Project)this.myProject, (WSLDistribution)wsl, (GeneralCommandLine)commandLine, (String)workDirExpanded, (String)pathConverter.convertPath(exePath));
            if (generalCommandLine == null) {
                TaskRunnerImpl.$$$reportNull$$$0(23);
            }
            return generalCommandLine;
        }
        File exeFile = NewWatcherDialog.findProgramFile(exePath, dataContext, data);
        if (exeFile == null || !exeFile.exists()) {
            throw new ExecutionException(BackgroundTaskBundle.message("invalid.executable", new Object[0]));
        }
        exePath = exeFile.getAbsolutePath();
        String basename = exeFile.getName();
        if (SystemInfo.isMac && exeFile.isDirectory() && basename.endsWith(".app")) {
            commandLine.setExePath("open");
            commandLine.getParametersList().prependAll(new String[]{"-a", exePath});
        } else if (StringUtil.endsWithIgnoreCase((String)basename, (String)".jar")) {
            commandLine.setExePath(TaskRunnerImpl.getJDKExecutablePath());
            commandLine.getParametersList().prependAll(new String[]{"-jar", exePath});
        } else if (SystemInfo.isWindows && (StringUtil.endsWithIgnoreCase((String)basename, (String)".cmd") || StringUtil.endsWithIgnoreCase((String)basename, (String)".bat"))) {
            commandLine.setExePath("cmd.exe");
            commandLine.getParametersList().prependAll(new String[]{"/D", "/C", "call", exePath});
        } else {
            commandLine.setExePath(exePath);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            TaskRunnerImpl.$$$reportNull$$$0(24);
        }
        return generalCommandLine;
    }

    private static String getJDKExecutablePath() {
        return SystemProperties.getJavaHome() + "/bin/java";
    }

    public void dispose() {
        if (!this.myProject.isDisposed()) {
            for (RunContentDescriptor runContentDescriptor : ExecutionManagerImpl.getAllDescriptors((Project)this.myProject)) {
                ProcessHandler processHandler = runContentDescriptor.getProcessHandler();
                if (processHandler == null || processHandler.getUserData(TASK_NAME_AND_FILE_PATH_KEY) == null) continue;
                RunContentManager.getInstance((Project)this.myProject).removeRunContent(DefaultRunExecutor.getRunExecutorInstance(), runContentDescriptor);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksToFinish";
                break;
            }
            case 10: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/TaskRunnerImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskOptions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcherName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/TaskRunnerImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoveJob";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "inRefreshState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runTasksForFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeFilesAndTasksToPerform";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dependOnFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveJob";
                break;
            }
            case 10: 
            case 23: 
            case 24: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processFilters";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "refreshOutput";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "handleSourceFileEqualsToOutputFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 23, 24 -> new IllegalStateException(string);
        };
    }

    static final class MyBatchFileChangeListener
    implements BatchFileChangeListener {
        MyBatchFileChangeListener() {
        }

        public void batchChangeStarted(@NotNull Project project, @Nullable String activityName) {
            if (project == null) {
                MyBatchFileChangeListener.$$$reportNull$$$0(0);
            }
            ((TaskRunnerImpl)TaskRunner.getInstance((Project)project)).myBatchFileChangeInProgress = true;
        }

        public void batchChangeCompleted(@NotNull Project project) {
            if (project == null) {
                MyBatchFileChangeListener.$$$reportNull$$$0(1);
            }
            if (project.isDisposed()) {
                return;
            }
            ((TaskRunnerImpl)TaskRunner.getInstance((Project)project)).myBatchFileChangeInProgress = false;
            ((TaskRunnerImpl)TaskRunner.getInstance(project)).processQueue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/plugins/watcher/TaskRunnerImpl$MyBatchFileChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "batchChangeStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "batchChangeCompleted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

