/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.LoadingDetailsImpl;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\f\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010*\u001a\u00020&H\u0016J\b\u0010+\u001a\u00020&H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0016J\b\u0010-\u001a\u00020\u0017H\u0016J\b\u0010.\u001a\u00020\u0017H\u0016J\b\u0010/\u001a\u00020\tH\u0016J\b\u00100\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RK\u0010\f\u001a2\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u0001 \u000f*\u0017\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u0011\u00a2\u0006\u0002\b\u00100\r\u00a2\u0006\u0002\b\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0016\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001b\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0015\u001a\u0004\b\u001c\u0010\u0019R\"\u0010\u001e\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0015\u001a\u0004\b\u001f\u0010 R\"\u0010\"\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0015\u001a\u0004\b#\u0010 R\"\u0010%\u001a\t\u0018\u00010&\u00a2\u0006\u0002\b\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0015\u001a\u0004\b'\u0010(\u00a8\u00062"}, d2={"Lcom/intellij/vcs/log/data/index/IndexedDetails;", "Lcom/intellij/vcs/log/data/LoadingDetailsImpl;", "dataGetter", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "commitIndex", "", "loadingTaskIndex", "", "<init>", "(Lcom/intellij/vcs/log/data/index/IndexDataGetter;Lcom/intellij/vcs/log/data/VcsLogStorage;IJ)V", "_parents", "", "Lcom/intellij/vcs/log/Hash;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/Nullable;", "", "get_parents", "()Ljava/util/List;", "_parents$delegate", "Lkotlin/Lazy;", "_author", "Lcom/intellij/vcs/log/VcsUser;", "get_author", "()Lcom/intellij/vcs/log/VcsUser;", "_author$delegate", "_committer", "get_committer", "_committer$delegate", "_authorTime", "get_authorTime", "()Ljava/lang/Long;", "_authorTime$delegate", "_commitTime", "get_commitTime", "_commitTime$delegate", "_fullMessage", "", "get_fullMessage", "()Ljava/lang/String;", "_fullMessage$delegate", "getFullMessage", "getSubject", "getParents", "getAuthor", "getCommitter", "getAuthorTime", "getCommitTime", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIndexedDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedDetails.kt\ncom/intellij/vcs/log/data/index/IndexedDetails\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class IndexedDetails
extends LoadingDetailsImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexDataGetter dataGetter;
    private final int commitIndex;
    @NotNull
    private final Lazy _parents$delegate;
    @NotNull
    private final Lazy _author$delegate;
    @NotNull
    private final Lazy _committer$delegate;
    @NotNull
    private final Lazy _authorTime$delegate;
    @NotNull
    private final Lazy _commitTime$delegate;
    @NotNull
    private final Lazy _fullMessage$delegate;

    public IndexedDetails(@NotNull IndexDataGetter dataGetter, @NotNull VcsLogStorage storage, int commitIndex, long loadingTaskIndex) {
        Intrinsics.checkNotNullParameter((Object)dataGetter, (String)"dataGetter");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        super(storage, commitIndex, loadingTaskIndex);
        this.dataGetter = dataGetter;
        this.commitIndex = commitIndex;
        this._parents$delegate = LazyKt.lazy(() -> IndexedDetails._parents_delegate$lambda$0(this));
        this._author$delegate = LazyKt.lazy(() -> IndexedDetails._author_delegate$lambda$1(this));
        this._committer$delegate = LazyKt.lazy(() -> IndexedDetails._committer_delegate$lambda$2(this));
        this._authorTime$delegate = LazyKt.lazy(() -> IndexedDetails._authorTime_delegate$lambda$3(this));
        this._commitTime$delegate = LazyKt.lazy(() -> IndexedDetails._commitTime_delegate$lambda$4(this));
        this._fullMessage$delegate = LazyKt.lazy(() -> IndexedDetails._fullMessage_delegate$lambda$5(this));
    }

    public /* synthetic */ IndexedDetails(IndexDataGetter indexDataGetter, VcsLogStorage vcsLogStorage, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            l = 0L;
        }
        this(indexDataGetter, vcsLogStorage, n, l);
    }

    private final List<Hash> get_parents() {
        Lazy lazy = this._parents$delegate;
        return (List)lazy.getValue();
    }

    private final VcsUser get_author() {
        Lazy lazy = this._author$delegate;
        return (VcsUser)lazy.getValue();
    }

    private final VcsUser get_committer() {
        Lazy lazy = this._committer$delegate;
        return (VcsUser)lazy.getValue();
    }

    private final Long get_authorTime() {
        Lazy lazy = this._authorTime$delegate;
        return (Long)lazy.getValue();
    }

    private final Long get_commitTime() {
        Lazy lazy = this._commitTime$delegate;
        return (Long)lazy.getValue();
    }

    private final String get_fullMessage() {
        Lazy lazy = this._fullMessage$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getFullMessage() {
        String string = this.get_fullMessage();
        if (string == null) {
            string = super.getFullMessage();
        }
        return string;
    }

    @Override
    @NotNull
    public String getSubject() {
        String string;
        block3: {
            block2: {
                string = this.get_fullMessage();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = Companion.getSubject(it);
                string = string2;
                if (string2 != null) break block3;
            }
            string = super.getSubject();
        }
        return string;
    }

    @Override
    @NotNull
    public List<Hash> getParents() {
        List<Hash> list = this.get_parents();
        if (list == null) {
            list = super.getParents();
        }
        return list;
    }

    @Override
    @NotNull
    public VcsUser getAuthor() {
        VcsUser vcsUser = this.get_author();
        if (vcsUser == null) {
            vcsUser = super.getAuthor();
        }
        return vcsUser;
    }

    @Override
    @NotNull
    public VcsUser getCommitter() {
        VcsUser vcsUser = this.get_committer();
        if (vcsUser == null) {
            vcsUser = super.getCommitter();
        }
        return vcsUser;
    }

    @Override
    public long getAuthorTime() {
        Long l = this.get_authorTime();
        return l != null ? l.longValue() : super.getAuthorTime();
    }

    @Override
    public long getCommitTime() {
        Long l = this.get_commitTime();
        return l != null ? l.longValue() : super.getCommitTime();
    }

    private static final List _parents_delegate$lambda$0(IndexedDetails this$0) {
        return this$0.dataGetter.getParents(this$0.commitIndex);
    }

    private static final VcsUser _author_delegate$lambda$1(IndexedDetails this$0) {
        return this$0.dataGetter.getAuthor(this$0.commitIndex);
    }

    private static final VcsUser _committer_delegate$lambda$2(IndexedDetails this$0) {
        return this$0.dataGetter.getCommitter(this$0.commitIndex);
    }

    private static final Long _authorTime_delegate$lambda$3(IndexedDetails this$0) {
        return this$0.dataGetter.getAuthorTime(this$0.commitIndex);
    }

    private static final Long _commitTime_delegate$lambda$4(IndexedDetails this$0) {
        return this$0.dataGetter.getCommitTime(this$0.commitIndex);
    }

    private static final String _fullMessage_delegate$lambda$5(IndexedDetails this$0) {
        return this$0.dataGetter.getFullMessage(this$0.commitIndex);
    }

    @JvmStatic
    @NlsSafe
    @NotNull
    public static final String getSubject(@NotNull String fullMessage) {
        return Companion.getSubject(fullMessage);
    }

    @JvmStatic
    @NotNull
    public static final Int2ObjectMap<VcsCommitMetadata> createMetadata(@NotNull Set<Integer> commitIndexes, @NotNull IndexDataGetter dataGetter, @NotNull VcsLogStorage storage, @NotNull VcsLogObjectsFactory factory) {
        return Companion.createMetadata(commitIndexes, dataGetter, storage, factory);
    }

    @JvmStatic
    @Nullable
    public static final VcsCommitMetadata createMetadata(int commitIndex, @NotNull IndexDataGetter dataGetter, @NotNull VcsLogStorage storage, @NotNull VcsLogObjectsFactory factory) {
        return Companion.createMetadata(commitIndex, dataGetter, storage, factory);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J4\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J*\u0010\u0007\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/log/data/index/IndexedDetails$Companion;", "", "<init>", "()V", "getSubject", "", "fullMessage", "createMetadata", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "commitIndexes", "", "", "dataGetter", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "factory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "commitIndex", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NlsSafe
        @NotNull
        public final String getSubject(@NotNull String fullMessage) {
            String string;
            Intrinsics.checkNotNullParameter((Object)fullMessage, (String)"fullMessage");
            int subjectEnd = StringsKt.indexOf$default((CharSequence)fullMessage, (String)"\n\n", (int)0, (boolean)false, (int)6, null);
            if (subjectEnd > 0) {
                String string2 = fullMessage.substring(0, subjectEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = StringsKt.replace$default((String)string2, (String)"\n", (String)" ", (boolean)false, (int)4, null);
            } else {
                string = StringsKt.replace$default((String)fullMessage, (String)"\n", (String)" ", (boolean)false, (int)4, null);
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final Int2ObjectMap<VcsCommitMetadata> createMetadata(@NotNull Set<Integer> commitIndexes, @NotNull IndexDataGetter dataGetter, @NotNull VcsLogStorage storage, @NotNull VcsLogObjectsFactory factory) {
            Intrinsics.checkNotNullParameter(commitIndexes, (String)"commitIndexes");
            Intrinsics.checkNotNullParameter((Object)dataGetter, (String)"dataGetter");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Map<Integer, CommitId> commitIds2 = storage.getCommitIds((Collection<Integer>)commitIndexes);
            if (commitIds2.isEmpty()) {
                Int2ObjectMap int2ObjectMap = Int2ObjectMaps.emptyMap();
                Intrinsics.checkNotNullExpressionValue((Object)int2ObjectMap, (String)"emptyMap(...)");
                return int2ObjectMap;
            }
            Map<Integer, VcsUser> map = dataGetter.getAuthor((Collection<Integer>)commitIndexes);
            if (map == null) {
                Int2ObjectMap int2ObjectMap = Int2ObjectMaps.emptyMap();
                Intrinsics.checkNotNullExpressionValue((Object)int2ObjectMap, (String)"emptyMap(...)");
                return int2ObjectMap;
            }
            Map<Integer, VcsUser> authors = map;
            Map<Integer, VcsUser> map2 = dataGetter.getCommitter((Collection<Integer>)commitIndexes);
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getCommitter(...)");
            Map<Integer, VcsUser> committers = map2;
            Map<Integer, String> map3 = dataGetter.getFullMessage((Collection<Integer>)commitIndexes);
            if (map3 == null) {
                Int2ObjectMap int2ObjectMap = Int2ObjectMaps.emptyMap();
                Intrinsics.checkNotNullExpressionValue((Object)int2ObjectMap, (String)"emptyMap(...)");
                return int2ObjectMap;
            }
            Map<Integer, String> messages = map3;
            Map<Integer, List<Hash>> map4 = dataGetter.getParents((Collection<Integer>)commitIndexes);
            if (map4 == null) {
                Int2ObjectMap int2ObjectMap = Int2ObjectMaps.emptyMap();
                Intrinsics.checkNotNullExpressionValue((Object)int2ObjectMap, (String)"emptyMap(...)");
                return int2ObjectMap;
            }
            Map<Integer, List<Hash>> parents = map4;
            Map<Integer, Long> map5 = dataGetter.getAuthorTime((Collection<Integer>)commitIndexes);
            if (map5 == null) {
                Int2ObjectMap int2ObjectMap = Int2ObjectMaps.emptyMap();
                Intrinsics.checkNotNullExpressionValue((Object)int2ObjectMap, (String)"emptyMap(...)");
                return int2ObjectMap;
            }
            Map<Integer, Long> authorTimes = map5;
            Map<Integer, Long> map6 = dataGetter.getCommitTime((Collection<Integer>)commitIndexes);
            if (map6 == null) {
                Int2ObjectMap int2ObjectMap = Int2ObjectMaps.emptyMap();
                Intrinsics.checkNotNullExpressionValue((Object)int2ObjectMap, (String)"emptyMap(...)");
                return int2ObjectMap;
            }
            Map<Integer, Long> commitTimes = map6;
            Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
            Iterator<Integer> iterator = commitIndexes.iterator();
            while (iterator.hasNext()) {
                int commitIndex = ((Number)iterator.next()).intValue();
                CommitId commitId = commitIds2.get(commitIndex);
                List<Hash> parent = parents.get(commitIndex);
                VcsUser author = authors.get(commitIndex);
                VcsUser vcsUser = committers.get(commitIndex);
                if (vcsUser == null) {
                    vcsUser = author;
                }
                VcsUser committer = vcsUser;
                Long authorTime = authorTimes.get(commitIndex);
                Long commitTime = commitTimes.get(commitIndex);
                String fullMessage = messages.get(commitIndex);
                if (commitId == null || parent == null || author == null || committer == null || commitTime == null || authorTime == null || fullMessage == null) continue;
                result.put(commitIndex, (Object)factory.createCommitMetadata(commitId.getHash(), parent, commitTime.longValue(), commitId.getRoot(), this.getSubject(fullMessage), author.getName(), author.getEmail(), fullMessage, committer.getName(), committer.getEmail(), authorTime.longValue()));
            }
            return (Int2ObjectMap)result;
        }

        @JvmStatic
        @Nullable
        public final VcsCommitMetadata createMetadata(int commitIndex, @NotNull IndexDataGetter dataGetter, @NotNull VcsLogStorage storage, @NotNull VcsLogObjectsFactory factory) {
            Intrinsics.checkNotNullParameter((Object)dataGetter, (String)"dataGetter");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Set<Integer> set = Collections.singleton(commitIndex);
            Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(...)");
            return (VcsCommitMetadata)this.createMetadata(set, dataGetter, storage, factory).getOrDefault(commitIndex, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

