/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.draganddrop.DragAndDropEvent;
import androidx.compose.ui.draganddrop.DragAndDropTransferAction;
import androidx.compose.ui.draganddrop.DragAndDropTransferData;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.DesktopImageConverters_desktopKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.drawscope.CanvasDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.platform.AwtDragAndDropManager;
import androidx.compose.ui.platform.AwtDragAndDropManager_desktopKt;
import androidx.compose.ui.platform.ComposeTransferHandler;
import androidx.compose.ui.platform.PlatformAdaptations;
import androidx.compose.ui.platform.PlatformDragAndDropManager;
import androidx.compose.ui.platform.PlatformDragAndDropSource;
import androidx.compose.ui.scene.ComposeSceneDragAndDropTarget;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.window.LayoutConfiguration_desktopKt;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008f\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0011\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007JC\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%\u00a2\u0006\u0002\b(H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b)\u0010*J\"\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b0\u00101J;\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020!2\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%\u00a2\u0006\u0002\b(H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b6\u00107J\u0019\u00108\u001a\u00020/*\u000209H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b:\u0010;R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006<"}, d2={"Landroidx/compose/ui/platform/AwtDragAndDropManager;", "Landroidx/compose/ui/platform/PlatformDragAndDropManager;", "rootContainer", "Ljavax/swing/JComponent;", "dragAndDropTarget", "Lkotlin/Function0;", "Landroidx/compose/ui/scene/ComposeSceneDragAndDropTarget;", "(Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function0;)V", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "dropTarget", "Ljava/awt/dnd/DropTarget;", "getDropTarget", "()Ljava/awt/dnd/DropTarget;", "dropTargetListener", "androidx/compose/ui/platform/AwtDragAndDropManager$dropTargetListener$1", "Landroidx/compose/ui/platform/AwtDragAndDropManager$dropTargetListener$1;", "isRequestDragAndDropTransferSupported", "", "()Z", "scale", "", "getScale", "()F", "transferHandler", "Landroidx/compose/ui/platform/ComposeTransferHandler;", "getTransferHandler", "()Landroidx/compose/ui/platform/ComposeTransferHandler;", "renderDragImage", "Ljava/awt/Image;", "size", "Landroidx/compose/ui/geometry/Size;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "drawDragDecoration", "Lkotlin/Function1;", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "", "Lkotlin/ExtensionFunctionType;", "renderDragImage-Cqks5Fs", "(JLandroidx/compose/ui/unit/Density;Landroidx/compose/ui/unit/LayoutDirection;Lkotlin/jvm/functions/Function1;)Ljava/awt/Image;", "requestDragAndDropTransfer", "source", "Landroidx/compose/ui/platform/PlatformDragAndDropSource;", "offset", "Landroidx/compose/ui/geometry/Offset;", "requestDragAndDropTransfer-Uv8p0NA", "(Landroidx/compose/ui/platform/PlatformDragAndDropSource;J)V", "startDrag", "transferData", "Landroidx/compose/ui/draganddrop/DragAndDropTransferData;", "decorationSize", "startDrag-12SF9DM", "(Landroidx/compose/ui/draganddrop/DragAndDropTransferData;JLkotlin/jvm/functions/Function1;)Z", "toOffset", "Ljava/awt/Point;", "toOffset-tuRUvjQ", "(Ljava/awt/Point;)J", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAwtDragAndDropManager.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwtDragAndDropManager.desktop.kt\nandroidx/compose/ui/platform/AwtDragAndDropManager\n+ 2 CanvasDrawScope.kt\nandroidx/compose/ui/graphics/drawscope/CanvasDrawScope\n*L\n1#1,406:1\n546#2,17:407\n*S KotlinDebug\n*F\n+ 1 AwtDragAndDropManager.desktop.kt\nandroidx/compose/ui/platform/AwtDragAndDropManager\n*L\n167#1:407,17\n*E\n"})
public final class AwtDragAndDropManager
implements PlatformDragAndDropManager {
    @NotNull
    private final JComponent rootContainer;
    @NotNull
    private final Function0<ComposeSceneDragAndDropTarget> dragAndDropTarget;
    @NotNull
    private final dropTargetListener.1 dropTargetListener;
    @NotNull
    private final ComposeTransferHandler transferHandler;
    @NotNull
    private final DropTarget dropTarget;
    public static final int $stable = 8;

    public AwtDragAndDropManager(@NotNull JComponent rootContainer, @NotNull Function0<ComposeSceneDragAndDropTarget> dragAndDropTarget2) {
        Intrinsics.checkNotNullParameter((Object)rootContainer, (String)"rootContainer");
        Intrinsics.checkNotNullParameter(dragAndDropTarget2, (String)"dragAndDropTarget");
        this.rootContainer = rootContainer;
        this.dragAndDropTarget = dragAndDropTarget2;
        this.dropTargetListener = new DropTargetListener(this){
            final /* synthetic */ AwtDragAndDropManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void dragEnter(@NotNull DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragAndDropEvent event = this.DragAndDropEvent(dtde);
                ComposeSceneDragAndDropTarget dragAndDropTarget2 = (ComposeSceneDragAndDropTarget)AwtDragAndDropManager.access$getDragAndDropTarget$p(this.this$0).invoke();
                boolean acceptedTransfer = dragAndDropTarget2.acceptDragAndDropTransfer(event);
                if (acceptedTransfer) {
                    dragAndDropTarget2.onStarted(event);
                    dragAndDropTarget2.onEntered(event);
                } else {
                    dtde.rejectDrag();
                }
            }

            public void dragExit(@NotNull DropTargetEvent dte) {
                Intrinsics.checkNotNullParameter((Object)dte, (String)"dte");
                DragAndDropEvent event = this.DragAndDropEvent(dte);
                ComposeSceneDragAndDropTarget dragAndDropTarget2 = (ComposeSceneDragAndDropTarget)AwtDragAndDropManager.access$getDragAndDropTarget$p(this.this$0).invoke();
                dragAndDropTarget2.onExited(event);
                dragAndDropTarget2.onEnded(event);
            }

            public void dragOver(@NotNull DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragAndDropEvent event = this.DragAndDropEvent(dtde);
                ComposeSceneDragAndDropTarget dragAndDropTarget2 = (ComposeSceneDragAndDropTarget)AwtDragAndDropManager.access$getDragAndDropTarget$p(this.this$0).invoke();
                dragAndDropTarget2.onMoved(event);
                if (dragAndDropTarget2.getHasEligibleDropTarget()) {
                    dtde.acceptDrag(dtde.getDropAction());
                } else {
                    dtde.rejectDrag();
                }
            }

            public void dropActionChanged(@NotNull DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragAndDropEvent event = this.DragAndDropEvent(dtde);
                ComposeSceneDragAndDropTarget dragAndDropTarget2 = (ComposeSceneDragAndDropTarget)AwtDragAndDropManager.access$getDragAndDropTarget$p(this.this$0).invoke();
                dragAndDropTarget2.onChanged(event);
            }

            public void drop(@NotNull DropTargetDropEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragAndDropEvent event = this.DragAndDropEvent(dtde);
                dtde.acceptDrop(dtde.getDropAction());
                ComposeSceneDragAndDropTarget dragAndDropTarget2 = (ComposeSceneDragAndDropTarget)AwtDragAndDropManager.access$getDragAndDropTarget$p(this.this$0).invoke();
                dtde.dropComplete(dragAndDropTarget2.onDrop(event));
                dragAndDropTarget2.onEnded(event);
            }

            private final DragAndDropEvent DragAndDropEvent(DropTargetDragEvent dragEvent) {
                DragAndDropTransferAction dragAndDropTransferAction = AwtDragAndDropManager_desktopKt.fromAwtAction(DragAndDropTransferAction.Companion, dragEvent.getDropAction());
                Point point = dragEvent.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
                return new DragAndDropEvent(dragAndDropTransferAction, dragEvent, AwtDragAndDropManager.access$toOffset-tuRUvjQ(this.this$0, point), null);
            }

            private final DragAndDropEvent DragAndDropEvent(DropTargetDropEvent dropEvent) {
                DragAndDropTransferAction dragAndDropTransferAction = AwtDragAndDropManager_desktopKt.fromAwtAction(DragAndDropTransferAction.Companion, dropEvent.getDropAction());
                Point point = dropEvent.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
                return new DragAndDropEvent(dragAndDropTransferAction, dropEvent, AwtDragAndDropManager.access$toOffset-tuRUvjQ(this.this$0, point), null);
            }

            private final DragAndDropEvent DragAndDropEvent(DropTargetEvent dropEvent) {
                long l = Offset.Companion.getZero-F1C5BW0();
                return new DragAndDropEvent(null, dropEvent, l, null);
            }
        };
        this.transferHandler = new ComposeTransferHandler(this.rootContainer);
        this.dropTarget = new DropTarget(this.rootContainer, 0x40000003, this.dropTargetListener, true);
    }

    private final Density getDensity() {
        return LayoutConfiguration_desktopKt.getDensity(this.rootContainer);
    }

    private final float getScale() {
        return this.getDensity().getDensity();
    }

    private final long toOffset-tuRUvjQ(Point $this$toOffset_u2dtuRUvjQ) {
        float scale2 = this.getScale();
        return OffsetKt.Offset((float)$this$toOffset_u2dtuRUvjQ.x * scale2, (float)$this$toOffset_u2dtuRUvjQ.y * scale2);
    }

    @Override
    public boolean isRequestDragAndDropTransferSupported() {
        return true;
    }

    @Override
    public void requestDragAndDropTransfer-Uv8p0NA(@NotNull PlatformDragAndDropSource source, long offset2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Ref.BooleanRef isTransferStarted = new Ref.BooleanRef();
        PlatformDragAndDropSource.StartTransferScope startTransferScope2 = new PlatformDragAndDropSource.StartTransferScope(isTransferStarted, this){
            final /* synthetic */ Ref.BooleanRef $isTransferStarted;
            final /* synthetic */ AwtDragAndDropManager this$0;
            {
                this.$isTransferStarted = $isTransferStarted;
                this.this$0 = $receiver;
            }

            public boolean startDragAndDropTransfer-12SF9DM(@NotNull DragAndDropTransferData transferData, long decorationSize, @NotNull Function1<? super DrawScope, Unit> drawDragDecoration) {
                Intrinsics.checkNotNullParameter((Object)transferData, (String)"transferData");
                Intrinsics.checkNotNullParameter(drawDragDecoration, (String)"drawDragDecoration");
                this.$isTransferStarted.element = AwtDragAndDropManager.access$startDrag-12SF9DM(this.this$0, transferData, decorationSize, drawDragDecoration);
                return this.$isTransferStarted.element;
            }
        };
        PlatformDragAndDropSource $this$requestDragAndDropTransfer_Uv8p0NA_u24lambda_u240 = source;
        boolean bl = false;
        $this$requestDragAndDropTransfer_Uv8p0NA_u24lambda_u240.startDragAndDropTransfer-d-4ec7I(startTransferScope2, offset2, (Function0<Boolean>)((Function0)new Function0<Boolean>(isTransferStarted){
            final /* synthetic */ Ref.BooleanRef $isTransferStarted;
            {
                this.$isTransferStarted = $isTransferStarted;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$isTransferStarted.element;
            }
        }));
    }

    private final boolean startDrag-12SF9DM(DragAndDropTransferData transferData, long decorationSize, Function1<? super DrawScope, Unit> drawDragDecoration) {
        Density density = this.getDensity();
        LayoutDirection layoutDirection = LayoutConfiguration_desktopKt.layoutDirectionFor(this.rootContainer);
        this.transferHandler.startOutgoingTransfer-0AR0LA0(transferData, this.renderDragImage-Cqks5Fs(decorationSize, density, layoutDirection, drawDragDecoration), transferData.getDragDecorationOffset-F1C5BW0());
        return true;
    }

    private final Image renderDragImage-Cqks5Fs(long size2, Density density, LayoutDirection layoutDirection, Function1<? super DrawScope, Unit> drawDragDecoration) {
        CanvasDrawScope canvasScope;
        ImageBitmap imageBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default(MathKt.roundToInt((float)Size.getWidth-impl(size2)), MathKt.roundToInt((float)Size.getHeight-impl(size2)), 0, false, null, 28, null);
        Canvas canvas = CanvasKt.Canvas(imageBitmap);
        CanvasDrawScope this_$iv = canvasScope = new CanvasDrawScope();
        boolean bl = false;
        CanvasDrawScope.DrawParams drawParams = this_$iv.getDrawParams();
        Density prevDensity$iv = drawParams.component1();
        LayoutDirection prevLayoutDirection$iv = drawParams.component2();
        Canvas prevCanvas$iv = drawParams.component3();
        long prevSize$iv = drawParams.component4-NH-jbRc();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u240$iv = this_$iv.getDrawParams();
        boolean bl2 = false;
        $this$draw_yzxVdVo_u24lambda_u240$iv.setDensity(density);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setLayoutDirection(layoutDirection);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setCanvas(canvas);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setSize-uvyYCjk(size2);
        canvas.save();
        drawDragDecoration.invoke((Object)this_$iv);
        canvas.restore();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u241$iv = this_$iv.getDrawParams();
        boolean bl3 = false;
        $this$draw_yzxVdVo_u24lambda_u241$iv.setDensity(prevDensity$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setLayoutDirection(prevLayoutDirection$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setCanvas(prevCanvas$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setSize-uvyYCjk(prevSize$iv);
        return PlatformAdaptations.Companion.dragImage(DesktopImageConverters_desktopKt.toAwtImage(imageBitmap), density.getDensity());
    }

    @NotNull
    public final ComposeTransferHandler getTransferHandler() {
        return this.transferHandler;
    }

    @NotNull
    public final DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public static final /* synthetic */ boolean access$startDrag-12SF9DM(AwtDragAndDropManager $this, DragAndDropTransferData transferData, long decorationSize, Function1 drawDragDecoration) {
        return $this.startDrag-12SF9DM(transferData, decorationSize, (Function1<? super DrawScope, Unit>)drawDragDecoration);
    }

    public static final /* synthetic */ Function0 access$getDragAndDropTarget$p(AwtDragAndDropManager $this) {
        return $this.dragAndDropTarget;
    }

    public static final /* synthetic */ long access$toOffset-tuRUvjQ(AwtDragAndDropManager $this, Point $receiver) {
        return $this.toOffset-tuRUvjQ($receiver);
    }
}

