/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.session;

import com.intellij.codeInsight.inline.completion.session.InlineCompletionSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/inline/completion/impl/session/MLCompletionSession;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFile", "()Lcom/intellij/psi/PsiFile;", "initialState", "Lcom/intellij/ml/inline/completion/impl/session/MLCompletionSession$State;", "myPosition", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/psi/PsiElement;", "position", "getPosition", "()Lcom/intellij/psi/PsiElement;", "initializePosition", "", "initializePosition$intellij_fullLine_core_completion", "isValid", "", "captureState", "State", "Companion", "intellij.fullLine.core.completion"})
public final class MLCompletionSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final State initialState;
    @NotNull
    private final AtomicReference<PsiElement> myPosition;
    @NotNull
    private static final AtomicReference<MLCompletionSession> instance = new AtomicReference<Object>(null);

    private MLCompletionSession(Editor editor2, PsiFile file2) {
        this.editor = editor2;
        this.file = file2;
        this.initialState = this.captureState();
        this.myPosition = new AtomicReference<Object>(null);
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @Nullable
    public final PsiElement getPosition() {
        return this.myPosition.get();
    }

    @RequiresReadLock
    public final void initializePosition$intellij_fullLine_core_completion(@NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        ThreadingAssertions.assertReadAccess();
        this.myPosition.set(position);
    }

    @RequiresReadLock
    public final boolean isValid() {
        ThreadingAssertions.assertReadAccess();
        if (!Intrinsics.areEqual((Object)this.captureState(), (Object)this.initialState) || !this.file.isValid()) {
            return false;
        }
        PsiElement psiElement = this.getPosition();
        return !(psiElement != null ? !psiElement.isValid() : false);
    }

    private final State captureState() {
        return new State(this.editor.getDocument().getModificationStamp());
    }

    public /* synthetic */ MLCompletionSession(Editor editor2, PsiFile file2, DefaultConstructorMarker $constructor_marker) {
        this(editor2, file2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\fJ\b\u0010\r\u001a\u0004\u0018\u00010\u0006R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/inline/completion/impl/session/MLCompletionSession$Companion;", "", "<init>", "()V", "instance", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/ml/inline/completion/impl/session/MLCompletionSession;", "createIfPossible", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "createIfPossible$intellij_fullLine_core_completion", "getOrNull", "intellij.fullLine.core.completion"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock
        @Nullable
        public final MLCompletionSession createIfPossible$intellij_fullLine_core_completion(@NotNull Editor editor2, @NotNull PsiFile file2) {
            InlineCompletionSession disposable;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            ThreadingAssertions.assertReadAccess();
            MLCompletionSession result2 = (MLCompletionSession)instance.get();
            if (result2 == null && (disposable = InlineCompletionSession.Companion.getOrNull(editor2)) != null) {
                result2 = new MLCompletionSession(editor2, file2, null);
                if (instance.compareAndSet(null, result2)) {
                    DisposerUtilKt.whenDisposed((Disposable)((Disposable)disposable), Companion::createIfPossible$lambda$0);
                }
            }
            return result2;
        }

        @Nullable
        public final MLCompletionSession getOrNull() {
            return (MLCompletionSession)instance.get();
        }

        private static final Unit createIfPossible$lambda$0() {
            instance.set(null);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/inline/completion/impl/session/MLCompletionSession$State;", "", "documentStamp", "", "<init>", "(J)V", "getDocumentStamp", "()J", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.fullLine.core.completion"})
    private static final class State {
        private final long documentStamp;

        public State(long documentStamp) {
            this.documentStamp = documentStamp;
        }

        public final long getDocumentStamp() {
            return this.documentStamp;
        }

        public final long component1() {
            return this.documentStamp;
        }

        @NotNull
        public final State copy(long documentStamp) {
            return new State(documentStamp);
        }

        public static /* synthetic */ State copy$default(State state, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = state.documentStamp;
            }
            return state.copy(l);
        }

        @NotNull
        public String toString() {
            return "State(documentStamp=" + this.documentStamp + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.documentStamp);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            return this.documentStamp == state.documentStamp;
        }
    }
}

