/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.impl.feedback.ide;

import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.impl.feedback.FeedbackSurveyStateComponent;
import org.jetbrains.completion.full.line.impl.feedback.ide.FullLineInIdeContextSurveyDialog;
import org.jetbrains.completion.full.line.impl.feedback.ide.FullLineInIdeFeedbackSurveyConfigKt;
import org.jetbrains.completion.full.line.impl.feedback.ide.FullLineInIdeMultilineSurveyDialog;
import org.jetbrains.completion.full.line.impl.feedback.ide.SurveyConfigProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "<init>", "()V", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "updateStateAfterDialogClosedOk", "", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "getRequireIdeEAP", "()Z", "checkIdeIsSuitable", "checkExtraConditionSatisfied", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "updateStateAfterNotificationShowed", "SurveyConfig", "intellij.fullLine.core.impl"})
public final class FullLineInIdeFeedbackSurveyConfig
implements InIdeFeedbackSurveyConfig {
    @NotNull
    private final String surveyId;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2025, 5, 1);
    private final boolean requireIdeEAP;

    public FullLineInIdeFeedbackSurveyConfig() {
        this.surveyId = "full_line_completion_survey";
    }

    @NotNull
    public BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SurveyConfig config = SurveyConfigProvider.INSTANCE.getConfig();
        if (!(config != null)) {
            boolean bl = false;
            String string = "Full Line Feedback Survey is not supported in this IDE";
            throw new IllegalArgumentException(string.toString());
        }
        return config.createFeedbackDialog(project, forTest);
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return SurveyConfigProvider.INSTANCE.isSupported();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SurveyConfig config = SurveyConfigProvider.INSTANCE.getConfig();
        if (config == null) {
            return false;
        }
        if (!SurveyConfigProvider.INSTANCE.isSupported()) {
            return false;
        }
        FeedbackSurveyStateComponent feedbackState = FeedbackSurveyStateComponent.Companion.getInstance();
        if (feedbackState.isNotificationShown() || feedbackState.getSessionsCount() < FullLineInIdeFeedbackSurveyConfigKt.getSessionsToNotify()) {
            return false;
        }
        return !(FullLineInIdeFeedbackSurveyConfigKt.getCoefficientThreshold() > config.getCoefficient());
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new RequestFeedbackNotification("Full Line Completion Plugin", "Built-in AI Completion Feedback", "Help us improve the local completion feature by sharing your feedback");
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FeedbackSurveyStateComponent.Companion.getInstance().fireNotificationShown();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig$SurveyConfig;", "", "coefficient", "", "<init>", "(Ljava/lang/String;ID)V", "getCoefficient", "()D", "IdeaUltimate", "PyCharm", "WebStorm", "Rider", "PhpStorm", "GoIde", "RubyMine", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "intellij.fullLine.core.impl"})
    public static final abstract class SurveyConfig
    extends Enum<SurveyConfig> {
        private final double coefficient;
        public static final /* enum */ SurveyConfig IdeaUltimate = new IdeaUltimate("IdeaUltimate", 0);
        public static final /* enum */ SurveyConfig PyCharm = new PyCharm("PyCharm", 1);
        public static final /* enum */ SurveyConfig WebStorm = new WebStorm("WebStorm", 2);
        public static final /* enum */ SurveyConfig Rider = new Rider("Rider", 3);
        public static final /* enum */ SurveyConfig PhpStorm = new PhpStorm("PhpStorm", 4);
        public static final /* enum */ SurveyConfig GoIde = new GoIde("GoIde", 5);
        public static final /* enum */ SurveyConfig RubyMine = new RubyMine("RubyMine", 6);
        private static final /* synthetic */ SurveyConfig[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SurveyConfig(double coefficient) {
            this.coefficient = coefficient;
        }

        public final double getCoefficient() {
            return this.coefficient;
        }

        @NotNull
        public abstract BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project var1, boolean var2);

        public static SurveyConfig[] values() {
            return (SurveyConfig[])$VALUES.clone();
        }

        public static SurveyConfig valueOf(String value) {
            return Enum.valueOf(SurveyConfig.class, value);
        }

        @NotNull
        public static EnumEntries<SurveyConfig> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ SurveyConfig(String $enum$name, int $enum$ordinal, double coefficient, DefaultConstructorMarker $constructor_marker) {
            this(coefficient);
        }

        static {
            $VALUES = surveyConfigArray = new SurveyConfig[]{SurveyConfig.IdeaUltimate, SurveyConfig.PyCharm, SurveyConfig.WebStorm, SurveyConfig.Rider, SurveyConfig.PhpStorm, SurveyConfig.GoIde, SurveyConfig.RubyMine};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig.SurveyConfig.GoIde", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig$SurveyConfig;", "createFeedbackDialog", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeContextSurveyDialog;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "intellij.fullLine.core.impl"})
        static final class GoIde
        extends SurveyConfig {
            /*
             * WARNING - void declaration
             */
            GoIde() {
                void var1_1;
            }

            @NotNull
            public FullLineInIdeContextSurveyDialog createFeedbackDialog(@NotNull Project project, boolean forTest) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return new FullLineInIdeContextSurveyDialog(project, forTest);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig.SurveyConfig.IdeaUltimate", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig$SurveyConfig;", "createFeedbackDialog", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeContextSurveyDialog;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "intellij.fullLine.core.impl"})
        static final class IdeaUltimate
        extends SurveyConfig {
            /*
             * WARNING - void declaration
             */
            IdeaUltimate() {
                void var1_1;
            }

            @NotNull
            public FullLineInIdeContextSurveyDialog createFeedbackDialog(@NotNull Project project, boolean forTest) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return new FullLineInIdeContextSurveyDialog(project, forTest);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig.SurveyConfig.PhpStorm", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig$SurveyConfig;", "createFeedbackDialog", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeContextSurveyDialog;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "intellij.fullLine.core.impl"})
        static final class PhpStorm
        extends SurveyConfig {
            /*
             * WARNING - void declaration
             */
            PhpStorm() {
                void var1_1;
            }

            @NotNull
            public FullLineInIdeContextSurveyDialog createFeedbackDialog(@NotNull Project project, boolean forTest) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return new FullLineInIdeContextSurveyDialog(project, forTest);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig.SurveyConfig.PyCharm", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig$SurveyConfig;", "createFeedbackDialog", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeMultilineSurveyDialog;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "intellij.fullLine.core.impl"})
        static final class PyCharm
        extends SurveyConfig {
            /*
             * WARNING - void declaration
             */
            PyCharm() {
                void var1_1;
            }

            @NotNull
            public FullLineInIdeMultilineSurveyDialog createFeedbackDialog(@NotNull Project project, boolean forTest) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return new FullLineInIdeMultilineSurveyDialog(project, forTest);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig.SurveyConfig.Rider", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig$SurveyConfig;", "createFeedbackDialog", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeContextSurveyDialog;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "intellij.fullLine.core.impl"})
        static final class Rider
        extends SurveyConfig {
            /*
             * WARNING - void declaration
             */
            Rider() {
                void var1_1;
            }

            @NotNull
            public FullLineInIdeContextSurveyDialog createFeedbackDialog(@NotNull Project project, boolean forTest) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return new FullLineInIdeContextSurveyDialog(project, forTest);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig.SurveyConfig.RubyMine", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig$SurveyConfig;", "createFeedbackDialog", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeContextSurveyDialog;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "intellij.fullLine.core.impl"})
        static final class RubyMine
        extends SurveyConfig {
            /*
             * WARNING - void declaration
             */
            RubyMine() {
                void var1_1;
            }

            @NotNull
            public FullLineInIdeContextSurveyDialog createFeedbackDialog(@NotNull Project project, boolean forTest) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return new FullLineInIdeContextSurveyDialog(project, forTest);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig.SurveyConfig.WebStorm", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig$SurveyConfig;", "createFeedbackDialog", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeContextSurveyDialog;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "intellij.fullLine.core.impl"})
        static final class WebStorm
        extends SurveyConfig {
            /*
             * WARNING - void declaration
             */
            WebStorm() {
                void var1_1;
            }

            @NotNull
            public FullLineInIdeContextSurveyDialog createFeedbackDialog(@NotNull Project project, boolean forTest) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return new FullLineInIdeContextSurveyDialog(project, forTest);
            }
        }
    }
}

