/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.serialization;

import com.intellij.platform.runtime.repository.MalformedRepositoryException;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import com.intellij.platform.runtime.repository.impl.RuntimeModuleRepositoryImpl;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleRepositoryData;
import com.intellij.platform.runtime.repository.serialization.impl.JarFileSerializer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RuntimeModuleRepositorySerialization {
    private RuntimeModuleRepositorySerialization() {
    }

    public static void saveToJar(@NotNull Collection<RawRuntimeModuleDescriptor> descriptors, @Nullable String bootstrapModuleName, @NotNull Path jarPath, int generatorVersion) throws IOException {
        if (descriptors == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(0);
        }
        if (jarPath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(1);
        }
        RuntimeModuleRepositorySerialization.saveToJar(descriptors, bootstrapModuleName, jarPath, null, generatorVersion);
    }

    public static void saveToJar(@NotNull Collection<RawRuntimeModuleDescriptor> descriptors, @Nullable String bootstrapModuleName, @NotNull Path jarPath, @Nullable String mainPluginModuleId, int generatorVersion) throws IOException {
        if (descriptors == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(2);
        }
        if (jarPath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(3);
        }
        try {
            JarFileSerializer.saveToJar(descriptors, bootstrapModuleName, jarPath, mainPluginModuleId, generatorVersion);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public static RawRuntimeModuleRepositoryData loadFromJar(@NotNull Path jarPath) throws MalformedRepositoryException {
        RawRuntimeModuleRepositoryData rawRuntimeModuleRepositoryData;
        if (jarPath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(4);
        }
        try {
            rawRuntimeModuleRepositoryData = JarFileSerializer.loadFromJar(jarPath);
        }
        catch (IOException | XMLStreamException e) {
            throw new MalformedRepositoryException("Failed to load repository from " + String.valueOf(jarPath), e);
        }
        if (rawRuntimeModuleRepositoryData == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(5);
        }
        return rawRuntimeModuleRepositoryData;
    }

    @NotNull
    public static RuntimeModuleRepository loadFromRawData(@NotNull Path descriptorsJarPath, @NotNull RawRuntimeModuleRepositoryData rawRuntimeModuleRepositoryData) {
        if (descriptorsJarPath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(6);
        }
        if (rawRuntimeModuleRepositoryData == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(7);
        }
        return new RuntimeModuleRepositoryImpl(descriptorsJarPath, rawRuntimeModuleRepositoryData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/repository/serialization/RuntimeModuleRepositorySerialization";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorsJarPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawRuntimeModuleRepositoryData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/repository/serialization/RuntimeModuleRepositorySerialization";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromJar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveToJar";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadFromJar";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadFromRawData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

