/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.web.symbols;

import com.intellij.model.Symbol;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.webSymbols.PsiSourcedWebSymbol;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.codeInsight.documentation.VueDocumentedItem;
import org.jetbrains.vuejs.codeInsight.documentation.VueItemDocumentation;
import org.jetbrains.vuejs.model.VueSourceElement;
import org.jetbrains.vuejs.web.symbols.VueWebSymbolBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0007\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lorg/jetbrains/vuejs/web/symbols/VueDocumentedItemSymbol;", "T", "Lorg/jetbrains/vuejs/codeInsight/documentation/VueDocumentedItem;", "Lorg/jetbrains/vuejs/web/symbols/VueWebSymbolBase;", "Lcom/intellij/webSymbols/PsiSourcedWebSymbol;", "name", "", "item", "<init>", "(Ljava/lang/String;Lorg/jetbrains/vuejs/codeInsight/documentation/VueDocumentedItem;)V", "getName", "()Ljava/lang/String;", "getItem", "()Lorg/jetbrains/vuejs/codeInsight/documentation/VueDocumentedItem;", "Lorg/jetbrains/vuejs/codeInsight/documentation/VueDocumentedItem;", "source", "Lcom/intellij/psi/PsiElement;", "getSource", "()Lcom/intellij/psi/PsiElement;", "rawSource", "getRawSource", "description", "getDescription", "presentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "getPresentation", "()Lcom/intellij/platform/backend/presentation/TargetPresentation;", "equals", "", "other", "", "hashCode", "", "isEquivalentTo", "symbol", "Lcom/intellij/model/Symbol;", "intellij.vuejs"})
public abstract class VueDocumentedItemSymbol<T extends VueDocumentedItem>
extends VueWebSymbolBase
implements PsiSourcedWebSymbol {
    @NotNull
    private final String name;
    @NotNull
    private final T item;

    public VueDocumentedItemSymbol(@NotNull String name, @NotNull T item) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.name = name;
        this.item = item;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    protected final T getItem() {
        return this.item;
    }

    @Nullable
    public PsiElement getSource() {
        return ((VueSourceElement)this.item).getSource();
    }

    @Nullable
    public final PsiElement getRawSource() {
        return ((VueSourceElement)this.item).getRawSource();
    }

    @Nullable
    public String getDescription() {
        return this.item.getDescription();
    }

    @NotNull
    public TargetPresentation getPresentation() {
        Object[] objectArray = new Object[]{VueItemDocumentation.Companion.typeOf((VueDocumentedItem)this.item), this.getName()};
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(VueBundle.message("vue.symbol.presentation", objectArray)).icon(this.getIcon()).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof VueDocumentedItemSymbol && Intrinsics.areEqual(other.getClass(), this.getClass()) && Intrinsics.areEqual((Object)this.getName(), (Object)((VueDocumentedItemSymbol)other).getName()) && Intrinsics.areEqual(this.item, ((VueDocumentedItemSymbol)other).item);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getName(), this.item};
        return Objects.hash(objectArray);
    }

    public boolean isEquivalentTo(@NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        return symbol instanceof VueDocumentedItemSymbol ? symbol == this || Intrinsics.areEqual(symbol.getClass(), this.getClass()) && Intrinsics.areEqual((Object)((VueDocumentedItemSymbol)symbol).getName(), (Object)this.getName()) : super.isEquivalentTo(symbol);
    }
}

