/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.codeInsight;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.dbt.DbtBundle;
import com.intellij.dbt.DbtModuleEntity;
import com.intellij.dbt.DbtUtils;
import com.intellij.dbt.codeInsight.MyQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/dbt/codeInsight/DbtConfigurationInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.dbt"})
public final class DbtConfigurationInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!isOnTheFly || !(file instanceof SqlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module2 = module;
        DbtModuleEntity dbtModuleEntity = DbtUtils.Companion.getDbtSettings(module2);
        if (dbtModuleEntity == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DbtModuleEntity dbtSettings = dbtModuleEntity;
        if (!dbtSettings.getReviewed()) {
            MyQuickFix[] myQuickFixArray = new MyQuickFix[]{new MyQuickFix()};
            ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)file, DbtBundle.message("dbt.configuration.inspection.name", new Object[0]), true, (LocalQuickFix[])myQuickFixArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
            ProblemDescriptor descriptor = problemDescriptor;
            ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[]{descriptor};
            return problemDescriptorArray;
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }
}

