/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.python;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.packageChecker.service.VulnerableApiService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/packageChecker/python/PyVulnerableApiCodeInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.packageChecker.python"})
public final class PyVulnerableApiCodeInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)holder.getFile()));
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module2 = module;
        if (!VulnerableApiService.Companion.getInstance(module2).vulnerablePathsExisted()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext((LocalInspectionToolSession)session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext, module2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/packageChecker/python/PyVulnerableApiCodeInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;Lcom/intellij/openapi/module/Module;)V", "visitPyCallExpression", "", "node", "Lcom/jetbrains/python/psi/PyCallExpression;", "intellij.packageChecker.python"})
    @SourceDebugExtension(value={"SMAP\nPyVulnerableApiCodeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyVulnerableApiCodeInspection.kt\ncom/intellij/packageChecker/python/PyVulnerableApiCodeInspection$Visitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1863#2,2:52\n*S KotlinDebug\n*F\n+ 1 PyVulnerableApiCodeInspection.kt\ncom/intellij/packageChecker/python/PyVulnerableApiCodeInspection$Visitor\n*L\n42#1:52,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @NotNull
        private final ProblemsHolder holder;
        @NotNull
        private final Module module;

        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            super(holder, context);
            this.holder = holder;
            this.module = module;
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression pyExpression = node.getCallee();
            if (pyExpression == null) {
                return;
            }
            PyExpression callee = pyExpression;
            String string = callee.getName();
            if (string == null) {
                return;
            }
            String methodName = string;
            if (!VulnerableApiService.Companion.getInstance(this.module).isSuspiciousMethodName(methodName)) {
                return;
            }
            List list = node.multiResolveCalleeFunction(this.getResolveContext());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"multiResolveCalleeFunction(...)");
            List callables = list;
            Iterable $this$forEach$iv = callables;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyCallable it = (PyCallable)element$iv;
                boolean bl = false;
                String qualifiedName = String.valueOf(it.getQualifiedName());
                boolean isVulnerable2 = VulnerableApiService.registerProblemIfVulnerable$default(VulnerableApiService.Companion.getInstance(this.module), qualifiedName, this.holder, (PsiElement)callee, null, 8, null);
                if (isVulnerable2) continue;
            }
            super.visitPyCallExpression(node);
        }
    }
}

