/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.SelectorSpecificity;
import com.intellij.psi.css.descriptor.CssCompositeElementDescriptor;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoClassDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoElementDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.util.CssCompatibilityData;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.MdnDocumentationUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.documentation.HtmlDocumentationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class CssDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider {
    @NotNull
    private final DocumentationProvider myHtmlProvider;

    public CssDocumentationProvider() {
        DocumentationProvider htmlProvider = LanguageDocumentation.INSTANCE.forLanguage((Language)HTMLLanguage.INSTANCE);
        if (htmlProvider instanceof HtmlDocumentationProvider) {
            htmlProvider = new HtmlDocumentationProvider(false);
        } else if (htmlProvider instanceof CompositeDocumentationProvider) {
            ArrayList<Object> providers = new ArrayList<Object>();
            for (DocumentationProvider provider : ((CompositeDocumentationProvider)htmlProvider).getProviders()) {
                if (provider instanceof HtmlDocumentationProvider) {
                    providers.add(new HtmlDocumentationProvider(false));
                    continue;
                }
                providers.add(provider);
            }
            htmlProvider = CompositeDocumentationProvider.wrapProviders(providers);
        }
        this.myHtmlProvider = htmlProvider;
    }

    public static String @NotNull [] getUrlsFor(@NotNull String descriptorText, PsiElement context) {
        Collection<? extends CssPropertyDescriptor> descriptors;
        if (descriptorText == null) {
            CssDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (!(descriptors = CssDescriptorsUtil.sortDescriptors(CssDescriptorsUtil.getPropertyDescriptors(descriptorText, context))).isEmpty()) {
            LinkedHashSet urls = new LinkedHashSet();
            for (CssElementDescriptor cssElementDescriptor : descriptors) {
                ContainerUtil.addIfNotNull(urls, (Object)cssElementDescriptor.getSpecificationUrl());
            }
            String[] stringArray = ArrayUtilRt.toStringArray(urls);
            if (stringArray == null) {
                CssDocumentationProvider.$$$reportNull$$$0(1);
            }
            return stringArray;
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            CssDocumentationProvider.$$$reportNull$$$0(2);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Nls
    @Nullable
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls, boolean onHover) {
        if (element instanceof CssDescriptorOwner) {
            return null;
        }
        PsiElement tagElement = (PsiElement)ReadAction.compute(() -> CssDocumentationProvider.findTagElement(element));
        if (tagElement != null && this.myHtmlProvider instanceof ExternalDocumentationProvider) {
            return ((ExternalDocumentationProvider)this.myHtmlProvider).fetchExternalDocumentation(project, tagElement, docUrls, onHover);
        }
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return false;
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    @Nls
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, @Nullable PsiElement originalElement) {
        ItemPresentation presentation;
        CssSelectorSuffixType suffixType;
        if (element instanceof CssSelectorSuffix && (suffixType = ((CssSelectorSuffix)element).getType()) != CssSelectorSuffixType.UNKNOWN && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            String fileName = null;
            if (element.getContainingFile() != null) {
                fileName = element.getContainingFile().getName();
            }
            if (suffixType == CssSelectorSuffixType.CLASS) {
                return CssBundle.message(fileName == null ? "css.class.term" : "css.class.term.with.file", presentation.getPresentableText(), fileName);
            }
            return CssBundle.message(fileName == null ? "css.id.term" : "css.id.term.with.file", presentation.getPresentableText(), fileName);
        }
        return null;
    }

    public @Unmodifiable List<String> getUrlFor(PsiElement element, @Nullable PsiElement originalElement) {
        MdnSymbolDocumentation mdnDoc;
        PsiElement docElement = CssDocumentationProvider.findDocumentationElement(element);
        MdnSymbolDocumentation mdnSymbolDocumentation = mdnDoc = docElement != null ? MdnDocumentationUtil.getMdnDocumentation(docElement, originalElement) : null;
        if (mdnDoc != null) {
            return ContainerUtil.packNullables((Object[])new String[]{mdnDoc.getUrl()});
        }
        if (docElement instanceof CssDescriptorOwner) {
            PsiElement context = originalElement != null ? originalElement : docElement;
            for (CssElementDescriptor cssElementDescriptor : CssDocumentationProvider.getFilteredAndSortedDescriptors((CssDescriptorOwner)docElement, context)) {
                String specificationUrl = cssElementDescriptor.getSpecificationUrl();
                if (specificationUrl == null) continue;
                return Collections.singletonList(specificationUrl);
            }
            return Collections.emptyList();
        }
        PsiElement tagElement = CssDocumentationProvider.findTagElement(element);
        if (tagElement != null) {
            return this.myHtmlProvider.getUrlFor(tagElement, null);
        }
        return null;
    }

    @Nullable
    public static PsiElement findDocumentationElement(@Nullable PsiElement element) {
        PsiElement context;
        if (element == null) {
            return null;
        }
        if (element instanceof CssDescriptorOwner || element instanceof CssAtRule || element instanceof CssUri || element instanceof CssImport || element instanceof CssSelectorSuffix || CssUtil.isCssDeclaration(element) || CssPsiUtil.isInFunction(element)) {
            return element;
        }
        CssElement docTarget = CssDocumentationProvider.findDocumentationTarget(element);
        if (docTarget != null) {
            return docTarget;
        }
        PsiElement prevContext = element;
        if (context instanceof PsiFile) {
            while (prevContext.getPrevSibling() != null) {
                prevContext = prevContext.getPrevSibling();
            }
            return CssUtil.isIdent(prevContext) ? prevContext : null;
        }
        if (!(context instanceof CssElement)) {
            return null;
        }
        for (context = element.getContext(); context != null; context = context.getContext()) {
            PsiElement prevSibling = prevContext.getPrevSibling();
            if (context instanceof XmlAttributeValue && prevSibling instanceof CssBlock) {
                return prevSibling.findElementAt(prevSibling.getTextLength() - 2);
            }
            if (context instanceof CssSimpleSelector) {
                return ((CssSimpleSelector)context).getNameIdentifier();
            }
            if (context instanceof CssStylesheet || context instanceof CssDeclaration) {
                return CssDocumentationProvider.getIdent(context);
            }
            prevContext = context;
        }
        return null;
    }

    @Nullable
    private static PsiElement getIdent(@NotNull PsiElement declaration) {
        PsiElement firstChild;
        if (declaration == null) {
            CssDocumentationProvider.$$$reportNull$$$0(3);
        }
        return CssUtil.isIdent(firstChild = PsiTreeUtil.getDeepestFirst((PsiElement)declaration)) ? firstChild : null;
    }

    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String docText;
        String docText2;
        PsiElement docElement = CssDocumentationProvider.findDocumentationElement(element);
        if (docElement != null && (docText2 = CssDocumentationProvider.generateDoc(docElement.getText(), docElement, originalElement)) != null) {
            return CssDocumentationProvider.prependSelectorSpecificityIfApplicable(docElement, docText2);
        }
        PsiElement tagElement = CssDocumentationProvider.findTagElement(element);
        if (tagElement != null && (docText = this.myHtmlProvider.generateDoc(tagElement, null)) != null) {
            return CssDocumentationProvider.prependSelectorSpecificityIfApplicable(tagElement, docText);
        }
        if (docElement != null) {
            return CssDocumentationProvider.prependSelectorSpecificityIfApplicable(docElement, null);
        }
        return null;
    }

    @Contract(value="_,!null -> !null")
    @Nls
    private static String prependSelectorSpecificityIfApplicable(@NotNull PsiElement docElement, @Nullable @Nls String docText) {
        SelectorSpecificity specificity;
        if (docElement == null) {
            CssDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (CompletionService.getCompletionService().getCurrentCompletion() != null) {
            return docText;
        }
        if (CssDialectMappings.getInstance(docElement.getProject()).hasCustomDialect(docElement.getContainingFile().getVirtualFile())) {
            return docText;
        }
        CssSelector selector = (CssSelector)PsiTreeUtil.getParentOfType((PsiElement)docElement, CssSelector.class);
        SelectorSpecificity selectorSpecificity = specificity = selector != null ? selector.getSpecificity() : null;
        if (specificity != null) {
            @NlsSafe String specificityHtml = "<div class='definition'><pre>" + selector.getText() + "</pre></div>\n<div class='content'><span class='grayed'>" + CssBundle.message("doc.popup.selector.specificity", new Object[0]) + "</span> " + specificity.getPresentableText() + "</div>\n";
            return specificityHtml + StringUtil.notNullize((String)docText);
        }
        return docText;
    }

    @Nullable
    private static PsiElement findTagElement(@Nullable PsiElement element) {
        if (element instanceof CssSimpleSelector) {
            return ((CssSimpleSelector)element).getNameIdentifier();
        }
        if (element instanceof LeafPsiElement && element.getNode().getElementType() == CssElementTypes.CSS_IDENT && element.getParent() instanceof CssSimpleSelector && ((CssSimpleSelector)element.getParent()).getNameIdentifier() == element) {
            return element;
        }
        return null;
    }

    @Nullable
    @Nls
    public static String generateDoc(@Nullable String descriptorText, @NotNull PsiElement documentationElement, @Nullable PsiElement context) {
        if (documentationElement == null) {
            CssDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (descriptorText == null) {
            return null;
        }
        MdnSymbolDocumentation mdnDoc = MdnDocumentationUtil.getMdnDocumentation(documentationElement, context);
        if (mdnDoc != null) {
            return mdnDoc.getDocumentation(true);
        }
        if (documentationElement instanceof CssDescriptorOwner) {
            String valueDesc;
            Map<String, Object> mdnCompatData;
            PsiElement descriptorProviderContext = context != null ? context : documentationElement;
            Collection<? extends CssElementDescriptor> descriptors = CssDocumentationProvider.getFilteredAndSortedDescriptors((CssDescriptorOwner)documentationElement, descriptorProviderContext);
            if (descriptors.isEmpty()) {
                return null;
            }
            CssElementDescriptor latestDescriptor = descriptors.iterator().next();
            String presentableName = latestDescriptor.getPresentableName();
            String doc = latestDescriptor.getDescription();
            if (documentationElement instanceof CssDeclaration) {
                String propertyName = ((CssDeclaration)documentationElement).getPropertyName();
                CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider(documentationElement);
                if (descriptorProvider != null) {
                    propertyName = descriptorProvider.restoreFullPropertyName(propertyName, documentationElement);
                }
                mdnCompatData = CssCompatibilityData.getPropertyData(propertyName);
            } else {
                mdnCompatData = documentationElement instanceof CssPseudoSelector ? CssCompatibilityData.getPseudoSelectorData(((CssPseudoSelector)documentationElement).getName()) : null;
            }
            if (latestDescriptor instanceof CssValueOwnerDescriptor && (valueDesc = ((CssValueOwnerDescriptor)latestDescriptor).getFormalSyntax()) != null) {
                return MdnDocumentationUtil.buildDoc(presentableName, doc, mdnCompatData, ((CssValueOwnerDescriptor)latestDescriptor).getFormalSyntax(), ((CssValueOwnerDescriptor)latestDescriptor).getValuesDescription());
            }
            if (!doc.isEmpty() || mdnCompatData != null) {
                return MdnDocumentationUtil.buildDoc(presentableName, doc, mdnCompatData);
            }
            return latestDescriptor.getDocumentationString(documentationElement);
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider(context);
        if (descriptorProvider != null) {
            return descriptorProvider.generateDocForSelector(descriptorText, context);
        }
        return null;
    }

    @Nullable
    private static PsiElement createNavigationElementForDescriptorOwner(@NotNull CssElementDescriptor descriptor, @Nullable PsiElement context, @NotNull Project project) {
        if (descriptor == null) {
            CssDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            CssDocumentationProvider.$$$reportNull$$$0(7);
        }
        Language language = CssPsiUtil.getStylesheetLanguage(context);
        String id = descriptor.getId();
        if (descriptor instanceof CssPseudoSelectorDescriptor) {
            return CssElementFactory.getInstance(project).createPseudoSelector(descriptor.getPresentableName(), language);
        }
        if (descriptor instanceof CssFunctionDescriptor || descriptor instanceof CssFunctionInvocationValue) {
            CssTerm term = CssElementFactory.getInstance(project).createTerm(id + "(param)", language);
            PsiElement function = PsiTreeUtil.findChildOfAnyType((PsiElement)term, (Class[])new Class[]{CssFunction.class, CssUri.class});
            if (function == null) {
                throw new IllegalArgumentException("Can't create css function with name: " + id);
            }
            return function;
        }
        if (descriptor instanceof CssPropertyDescriptor) {
            return CssElementFactory.getInstance(project).createProperty(id, "value", language);
        }
        if (descriptor instanceof CssMediaFeatureDescriptor) {
            return CssElementFactory.getInstance(project).createMediaFeature(id, "value", language);
        }
        if (descriptor instanceof CssCompositeElementDescriptor) {
            return CssDocumentationProvider.createNavigationElementForDescriptorOwner(((CssCompositeElementDescriptor)descriptor).getDescriptorFromLatestSpec(), context, project);
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(@NotNull PsiManager psiManager, @Nullable Object object, @Nullable PsiElement element) {
        if (psiManager == null) {
            CssDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (object == null || object instanceof LiveTemplateLookupElement) {
            return null;
        }
        return CssDocumentationProvider.createNavigationElement(psiManager, object, element);
    }

    @Nullable
    private static PsiElement createNavigationElement(@NotNull PsiManager psiManager, @NotNull Object lookupObject, @Nullable PsiElement _context) {
        boolean bl;
        PsiElement docElement;
        CssElementDescriptorProvider provider;
        if (psiManager == null) {
            CssDocumentationProvider.$$$reportNull$$$0(9);
        }
        if (lookupObject == null) {
            CssDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (lookupObject instanceof CssElementDescriptor) {
            PsiElement descriptorOwner = CssDocumentationProvider.createNavigationElementForDescriptorOwner((CssElementDescriptor)lookupObject, _context, psiManager.getProject());
            if (descriptorOwner != null) {
                return descriptorOwner;
            }
        } else if (lookupObject instanceof String && ((String)lookupObject).startsWith("@")) {
            return PsiTreeUtil.findChildOfAnyType((PsiElement)CssElementFactory.getInstance(psiManager.getProject()).createStylesheet("p{" + String.valueOf(lookupObject) + "(){}}", CSSLanguage.INSTANCE), (Class[])new Class[]{CssAtRule.class, CssImport.class});
        }
        String _text = lookupObject.toString();
        Object text = _text;
        Collection<? extends CssPropertyDescriptor> propertyDescriptors = CssDescriptorsUtil.getPropertyDescriptors((String)text, _context);
        PsiElement context = CssDocumentationProvider.findDocumentationElement(_context);
        if (context == null) {
            context = _context;
        }
        if ((provider = CssDescriptorsUtil.findDescriptorProvider(context)) == null) {
            return null;
        }
        if (propertyDescriptors.isEmpty()) {
            String textFromContext = context != null ? StringUtil.notNullize((String)context.getText()).trim() : "";
            propertyDescriptors = provider.findPropertyDescriptors(textFromContext, context);
            text = textFromContext;
        }
        if (!propertyDescriptors.isEmpty()) {
            for (CssPropertyDescriptor cssPropertyDescriptor : propertyDescriptors) {
                PsiElement[] navElements = cssPropertyDescriptor.getDeclarations(_context);
                if (navElements.length != 1) continue;
                return navElements[0];
            }
        }
        if ((docElement = provider.getDocumentationElementForSelector(_text, context)) != null) {
            return docElement;
        }
        if (!propertyDescriptors.isEmpty() || context != null && !provider.providesClassicCss() && provider.isPossibleSelector((String)text, context)) {
            return CssDocumentationProvider.createDummyElement((String)text, context);
        }
        if (context != null && (bl = CssDescriptorsUtil.isPossibleSelector(_text, context)) && LanguageNamesValidation.isIdentifier((Language)CSSLanguage.INSTANCE, (String)_text, (Project)psiManager.getProject())) {
            Language language = CssPsiUtil.getStylesheetLanguage(context);
            return CssElementFactory.getInstance(psiManager.getProject()).createSimpleSelector(_text, language);
        }
        return null;
    }

    @Nullable
    private static PsiElement createDummyElement(@NotNull String text, @NotNull PsiElement context) {
        PsiFile file;
        if (text == null) {
            CssDocumentationProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            CssDocumentationProvider.$$$reportNull$$$0(12);
        }
        if ((file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)context, PsiFile.class)) == null) {
            return null;
        }
        FileElement fileElement = DummyHolderFactory.createHolder((PsiManager)context.getManager(), null).getTreeElement();
        CssTokenImpl cssToken = new CssTokenImpl(CssElementTypes.CSS_IDENT, fileElement.getCharTable().intern((CharSequence)text));
        fileElement.rawAddChildren((TreeElement)cssToken);
        cssToken.putUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY, SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(context));
        return cssToken;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(@NotNull PsiManager psiManager, @NotNull String link, @Nullable PsiElement context) {
        if (psiManager == null) {
            CssDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (link == null) {
            CssDocumentationProvider.$$$reportNull$$$0(14);
        }
        Collection<Object> descriptors = Collections.emptyList();
        if (link.startsWith("PC:")) {
            descriptors = ContainerUtil.filter(CssDescriptorsUtil.getPseudoSelectorDescriptors(StringUtil.trimStart((String)link, (String)"PC:"), context), (Condition)Conditions.instanceOf(CssPseudoClassDescriptor.class));
        } else if (link.startsWith("PE:")) {
            descriptors = ContainerUtil.filter(CssDescriptorsUtil.getPseudoSelectorDescriptors(StringUtil.trimStart((String)link, (String)"PE:"), context), (Condition)Conditions.instanceOf(CssPseudoElementDescriptor.class));
        } else if (link.startsWith("MF:")) {
            descriptors = CssDescriptorsUtil.getMediaFeatureDescriptors(StringUtil.trimStart((String)link, (String)"MF:"), context);
        } else if (link.startsWith("P:")) {
            descriptors = CssDescriptorsUtil.getPropertyDescriptors(StringUtil.trimStart((String)link, (String)"P:"), context);
        } else if (link.startsWith("F:")) {
            descriptors = CssDescriptorsUtil.getFunctionDescriptors(StringUtil.trimStart((String)link, (String)"F:"), context);
        }
        CssElementDescriptor firstDescriptor = (CssElementDescriptor)ContainerUtil.getFirstItem(CssDescriptorsUtil.sortDescriptors(descriptors));
        return CssDocumentationProvider.createNavigationElement(psiManager, Objects.requireNonNullElse(firstDescriptor, link), context);
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        CssElement docTarget;
        if (editor == null) {
            CssDocumentationProvider.$$$reportNull$$$0(15);
        }
        if (file == null) {
            CssDocumentationProvider.$$$reportNull$$$0(16);
        }
        if ((docTarget = CssDocumentationProvider.findDocumentationTarget(contextElement)) != null) {
            return docTarget;
        }
        if (contextElement instanceof LeafPsiElement && contextElement.getNode().getElementType() == CssElementTypes.CSS_IDENT && contextElement.getParent() instanceof CssSimpleSelector && ((CssSimpleSelector)contextElement.getParent()).getNameIdentifier() == contextElement) {
            return contextElement;
        }
        return null;
    }

    @Nullable
    private static CssElement findDocumentationTarget(@Nullable PsiElement context) {
        if (context instanceof CssTokenImpl && ((CssTokenImpl)context).getElementType() == CssElementTypes.CSS_IMPORT_SYM) {
            return (CssElement)ObjectUtils.tryCast((Object)context.getParent(), CssImport.class);
        }
        CssElement target = (CssElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssDescriptorOwner.class, CssUri.class, CssAtRule.class});
        return target instanceof CssDescriptorOwner && target.getParent() instanceof CssPseudoSelector ? (CssDescriptorOwner)target.getParent() : target;
    }

    @NotNull
    private static Collection<? extends CssElementDescriptor> getFilteredAndSortedDescriptors(@NotNull CssDescriptorOwner descriptorOwner, @NotNull PsiElement descriptorProviderContext) {
        Collection<? extends CssElementDescriptor> descriptors;
        Collection<? extends CssElementDescriptor> filteredByContext;
        if (descriptorOwner == null) {
            CssDocumentationProvider.$$$reportNull$$$0(17);
        }
        if (descriptorProviderContext == null) {
            CssDocumentationProvider.$$$reportNull$$$0(18);
        }
        if (!(filteredByContext = CssDescriptorsUtil.filterDescriptorsByContext(descriptors = descriptorOwner.getDescriptors(descriptorProviderContext), descriptorProviderContext)).isEmpty()) {
            descriptors = filteredByContext;
        }
        Collection<? extends CssElementDescriptor> collection = descriptors = CssDescriptorsUtil.sortDescriptors(descriptors);
        if (collection == null) {
            CssDocumentationProvider.$$$reportNull$$$0(19);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorText";
                break;
            }
            case 1: 
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssDocumentationProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentationElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupObject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorOwner";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorProviderContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssDocumentationProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlsFor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredAndSortedDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUrlsFor";
                break;
            }
            case 1: 
            case 2: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIdent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prependSelectorSpecificityIfApplicable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationElementForDescriptorOwner";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElementForLookupItem";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDummyElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElementForLink";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredAndSortedDescriptors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 19 -> new IllegalStateException(string);
        };
    }
}

