/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import org.jetbrains.annotations.NotNull;

public final class CssHexColorsFormatPreprocessor
implements PreFormatProcessor,
PsiRecursiveVisitor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiElement psiElement;
        if (element == null) {
            CssHexColorsFormatPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            CssHexColorsFormatPreprocessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = element.getPsi()) == null || !psiElement.isValid()) {
            TextRange textRange = range;
            if (textRange == null) {
                CssHexColorsFormatPreprocessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        if (!psiElement.getLanguage().isKindOf((Language)CSSLanguage.INSTANCE) && !CssSupportLoader.isInFileThatSupportsEmbeddedCss(psiElement)) {
            TextRange textRange = range;
            if (textRange == null) {
                CssHexColorsFormatPreprocessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        TextRange textRange = new CssHexColorsFormatter(psiElement).process(range);
        if (textRange == null) {
            CssHexColorsFormatPreprocessor.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/editor/CssHexColorsFormatPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssHexColorsFormatPreprocessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class CssHexColorsFormatter
    extends CssElementVisitor {
        private Project myProject;
        private PsiElement myElement;
        private PsiDocumentManager myDocumentManager;
        private Document myDocument;
        private CssCodeStyleSettings myCssFormattingSettings;
        private TextRange myRange;
        private TextRange myOrigRange;
        private int myDelta = 0;

        CssHexColorsFormatter(PsiElement element) {
            try {
                this.myProject = element.getProject();
                this.myElement = element;
                PsiFile file = element.getContainingFile();
                this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                this.myDocument = this.myDocumentManager.getDocument(file);
                Language language = CssPsiUtil.getStylesheetLanguage(element);
                CssSupportedFileTypesProvider provider = language == null ? null : CssSupportedFileTypesProvider.findProvider(language);
                Class<CssCodeStyleSettings> codeStyleClass = provider != null ? provider.getCustomCodeStyleSettingsClass() : CssCodeStyleSettings.class;
                this.myCssFormattingSettings = (CssCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, codeStyleClass);
            }
            catch (PsiInvalidElementAccessException e) {
                this.myProject = null;
            }
        }

        public TextRange process(TextRange range) {
            if (this.myProject == null) {
                return range;
            }
            if (this.myDocument == null || !this.myCssFormattingSettings.HEX_COLOR_UPPER_CASE && !this.myCssFormattingSettings.HEX_COLOR_LOWER_CASE && !this.myCssFormattingSettings.HEX_COLOR_LONG_FORMAT && !this.myCssFormattingSettings.HEX_COLOR_SHORT_FORMAT) {
                return range;
            }
            this.myOrigRange = range;
            this.myRange = TextRange.create((int)range.getStartOffset(), (int)range.getEndOffset());
            this.myDocumentManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
            this.myElement.accept((PsiElementVisitor)this);
            this.myDocumentManager.commitDocument(this.myDocument);
            return this.myRange;
        }

        @Override
        public void visitCssTerm(CssTerm _term) {
            TextRange textRange = _term.getTextRange();
            if (this.myOrigRange.contains(textRange) && _term.getTermType() == CssTermTypes.COLOR) {
                String text = _term.getText();
                String replacementText = null;
                if (StringUtil.startsWithChar((CharSequence)text, (char)'#')) {
                    if (this.myCssFormattingSettings.HEX_COLOR_LONG_FORMAT && text.length() == 4) {
                        replacementText = CssPsiColorUtil.normalizeHexColor(text);
                    } else if (this.myCssFormattingSettings.HEX_COLOR_SHORT_FORMAT && text.length() == 7) {
                        replacementText = CssPsiColorUtil.toShortHexColor(text);
                    }
                    if (this.myCssFormattingSettings.HEX_COLOR_UPPER_CASE) {
                        replacementText = replacementText != null ? StringUtil.toUpperCase((String)replacementText) : StringUtil.toUpperCase((String)text);
                    } else if (this.myCssFormattingSettings.HEX_COLOR_LOWER_CASE) {
                        String string = replacementText = replacementText != null ? StringUtil.toLowerCase((String)replacementText) : StringUtil.toLowerCase((String)text);
                    }
                    if (replacementText != null && !text.equals(replacementText)) {
                        int delta = replacementText.length() - text.length();
                        int myRangeLength = this.myRange.getLength();
                        if (delta > 0 || myRangeLength - delta > 0) {
                            this.myRange = TextRange.from((int)this.myRange.getStartOffset(), (int)(myRangeLength + delta));
                            this.myDocument.replaceString(textRange.getStartOffset() + this.myDelta, textRange.getEndOffset() + this.myDelta, (CharSequence)replacementText);
                            this.myDelta += delta;
                        }
                    }
                }
            } else {
                this.visitElement(_term);
            }
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                CssHexColorsFormatter.$$$reportNull$$$0(0);
            }
            element.acceptChildren((PsiElementVisitor)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/editor/CssHexColorsFormatPreprocessor$CssHexColorsFormatter", "visitElement"));
        }
    }
}

