/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.endpoints;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.python.endpoints.CommonKt;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010J\n\u0010!\u001a\u0004\u0018\u00010\u000bH\u0016J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\u0011\u0010(\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u00c6\u0003J\u0011\u0010)\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005H\u00c6\u0003Ja\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005H\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\t\u00102\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00063"}, d2={"Lcom/intellij/python/endpoints/RenderedEndpoint;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "path", "Lcom/intellij/microservices/url/UrlPath;", "httpMethods", "", "", "icon", "Ljavax/swing/Icon;", "navigationPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "documentationPointer", "authorities", "Lcom/intellij/microservices/url/Authority$Exact;", "<init>", "(Lcom/intellij/microservices/url/UrlPath;Ljava/util/List;Ljavax/swing/Icon;Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/psi/SmartPsiElementPointer;Ljava/util/List;)V", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "getHttpMethods", "()Ljava/util/List;", "getIcon", "()Ljavax/swing/Icon;", "getNavigationPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getDocumentationPointer", "getAuthorities", "schemes", "getSchemes", "methods", "", "getMethods", "()Ljava/util/Set;", "resolveToPsiElement", "documentationPsiElement", "getDocumentationPsiElement", "()Lcom/intellij/psi/PsiElement;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.python.endpoints"})
@ApiStatus.Internal
public final class RenderedEndpoint
implements UrlTargetInfo {
    @NotNull
    private final UrlPath path;
    @NotNull
    private final List<String> httpMethods;
    @NotNull
    private final Icon icon;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> navigationPointer;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> documentationPointer;
    @NotNull
    private final List<Authority.Exact> authorities;
    @Nullable
    private final PsiElement documentationPsiElement;

    public RenderedEndpoint(@NotNull UrlPath path2, @NotNull List<String> httpMethods, @NotNull Icon icon, @Nullable SmartPsiElementPointer<PsiElement> navigationPointer, @Nullable SmartPsiElementPointer<PsiElement> documentationPointer, @NotNull List<Authority.Exact> authorities) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(httpMethods, (String)"httpMethods");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
        this.path = path2;
        this.httpMethods = httpMethods;
        this.icon = icon;
        this.navigationPointer = navigationPointer;
        this.documentationPointer = documentationPointer;
        this.authorities = authorities;
        this.documentationPsiElement = CommonKt.getDocumentationElement(this.documentationPointer);
    }

    @NotNull
    public UrlPath getPath() {
        return this.path;
    }

    @NotNull
    public final List<String> getHttpMethods() {
        return this.httpMethods;
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Nullable
    public final SmartPsiElementPointer<PsiElement> getNavigationPointer() {
        return this.navigationPointer;
    }

    @Nullable
    public final SmartPsiElementPointer<PsiElement> getDocumentationPointer() {
        return this.documentationPointer;
    }

    @NotNull
    public List<Authority.Exact> getAuthorities() {
        return this.authorities;
    }

    @NotNull
    public List<String> getSchemes() {
        return UrlConstants.HTTP_SCHEMES;
    }

    @NotNull
    public Set<String> getMethods() {
        return CollectionsKt.toSet((Iterable)this.httpMethods);
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        return CommonKt.getNavigationElement(this.navigationPointer);
    }

    @Nullable
    public PsiElement getDocumentationPsiElement() {
        return this.documentationPsiElement;
    }

    @NotNull
    public final UrlPath component1() {
        return this.path;
    }

    @NotNull
    public final List<String> component2() {
        return this.httpMethods;
    }

    @NotNull
    public final Icon component3() {
        return this.icon;
    }

    @Nullable
    public final SmartPsiElementPointer<PsiElement> component4() {
        return this.navigationPointer;
    }

    @Nullable
    public final SmartPsiElementPointer<PsiElement> component5() {
        return this.documentationPointer;
    }

    @NotNull
    public final List<Authority.Exact> component6() {
        return this.authorities;
    }

    @NotNull
    public final RenderedEndpoint copy(@NotNull UrlPath path2, @NotNull List<String> httpMethods, @NotNull Icon icon, @Nullable SmartPsiElementPointer<PsiElement> navigationPointer, @Nullable SmartPsiElementPointer<PsiElement> documentationPointer, @NotNull List<Authority.Exact> authorities) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(httpMethods, (String)"httpMethods");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
        return new RenderedEndpoint(path2, httpMethods, icon, navigationPointer, documentationPointer, authorities);
    }

    public static /* synthetic */ RenderedEndpoint copy$default(RenderedEndpoint renderedEndpoint, UrlPath urlPath, List list, Icon icon, SmartPsiElementPointer smartPsiElementPointer, SmartPsiElementPointer smartPsiElementPointer2, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            urlPath = renderedEndpoint.path;
        }
        if ((n & 2) != 0) {
            list = renderedEndpoint.httpMethods;
        }
        if ((n & 4) != 0) {
            icon = renderedEndpoint.icon;
        }
        if ((n & 8) != 0) {
            smartPsiElementPointer = renderedEndpoint.navigationPointer;
        }
        if ((n & 0x10) != 0) {
            smartPsiElementPointer2 = renderedEndpoint.documentationPointer;
        }
        if ((n & 0x20) != 0) {
            list2 = renderedEndpoint.authorities;
        }
        return renderedEndpoint.copy(urlPath, list, icon, smartPsiElementPointer, smartPsiElementPointer2, list2);
    }

    @NotNull
    public String toString() {
        return "RenderedEndpoint(path=" + this.path + ", httpMethods=" + this.httpMethods + ", icon=" + this.icon + ", navigationPointer=" + this.navigationPointer + ", documentationPointer=" + this.documentationPointer + ", authorities=" + this.authorities + ")";
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + ((Object)this.httpMethods).hashCode();
        result = result * 31 + this.icon.hashCode();
        result = result * 31 + (this.navigationPointer == null ? 0 : this.navigationPointer.hashCode());
        result = result * 31 + (this.documentationPointer == null ? 0 : this.documentationPointer.hashCode());
        result = result * 31 + ((Object)this.authorities).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RenderedEndpoint)) {
            return false;
        }
        RenderedEndpoint renderedEndpoint = (RenderedEndpoint)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)renderedEndpoint.path)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.httpMethods, renderedEndpoint.httpMethods)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.icon, (Object)renderedEndpoint.icon)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.navigationPointer, renderedEndpoint.navigationPointer)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.documentationPointer, renderedEndpoint.documentationPointer)) {
            return false;
        }
        return Intrinsics.areEqual(this.authorities, renderedEndpoint.authorities);
    }
}

