/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.visualization.NotebookCellInlayController;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.util.Disposer;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/notebooks/visualization/ui/ControllerEditorCellViewComponent;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "controller", "Lcom/intellij/notebooks/visualization/NotebookCellInlayController;", "editor", "Lcom/intellij/openapi/editor/Editor;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellInlayController;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "getController$intellij_notebooks_visualization", "()Lcom/intellij/notebooks/visualization/NotebookCellInlayController;", "foldedRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "updateGutterIcons", "", "gutterAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "dispose", "disposeFolding", "doViewportChange", "calculateBounds", "Ljava/awt/Rectangle;", "updateCellFolding", "updateContext", "Lcom/intellij/notebooks/visualization/UpdateContext;", "createFoldRegion", "foldingModel", "Lcom/intellij/openapi/editor/ex/FoldingModelEx;", "regionToFold", "Lkotlin/ranges/IntRange;", "doGetInlays", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/editor/Inlay;", "intellij.notebooks.visualization"})
public final class ControllerEditorCellViewComponent
extends EditorCellViewComponent {
    @NotNull
    private final NotebookCellInlayController controller;
    @NotNull
    private final Editor editor;
    @NotNull
    private final EditorCell cell;
    @Nullable
    private FoldRegion foldedRegion;

    public ControllerEditorCellViewComponent(@NotNull NotebookCellInlayController controller, @NotNull Editor editor, @NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.controller = controller;
        this.editor = editor;
        this.cell = cell;
        this.cell.getGutterAction().afterChange((Disposable)this, arg_0 -> ControllerEditorCellViewComponent._init_$lambda$0(this, arg_0));
        this.updateGutterIcons((AnAction)this.cell.getGutterAction().get());
    }

    @NotNull
    public final NotebookCellInlayController getController$intellij_notebooks_visualization() {
        return this.controller;
    }

    private final void updateGutterIcons(AnAction gutterAction) {
        Inlay<?> inlay = this.controller.getInlay();
        inlay.update();
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)((Disposable)this.controller.getInlay()));
        this.disposeFolding();
    }

    private final void disposeFolding() {
        block5: {
            block4: {
                block3: {
                    if (this.editor.isDisposed()) break block3;
                    FoldRegion foldRegion = this.foldedRegion;
                    if (foldRegion != null ? foldRegion.isValid() : false) break block4;
                }
                return;
            }
            FoldRegion foldRegion = this.foldedRegion;
            if (foldRegion == null) break block5;
            FoldRegion it = foldRegion;
            boolean bl = false;
            this.editor.getFoldingModel().runBatchFoldingOperation(() -> ControllerEditorCellViewComponent.disposeFolding$lambda$2$lambda$1(this, it), true, false);
        }
    }

    @Override
    public void doViewportChange() {
        this.controller.onViewportChange();
    }

    @Override
    @NotNull
    public Rectangle calculateBounds() {
        Rectangle rectangle = this.controller.getInlay().getBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, 0, 0);
        }
        return rectangle;
    }

    @Override
    public void updateCellFolding(@NotNull UpdateContext updateContext) {
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        updateContext.addFoldingOperation((Function1<? super FoldingModelEx, Unit>)((Function1)arg_0 -> ControllerEditorCellViewComponent.updateCellFolding$lambda$3(this, arg_0)));
    }

    private final FoldRegion createFoldRegion(FoldingModelEx foldingModel, IntRange regionToFold) {
        return foldingModel.createFoldRegion(regionToFold.getFirst(), regionToFold.getLast(), "", null, true);
    }

    @Override
    @NotNull
    public Sequence<Inlay<?>> doGetInlays() {
        Object[] objectArray = new Inlay[]{this.controller.getInlay()};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    private static final Unit _init_$lambda$0(ControllerEditorCellViewComponent this$0, AnAction action2) {
        this$0.updateGutterIcons(action2);
        return Unit.INSTANCE;
    }

    private static final void disposeFolding$lambda$2$lambda$1(ControllerEditorCellViewComponent this$0, FoldRegion $it) {
        this$0.editor.getFoldingModel().removeFoldRegion($it);
    }

    private static final Unit updateCellFolding$lambda$3(ControllerEditorCellViewComponent this$0, FoldingModelEx foldingModel) {
        Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
        Document document = this$0.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        NotebookCellLines.Interval interval = this$0.cell.getInterval();
        int cellContentStart = doc.getLineStartOffset(interval.getLines().getFirst() + 1);
        int cellEnd = doc.getLineEndOffset(interval.getLines().getLast());
        IntRange regionToFold = new IntRange(cellContentStart, cellEnd);
        if (this$0.foldedRegion != null) {
            this$0.disposeFolding();
        }
        this$0.foldedRegion = this$0.createFoldRegion(foldingModel, regionToFold);
        return Unit.INSTANCE;
    }
}

